/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.screens.inventory.ItemsIndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.inventory.SortProvider;
import fuzs.completionistsindex.client.gui.screens.inventory.StatsUpdateListener;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.util.v1.ComponentHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public abstract class IndexViewScreen<T extends SortProvider<T>>
extends StatsUpdateListener {
    public static final ResourceLocation INDEX_LOCATION = CompletionistsIndex.id("textures/gui/index.png");
    private static final Component PREVIOUS_PAGE_COMPONENT = Component.translatable((String)"spectatorMenu.previous_page");
    private static final Component NEXT_PAGE_COMPONENT = Component.translatable((String)"spectatorMenu.next_page");
    private static final Component SEARCH_HINT = Component.translatable((String)"gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_back");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_front");
    private static final RandomSource RANDOM = RandomSource.create();
    private final boolean fromInventory;
    protected int leftPos;
    protected int topPos;
    private Button turnPageBackwards;
    private Button turnPageForwards;
    private int currentPage;
    private Component leftPageIndicator;
    private Component rightPageIndicator;
    private List<IndexViewPage> pages;
    @Nullable
    private List<Component> tooltipLines;
    @Nullable
    private EditBox searchBox;
    private String lastSearch = "";
    private boolean ignoreTextInput;
    @Nullable
    private ScreenRectangle magnifierIconPlacement;
    private long randomSeed;

    protected IndexViewScreen(Screen lastScreen, boolean fromInventory) {
        super(lastScreen);
        this.fromInventory = fromInventory;
    }

    protected abstract Stream<IndexViewPage.Entry> getPageEntries();

    protected void rebuildPages() {
        RANDOM.setSeed(this.randomSeed);
        List<IndexViewPage.Entry> entries = this.getPageEntries().filter(entry -> entry.getString().toLowerCase(Locale.ROOT).contains(this.getSearchQuery())).sorted(this.getSortProvider().getComparator()).toList();
        this.pages = IndexViewPage.createPages(this, entries);
        this.setCurrentPage(0);
    }

    @Override
    protected void init() {
        this.leftPos = (this.width - 316) / 2;
        this.topPos = (this.height - 198) / 2;
        this.randomSeed = RANDOM.nextLong();
        this.magnifierIconPlacement = ScreenRectangle.of((ScreenAxis)ScreenAxis.HORIZONTAL, (int)(this.leftPos + 6 + 18), (int)(this.topPos - 23 + 5), (int)16, (int)16);
        Font font = this.minecraft.font;
        Objects.requireNonNull(this.font);
        this.searchBox = new EditBox(font, this.leftPos + 6 + 43, this.topPos - 23 + 6, 81, 9 + 5, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(0xFFFFFF);
        this.searchBox.setHint(SEARCH_HINT);
        this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + 316 - 6 - 26 + 5, this.topPos - 23 + 5, 16, 16, 321, 50, 23, INDEX_LOCATION, 512, 256, button -> this.onClose()));
        ((SpritelessImageButton)this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + 316 - 17 - 16, this.topPos + 11, 16, 13, 62, 202, 20, INDEX_LOCATION, 512, 256, button -> {
            this.setSortProvider((SortProvider)this.getSortProvider().cycle());
            button.setTooltip(Tooltip.create((Component)this.getSortProvider().getComponent()));
            this.rebuildPages();
        }))).setTooltip(Tooltip.create((Component)this.getSortProvider().getComponent()));
        this.turnPageBackwards = (Button)this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + 27, this.topPos + 173, 18, 10, 1, 203, 20, INDEX_LOCATION, 512, 256, button -> this.decrementPage()));
        this.turnPageBackwards.setTooltip(Tooltip.create((Component)PREVIOUS_PAGE_COMPONENT));
        this.turnPageForwards = (Button)this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + 316 - 27 - 18, this.topPos + 173, 18, 10, 21, 203, 20, INDEX_LOCATION, 512, 256, button -> this.incrementPage()));
        this.turnPageForwards.setTooltip(Tooltip.create((Component)NEXT_PAGE_COMPONENT));
        this.setCurrentPage(this.currentPage);
        this.resetLastSearch();
    }

    private void resetLastSearch() {
        this.lastSearch = "";
    }

    protected abstract T getSortProvider();

    protected abstract void setSortProvider(T var1);

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.fromInventory) {
            this.renderTransparentBackground(guiGraphics);
        } else {
            super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.blit(RenderType::guiTextured, INDEX_LOCATION, this.leftPos + 6, this.topPos - 23, 316.0f, 22.0f, 146, 23, 512, 256);
        guiGraphics.blit(RenderType::guiTextured, INDEX_LOCATION, this.leftPos + 316 - 6 - 26, this.topPos - 23, 316.0f, 45.0f, 26, 23, 512, 256);
        guiGraphics.blit(RenderType::guiTextured, INDEX_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, 316, 198, 512, 256);
        guiGraphics.drawString(this.font, this.leftPageIndicator, this.leftPos + 82 - this.font.width((FormattedText)this.leftPageIndicator) / 2, this.topPos + 13, 12100746, false);
        guiGraphics.drawString(this.font, this.rightPageIndicator, this.leftPos + 233 - this.font.width((FormattedText)this.rightPageIndicator) / 2, this.topPos + 13, 12100746, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.tooltipLines = null;
        this.setFocused(null);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.pages != null && !this.pages.isEmpty()) {
            this.pages.get(this.currentPage).render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.tooltipLines != null) {
            guiGraphics.renderTooltip(this.font, this.tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean mouseClickedOnMagnifier;
        this.searchBox.setFocused(false);
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.pages != null && !this.pages.isEmpty() && this.pages.get(this.currentPage).mouseClicked((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        boolean bl = mouseClickedOnMagnifier = this.magnifierIconPlacement != null && this.magnifierIconPlacement.containsPoint(Mth.floor((double)mouseX), Mth.floor((double)mouseY));
        if (mouseClickedOnMagnifier || this.searchBox.mouseClicked(mouseX, mouseY, button)) {
            this.searchBox.setFocused(true);
            return true;
        }
        return false;
    }

    private void decrementPage() {
        if (this.currentPage > 0) {
            this.setCurrentPage(this.currentPage - 1);
        }
    }

    private void incrementPage() {
        if (this.currentPage < this.getAllPages() - 1) {
            this.setCurrentPage(this.currentPage + 1);
        }
    }

    private void setCurrentPage(int newPage) {
        this.currentPage = newPage;
        this.turnPageForwards.visible = true;
        this.turnPageBackwards.visible = true;
        if (newPage == 0) {
            this.turnPageBackwards.visible = false;
        }
        if (newPage >= this.getAllPages() - 1) {
            this.turnPageForwards.visible = false;
        }
        this.leftPageIndicator = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{newPage * 2 + 1, this.getAllPages() * 2});
        this.rightPageIndicator = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{newPage * 2 + 2, this.getAllPages() * 2});
    }

    private int getAllPages() {
        return this.pages != null && !this.pages.isEmpty() ? this.pages.size() : 1;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollX > 0.0 || scrollY > 0.0) {
            this.decrementPage();
            return true;
        }
        if (scrollX < 0.0 || scrollY < 0.0) {
            this.incrementPage();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        if (this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
            this.checkSearchStringUpdate();
            return true;
        }
        if (this.minecraft.options.keyChat.matches(keyCode, scanCode) && !this.searchBox.isFocused()) {
            this.ignoreTextInput = true;
            this.searchBox.setFocused(true);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (this.searchBox.charTyped(codePoint, modifiers)) {
            this.checkSearchStringUpdate();
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    private String getSearchQuery() {
        return this.searchBox != null ? this.searchBox.getValue().trim().toLowerCase(Locale.ROOT) : "";
    }

    private void checkSearchStringUpdate() {
        String string = this.getSearchQuery();
        if (!string.equals(this.lastSearch)) {
            this.rebuildPages();
            this.lastSearch = string;
        }
    }

    public static class IndexViewPage
    implements Renderable {
        private static final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("#.##");
        private final Entry[] entries = new Entry[14];
        private final IndexViewScreen<?> screen;

        private IndexViewPage(IndexViewScreen<?> screen) {
            this.screen = screen;
        }

        public static List<IndexViewPage> createPages(IndexViewScreen<?> screen, List<Entry> entries) {
            ImmutableList.Builder builder = ImmutableList.builder();
            IndexViewPage page = null;
            int itemsCount = 0;
            for (Entry entry : entries) {
                if (page == null) {
                    page = new IndexViewPage(screen);
                    builder.add((Object)page);
                }
                page.entries[itemsCount] = entry;
                if (++itemsCount < 14) continue;
                itemsCount = 0;
                page = null;
            }
            return builder.build();
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderPageSide(guiGraphics, mouseX, mouseY, partialTick, this.screen.leftPos + 16, this.screen.topPos + 26, 0, 7);
            this.renderPageSide(guiGraphics, mouseX, mouseY, partialTick, this.screen.leftPos + 167, this.screen.topPos + 26, 7, 14);
        }

        private void renderPageSide(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int startX, int startY, int startIndex, int endIndex) {
            Entry entry;
            int posX = startX;
            int posY = startY;
            for (int i = startIndex; i < endIndex && (entry = this.entries[i]) != null; ++i) {
                int mouseXOffset = mouseX - startX;
                int mouseYOffset = mouseY - startY - i % 7 * 21;
                boolean isHoveringSlot = entry.isHoveringSlot(mouseXOffset, mouseYOffset);
                if (isHoveringSlot) {
                    guiGraphics.blitSprite(RenderType::guiTextured, SLOT_HIGHLIGHT_BACK_SPRITE, posX + 1 - 4, posY + 1 - 4, 24, 24);
                }
                entry.render(this.screen.minecraft, guiGraphics, mouseXOffset, mouseYOffset, partialTick, posX, posY);
                if (isHoveringSlot) {
                    guiGraphics.blitSprite(RenderType::guiTexturedOverlay, SLOT_HIGHLIGHT_FRONT_SPRITE, posX + 1 - 4, posY + 1 - 4, 24, 24);
                    this.screen.tooltipLines = entry.getTooltipLines();
                }
                posY += 21;
            }
        }

        public boolean mouseClicked(int mouseX, int mouseY, int buttonId) {
            for (int i = 0; i < this.entries.length; ++i) {
                int startY;
                Entry entry = this.entries[i];
                if (entry == null) {
                    return false;
                }
                int startX = i >= 7 ? this.screen.leftPos + 167 : this.screen.leftPos + 16;
                if (!entry.isMouseOver(mouseX - startX, mouseY - (startY = this.screen.topPos + 26) - i % 7 * 21)) continue;
                return entry.mouseClicked((Screen)this.screen, mouseX, mouseY, buttonId);
            }
            return false;
        }

        public static Entry createGroupEntry(Component modName, List<ItemStack> items, StatsCounter statsCounter, Font font) {
            if (items.isEmpty()) {
                throw new IllegalArgumentException("items must not be empty");
            }
            ItemStack displayItem = items.get(RANDOM.nextInt(items.size()));
            long collectedCount = items.stream().filter(stack -> {
                int crafted;
                int pickedUp = statsCounter.getValue(Stats.ITEM_PICKED_UP, (Object)stack.getItem());
                return pickedUp + (crafted = statsCounter.getValue(Stats.ITEM_CRAFTED, (Object)stack.getItem())) > 0;
            }).count();
            boolean collected = collectedCount == (long)items.size();
            float collectionProgress = (float)collectedCount / (float)items.size();
            MutableComponent tooltipComponent = Component.empty().append(modName).append((Component)Component.literal((String)(" (" + PERCENTAGE_FORMAT.format(collectionProgress * 100.0f) + "%)")).withStyle(ChatFormatting.GOLD));
            Component formattedName = IndexViewPage.formatDisplayName(font, modName, collected, false);
            return new GroupEntry(displayItem, formattedName, collected, Collections.singletonList(tooltipComponent), (Component)Component.literal((String)(collectedCount + "/" + items.size())), collectionProgress, items);
        }

        public static Entry createSingleEntry(ItemStack itemStack, StatsCounter statsCounter, Font font) {
            int pickedUp = statsCounter.getValue(Stats.ITEM_PICKED_UP, (Object)itemStack.getItem());
            int crafted = statsCounter.getValue(Stats.ITEM_CRAFTED, (Object)itemStack.getItem());
            boolean collected = pickedUp > 0 || crafted > 0;
            Component displayName = itemStack.getItem().getName(itemStack);
            Component formattedName = IndexViewPage.formatDisplayName(font, displayName, collected, true);
            ArrayList lines = Lists.newArrayList();
            lines.add(Component.empty().append(itemStack.getItem().getName(itemStack)).withStyle(itemStack.getRarity().color()));
            itemStack.getItem().appendHoverText(itemStack, Item.TooltipContext.EMPTY, (List)lines, (TooltipFlag)TooltipFlag.NORMAL);
            if (pickedUp > 0) {
                lines.add(Component.literal((String)String.valueOf(pickedUp)).append(" ").append((Component)Component.translatable((String)"stat_type.minecraft.picked_up")).withStyle(ChatFormatting.BLUE));
            }
            if (crafted > 0) {
                lines.add(Component.literal((String)String.valueOf(crafted)).append(" ").append((Component)Component.translatable((String)"stat_type.minecraft.crafted")).withStyle(ChatFormatting.BLUE));
            }
            return new SingleEntry(itemStack, formattedName, collected, (List<Component>)ImmutableList.copyOf((Collection)lines));
        }

        private static Component formatDisplayName(Font font, Component displayName, boolean collected, boolean fullLength) {
            MutableComponent component;
            Style style = Style.EMPTY.withColor(collected ? 4957487 : ChatFormatting.BLACK.getColor());
            if (!fullLength && font.width((FormattedText)displayName) > 95) {
                FormattedText formattedText = font.getSplitter().headByWidth((FormattedText)displayName, 95 - font.width((FormattedText)CommonComponents.ELLIPSIS), style);
                component = Component.empty().append(ComponentHelper.toComponent((FormattedText)formattedText)).append(CommonComponents.ELLIPSIS);
            } else {
                component = Component.empty().append(displayName);
            }
            return component.withStyle(style);
        }

        public static abstract class Entry {
            final ItemStack item;
            final Component displayName;
            private final boolean collected;
            private final List<Component> tooltipLines;

            private Entry(ItemStack item, Component displayName, boolean collected, List<Component> tooltipLines) {
                this.item = item;
                this.displayName = displayName;
                this.collected = collected;
                this.tooltipLines = tooltipLines;
            }

            public abstract <T extends Comparable<? super T>> T toComparableKey();

            public String getString() {
                return this.displayName.getString();
            }

            public boolean isCollected() {
                return this.collected;
            }

            List<Component> getTooltipLines() {
                return this.tooltipLines;
            }

            public void render(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
                this.renderBackground(guiGraphics, mouseX, mouseY, partialTick, posX, posY);
                this.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick, posX, posY);
            }

            public boolean isHoveringSlot(int mouseX, int mouseY) {
                return this.isHovering(0, 0, 16, 16, mouseX, mouseY);
            }

            public boolean isMouseOver(int mouseX, int mouseY) {
                return this.isHovering(0, 0, 134, 18, mouseX, mouseY);
            }

            public boolean mouseClicked(Screen screen, int mouseX, int mouseY, int buttonId) {
                return false;
            }

            private boolean isHovering(int minX, int minY, int maxX, int maxY, int mouseX, int mouseY) {
                return mouseX > minX && mouseX <= maxX && mouseY > minY && mouseY <= maxY;
            }

            public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
                guiGraphics.blit(RenderType::guiTextured, INDEX_LOCATION, posX, posY, 120.0f, 208.0f, 18, 18, 512, 256);
                guiGraphics.blit(RenderType::guiTextured, INDEX_LOCATION, posX + 124, posY + 4, (float)(120 + (this.collected ? 10 : 0)), 198.0f, 10, 10, 512, 256);
            }

            public void renderForeground(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
                guiGraphics.renderItem(this.item, posX + 1, posY + 1);
            }
        }

        public static class GroupEntry
        extends Entry {
            private final Component collection;
            private final float collectionProgress;
            private final List<ItemStack> items;

            public GroupEntry(ItemStack item, Component displayName, boolean collected, List<Component> tooltipLines, Component collection, float collectionProgress, List<ItemStack> items) {
                super(item, displayName, collected, tooltipLines);
                this.collection = collection;
                this.collectionProgress = collectionProgress;
                this.items = items;
            }

            @Override
            public <T extends Comparable<? super T>> T toComparableKey() {
                return (T)this.displayName.getString();
            }

            @Override
            public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
                super.renderBackground(guiGraphics, mouseX, mouseY, partialTick, posX, posY);
                guiGraphics.blit(RenderType::guiTextured, INDEX_LOCATION, posX + 24, posY + 11, 140.0f, 198.0f, 91, 5, 512, 256);
                guiGraphics.blit(RenderType::guiTextured, INDEX_LOCATION, posX + 24, posY + 11, 140.0f, 203.0f, (int)(91.0f * this.collectionProgress), 5, 512, 256);
                if (this.isMouseOver(mouseX, mouseY)) {
                    guiGraphics.blit(RenderType::guiTextured, INDEX_LOCATION, posX - 2, posY - 2, 316.0f, 0.0f, 140, 22, 512, 256);
                }
            }

            @Override
            public void renderForeground(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
                super.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick, posX, posY);
                Font font = minecraft.font;
                guiGraphics.drawString(font, this.displayName, posX + 70 - font.width((FormattedText)this.displayName) / 2, posY, 0, false);
                guiGraphics.drawSpecial(multiBufferSource -> font.drawInBatch8xOutline(this.collection.getVisualOrderText(), (float)(posX + 70 - font.width((FormattedText)this.collection) / 2), (float)(posY + 10), 16762624, 0, guiGraphics.pose().last().pose(), multiBufferSource, 0xF000F0));
            }

            @Override
            public boolean mouseClicked(Screen screen, int mouseX, int mouseY, int buttonId) {
                screen.minecraft.setScreen((Screen)new ItemsIndexViewScreen(screen, ((IndexViewScreen)screen).fromInventory, this.items));
                screen.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
        }

        private static class SingleEntry
        extends Entry {
            public SingleEntry(ItemStack item, Component displayName, boolean collected, List<Component> tooltipLines) {
                super(item, displayName, collected, tooltipLines);
            }

            @Override
            public <T extends Comparable<? super T>> T toComparableKey() {
                return (T)BuiltInRegistries.ITEM.getKey((Object)this.item.getItem()).getPath();
            }

            @Override
            public void renderForeground(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
                super.renderForeground(minecraft, guiGraphics, mouseX, mouseY, partialTick, posX, posY);
                Font font = minecraft.font;
                Objects.requireNonNull(minecraft.font);
                SingleEntry.renderScrollingString(guiGraphics, font, this.displayName, posX + 23, posY + 4, posX + 23 + 95, posY + 4 + 9, 0);
            }

            protected static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
                SingleEntry.renderScrollingString(guiGraphics, font, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color);
            }

            protected static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
                int i = font.width((FormattedText)text);
                int j = (minY + maxY - 9) / 2 + 1;
                int k = maxX - minX;
                if (i > k) {
                    int l = i - k;
                    double d = (double)Util.getMillis() / 1000.0;
                    double e = Math.max((double)l * 0.5, 3.0);
                    double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
                    double g = Mth.lerp((double)f, (double)0.0, (double)l);
                    guiGraphics.enableScissor(minX, minY, maxX, maxY);
                    guiGraphics.drawString(font, text, minX - (int)g, j, color, false);
                    guiGraphics.disableScissor();
                } else {
                    int l = Mth.clamp((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
                    FormattedCharSequence formattedCharSequence = text.getVisualOrderText();
                    guiGraphics.drawString(font, text, l - font.width(formattedCharSequence) / 2, j, color, false);
                }
            }
        }
    }
}

