/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.effecttimerplus.util;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.effect.MobEffectInstance;

public class IndicatorUtil {
    public static final int SPRITE_BORDER = 3;

    public static int getTimerColor(MobEffectInstance effectInstance, int color, boolean warn, int warnTime, int warnColor, boolean warnFlash) {
        if (warn && effectInstance.getDuration() != -1 && effectInstance.getDuration() / 20 <= warnTime && (!warnFlash || effectInstance.getDuration() % 20 >= 10)) {
            color = warnColor;
        }
        return color;
    }

    public static String getAmplifierAsString(int amplifier) {
        int value = amplifier + 1;
        if (value > 1) {
            String key = String.format("enchantment.level.%d", value);
            if (I18n.exists((String)key)) {
                return I18n.get((String)key, (Object[])new Object[0]);
            }
            return String.valueOf(value);
        }
        return "";
    }

    public static String getDurationAsString(int durationTicks) {
        if (durationTicks == -1) {
            return "\u221e";
        }
        int seconds = durationTicks / 20;
        if (seconds >= 360000) {
            return "\u221e";
        }
        if (seconds >= 3600) {
            return seconds / 3600 + "h";
        }
        if (seconds >= 600) {
            return seconds / 60 + "m";
        }
        if (seconds >= 60) {
            int sec = seconds % 60;
            return seconds / 60 + ":" + String.valueOf(sec > 9 ? Integer.valueOf(sec) : "0" + sec);
        }
        return String.valueOf(seconds);
    }

    public static int getTextOffsetX(int locIndex, int labelWidth, int spriteWidth) {
        return switch (locIndex) {
            case 0, 6, 7 -> 3;
            case 1, 5 -> spriteWidth / 2 - labelWidth / 2;
            case 2, 3, 4 -> spriteWidth - 3 - (labelWidth - 1);
            default -> throw new IllegalStateException("Unexpected positional index outside of allowed range (0-7): " + locIndex);
        };
    }

    public static int getTextOffsetY(int locIndex, int labelHeight, int spriteHeight) {
        return switch (locIndex) {
            case 0, 1, 2 -> 3;
            case 3, 7 -> spriteHeight / 2 - labelHeight / 2;
            case 4, 5, 6 -> spriteHeight - 3 - (labelHeight - 2);
            default -> throw new IllegalStateException("Unexpected positional index outside of allowed range (0-7): " + locIndex);
        };
    }

    public static float getScaleTranslateX(int locIndex, int width, float scale) {
        return switch (locIndex) {
            case 0, 6, 7 -> 0.0f;
            case 1, 5 -> (float)width / 2.0f * (1.0f - scale);
            case 2, 3, 4 -> (float)(width - 1) * (1.0f - scale);
            default -> throw new IllegalStateException("Unexpected positional index outside of allowed range (0-7): " + locIndex);
        };
    }

    public static float getScaleTranslateY(int locIndex, int height, float scale) {
        return switch (locIndex) {
            case 0, 1, 2 -> 0.0f;
            case 3, 7 -> (float)height / 2.0f * (1.0f - scale);
            case 4, 5, 6 -> (float)(height - 2) * (1.0f - scale);
            default -> throw new IllegalStateException("Unexpected positional index outside of allowed range (0-7): " + locIndex);
        };
    }
}

