/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_pin_cushions;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.ArrowModel;
import net.minecraft.client.model.BeeStingerModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import traben.entity_pin_cushions.EntityPinCushions;

public abstract class PinCushionLayer<T extends LivingEntityRenderState, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    protected StuckInBodyLayer.PlacementStyle placementStyle;
    private final Model model;
    private final ResourceLocation texture;

    public PinCushionLayer(RenderLayerParent<T, M> renderer, Model model, ResourceLocation texture, StuckInBodyLayer.PlacementStyle placementStyle) {
        super(renderer);
        this.model = model;
        this.texture = texture;
        this.placementStyle = placementStyle;
    }

    protected abstract int numStuck();

    private void renderStuckItem(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float x, float y, float z) {
        float f = Mth.sqrt((float)(x * x + z * z));
        float g = (float)(Math.atan2(x, z) * 57.2957763671875);
        float h = (float)(Math.atan2(y, f) * 57.2957763671875);
        poseStack.mulPose(Axis.YP.rotationDegrees(g - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(h));
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(this.model.renderType(this.texture)), packedLight, OverlayTexture.NO_OVERLAY);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T renderState, float yRot, float xRot) {
        int i = this.numStuck();
        RandomSource randomSource = RandomSource.create((long)EntityPinCushions.PINCUSHION_ID);
        if (i > 0) {
            for (int j = 0; j < i; ++j) {
                Random partRand = new Random(j);
                poseStack.pushPose();
                EntityModel model = this.getParentModel();
                Pair<ModelPart, Runnable> modelPart = this.bestFromListMutable(new ArrayList<ModelPart>(model.root().children.values()), partRand, poseStack, true);
                if (modelPart == null) {
                    poseStack.popPose();
                    return;
                }
                ((Runnable)modelPart.getSecond()).run();
                float f = randomSource.nextFloat();
                float g = randomSource.nextFloat();
                float h = randomSource.nextFloat();
                if (this.placementStyle == StuckInBodyLayer.PlacementStyle.ON_SURFACE) {
                    int n = randomSource.nextInt(3);
                    switch (n) {
                        case 0: {
                            f = PinCushionLayer.snapToFace(f);
                            break;
                        }
                        case 1: {
                            g = PinCushionLayer.snapToFace(g);
                            break;
                        }
                        default: {
                            h = PinCushionLayer.snapToFace(h);
                        }
                    }
                }
                if (!((ModelPart)modelPart.getFirst()).cubes.isEmpty()) {
                    ModelPart.Cube cube = ((ModelPart)modelPart.getFirst()).getRandomCube(randomSource);
                    float k = Mth.lerp((float)f, (float)cube.minX, (float)cube.maxX) / 16.0f;
                    float l = Mth.lerp((float)g, (float)cube.minY, (float)cube.maxY) / 16.0f;
                    float m = Mth.lerp((float)h, (float)cube.minZ, (float)cube.maxZ) / 16.0f;
                    poseStack.translate(k, l, m);
                }
                f = -1.0f * (f * 2.0f - 1.0f);
                g = -1.0f * (g * 2.0f - 1.0f);
                h = -1.0f * (h * 2.0f - 1.0f);
                this.renderStuckItem(poseStack, bufferSource, packedLight, f, g, h);
                poseStack.popPose();
            }
        }
    }

    private static float snapToFace(float value) {
        return value > 0.5f ? 1.0f : 0.5f;
    }

    @Nullable
    private Pair<ModelPart, Runnable> bestFromListMutable(List<ModelPart> partsMutable, Random randomSource, PoseStack poseStack, boolean firstIteration) {
        Collections.shuffle(partsMutable, randomSource);
        for (ModelPart modelPart : partsMutable) {
            Pair<ModelPart, Runnable> child;
            if (!modelPart.visible) continue;
            if (!modelPart.cubes.isEmpty() && !modelPart.skipDraw) {
                return Pair.of((Object)modelPart, () -> modelPart.translateAndRotate(poseStack));
            }
            if (modelPart.children.isEmpty() || (child = this.bestFromListMutable(new ArrayList<ModelPart>(modelPart.children.values()), randomSource, poseStack, false)) == null) continue;
            Runnable runnable = (Runnable)child.getSecond();
            return Pair.of((Object)((ModelPart)child.getFirst()), () -> {
                modelPart.translateAndRotate(poseStack);
                runnable.run();
            });
        }
        if (firstIteration && !partsMutable.isEmpty()) {
            ModelPart part = partsMutable.get(0);
            return Pair.of((Object)part, () -> part.translateAndRotate(poseStack));
        }
        return null;
    }

    public static class BeeStingerLayer<T extends LivingEntityRenderState, M extends EntityModel<T>>
    extends PinCushionLayer<T, M> {
        private static final ResourceLocation BEE_STINGER_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/bee/bee_stinger.png");

        public BeeStingerLayer(EntityRendererProvider.Context context, LivingEntityRenderer<?, T, M> renderer) {
            super(renderer, (Model)new BeeStingerModel(context.bakeLayer(ModelLayers.BEE_STINGER)), BEE_STINGER_LOCATION, StuckInBodyLayer.PlacementStyle.ON_SURFACE);
        }

        @Override
        protected int numStuck() {
            return EntityPinCushions.PINCUSHION_COUNT_STINGER;
        }
    }

    public static class ArrowLayer<T extends LivingEntityRenderState, M extends EntityModel<T>>
    extends PinCushionLayer<T, M> {
        public ArrowLayer(EntityRendererProvider.Context context, LivingEntityRenderer<?, T, M> renderer) {
            super(renderer, (Model)new ArrowModel(context.bakeLayer(ModelLayers.ARROW)), TippableArrowRenderer.NORMAL_ARROW_LOCATION, StuckInBodyLayer.PlacementStyle.IN_CUBE);
        }

        @Override
        protected int numStuck() {
            return EntityPinCushions.PINCUSHION_COUNT_ARROW;
        }
    }
}

