/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear.api.base.json.file;

import com.daxton.fancyclear.api.method.ServerFunction;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FileJsonConfiguration {
    String path;
    String jsonString;
    JsonObject jsonObject;

    public FileJsonConfiguration(String path) {
        this.path = path;
        this.jsonString = FileJsonConfiguration.readJson(path);
        this.jsonObject = new JsonParser().parse(this.jsonString).getAsJsonObject();
    }

    public String getString(String inputKey) {
        block5: {
            try {
                if (inputKey.contains(".")) {
                    String[] keyArray = inputKey.split("\\.");
                    JsonObject jObject = null;
                    for (int i = 0; i < keyArray.length; ++i) {
                        String key = keyArray[i];
                        if (i == keyArray.length - 1) {
                            return jObject.get(key).getAsString();
                        }
                        jObject = i == 0 ? this.jsonObject.get(key).getAsJsonObject() : jObject.get(key).getAsJsonObject();
                    }
                    break block5;
                }
                return this.jsonObject.get(inputKey).getAsString();
            }
            catch (Exception exception) {
                this.printError();
            }
        }
        return "";
    }

    public double getDouble(String inputKey) {
        block5: {
            try {
                if (inputKey.contains(".")) {
                    String[] keyArray = inputKey.split("\\.");
                    JsonObject jObject = null;
                    for (int i = 0; i < keyArray.length; ++i) {
                        String key = keyArray[i];
                        if (i == keyArray.length - 1) {
                            return jObject.get(key).getAsDouble();
                        }
                        jObject = i == 0 ? this.jsonObject.get(key).getAsJsonObject() : jObject.get(key).getAsJsonObject();
                    }
                    break block5;
                }
                return this.jsonObject.get(inputKey).getAsDouble();
            }
            catch (Exception exception) {
                this.printError();
            }
        }
        return 0.0;
    }

    public int getInt(String inputKey) {
        block5: {
            try {
                if (inputKey.contains(".")) {
                    String[] keyArray = inputKey.split("\\.");
                    JsonObject jObject = null;
                    for (int i = 0; i < keyArray.length; ++i) {
                        String key = keyArray[i];
                        if (i == keyArray.length - 1) {
                            return jObject.get(key).getAsInt();
                        }
                        jObject = i == 0 ? this.jsonObject.get(key).getAsJsonObject() : jObject.get(key).getAsJsonObject();
                    }
                    break block5;
                }
                return this.jsonObject.get(inputKey).getAsInt();
            }
            catch (Exception exception) {
                this.printError();
            }
        }
        return 0;
    }

    public boolean getBoolean(String inputKey) {
        block5: {
            try {
                if (inputKey.contains(".")) {
                    String[] keyArray = inputKey.split("\\.");
                    JsonObject jObject = null;
                    for (int i = 0; i < keyArray.length; ++i) {
                        String key = keyArray[i];
                        if (i == keyArray.length - 1) {
                            return jObject.get(key).getAsBoolean();
                        }
                        jObject = i == 0 ? this.jsonObject.get(key).getAsJsonObject() : jObject.get(key).getAsJsonObject();
                    }
                    break block5;
                }
                return this.jsonObject.get(inputKey).getAsBoolean();
            }
            catch (Exception exception) {
                this.printError();
            }
        }
        return false;
    }

    public List<String> getStringList(String inputKey) {
        ArrayList<String> stringList;
        block5: {
            stringList = new ArrayList<String>();
            try {
                if (inputKey.contains(".")) {
                    String[] keyArray = inputKey.split("\\.");
                    JsonObject jObject = null;
                    for (int i = 0; i < keyArray.length; ++i) {
                        String key = keyArray[i];
                        if (i == keyArray.length - 1) {
                            JsonArray jsonArray = jObject.get(key).getAsJsonArray();
                            jsonArray.forEach(jsonElement -> stringList.add(jsonElement.getAsString()));
                            return stringList;
                        }
                        jObject = i == 0 ? this.jsonObject.get(key).getAsJsonObject() : jObject.get(key).getAsJsonObject();
                    }
                    break block5;
                }
                JsonArray jsonArray = this.jsonObject.get(inputKey).getAsJsonArray();
                jsonArray.forEach(jsonElement -> stringList.add(jsonElement.getAsString()));
                return stringList;
            }
            catch (Exception exception) {
                this.printError();
            }
        }
        return stringList;
    }

    public void test() {
        try {
            this.jsonObject.addProperty("string", "\u4fee\u6539\u503c");
        }
        catch (IllegalStateException exception) {
            exception.printStackTrace();
        }
    }

    public void set(String inputKey, Object value) {
        try {
            if (inputKey.contains(".")) {
                String[] keyArray = inputKey.split("\\.");
                JsonObject jObject = null;
                for (int i = 0; i < keyArray.length; ++i) {
                    String key = keyArray[i];
                    if (i == keyArray.length - 1) {
                        if (!(value instanceof String)) continue;
                        jObject.addProperty(inputKey, String.valueOf(value));
                        continue;
                    }
                    jObject = i == 0 ? this.jsonObject.get(key).getAsJsonObject() : jObject.get(key).getAsJsonObject();
                }
            } else {
                boolean i = false;
                if (value instanceof String) {
                    this.jsonObject.addProperty(inputKey, String.valueOf(value));
                }
            }
        }
        catch (Exception exception) {
            this.printError();
        }
    }

    public void printError() {
        ServerFunction.sendLogger("\u6c92\u6709\u9019\u500bkey");
    }

    public void print() {
        ServerFunction.sendLogger(this.jsonObject.toString());
    }

    public void save() {
        try {
            Gson gson = new Gson();
            JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(this.path));
            jsonWriter.setIndent("  ");
            gson.toJson((Object)this.jsonObject, JsonObject.class, jsonWriter);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static String readJson(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }
}

