/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear.api.configuration.file;

import com.daxton.fancyclear.api.yaml.snakeyaml.DumperOptions;
import com.daxton.fancyclear.api.yaml.snakeyaml.LoaderOptions;
import com.daxton.fancyclear.api.yaml.snakeyaml.Yaml;
import com.daxton.fancyclear.api.yaml.snakeyaml.comments.CommentEventsCollector;
import com.daxton.fancyclear.api.yaml.snakeyaml.comments.CommentType;
import com.daxton.fancyclear.api.yaml.snakeyaml.constructor.BaseConstructor;
import com.daxton.fancyclear.api.yaml.snakeyaml.emitter.Emitter;
import com.daxton.fancyclear.api.yaml.snakeyaml.error.YAMLException;
import com.daxton.fancyclear.api.yaml.snakeyaml.events.Event;
import com.daxton.fancyclear.api.yaml.snakeyaml.nodes.Node;
import com.daxton.fancyclear.api.yaml.snakeyaml.representer.Representer;
import com.daxton.fancyclear.api.yaml.snakeyaml.serializer.Serializer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;

public class BukkitYaml
extends Yaml {
    private static final Field events = BukkitYaml.getEmitterField("events");
    private static final Field blockCommentsCollector = BukkitYaml.getEmitterField("blockCommentsCollector");
    private static final Field inlineCommentsCollector = BukkitYaml.getEmitterField("inlineCommentsCollector");

    private static Field getEmitterField(String name) {
        Field field = null;
        try {
            field = Emitter.class.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return field;
    }

    public BukkitYaml(@NotNull BaseConstructor constructor, @NotNull Representer representer, @NotNull DumperOptions dumperOptions, @NotNull LoaderOptions loadingConfig) {
        super(constructor, representer, dumperOptions, loadingConfig);
    }

    @Override
    public void serialize(@NotNull Node node, @NotNull Writer output) {
        Emitter emitter = new Emitter(output, this.dumperOptions);
        if (events != null && blockCommentsCollector != null && inlineCommentsCollector != null) {
            ArrayDeque<Event> newEvents = new ArrayDeque<Event>(100);
            try {
                events.set(emitter, newEvents);
                blockCommentsCollector.set(emitter, new CommentEventsCollector(newEvents, CommentType.BLANK_LINE, CommentType.BLOCK));
                inlineCommentsCollector.set(emitter, new CommentEventsCollector(newEvents, CommentType.IN_LINE));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Could not update Yaml event queue", ex);
            }
        }
        Serializer serializer = new Serializer(emitter, this.resolver, this.dumperOptions, null);
        try {
            serializer.open();
            serializer.serialize(node);
            serializer.close();
        }
        catch (IOException ex) {
            throw new YAMLException(ex);
        }
    }
}

