/*
 * Decompiled with CFR 0.152.
 */
package com.daxton.fancyclear.config;

import com.daxton.fancyclear.FancyClear;
import com.daxton.fancyclear.api.base.JarFileUtil;
import com.daxton.fancyclear.api.base.YmlUtil;
import com.daxton.fancyclear.api.configuration.file.FileConfiguration;
import com.daxton.fancyclear.api.configuration.file.YamlConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileConfig {
    public static FileConfiguration config;
    public static FileConfiguration languageConfig;
    public static FileConfiguration blackListConfig;

    public static void createConfig() {
        for (String patch : FileConfig.getFileList()) {
            String savePath = patch.replace("resource/", "");
            JarFileUtil.resourceCopy(FancyClear.fancyClear, patch, FancyClear.getResourceFolder() + savePath, false);
        }
    }

    public static void loadConfig() {
        config = YmlUtil.getFancyClearYmlFile("config.yml");
        String languageString = config.getString("Language");
        languageConfig = YmlUtil.getFancyClearYmlFile("language/" + languageString + ".yml");
        blackListConfig = YmlUtil.getFancyClearYmlFile("black-list.yml");
    }

    public static void execute() {
        config = YamlConfiguration.loadConfiguration(new File("config/FancyClear/config.yml"));
        String languageString = config.getString("Language");
        languageConfig = YamlConfiguration.loadConfiguration(new File("config/FancyClear/language/" + languageString + ".yml"));
        blackListConfig = YamlConfiguration.loadConfiguration(new File("config/FancyClear/black-list.yml"));
    }

    public static List<String> getFileList() {
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add("resource/config.yml");
        fileList.add("resource/black-list.yml");
        fileList.add("resource/entity-id-list.yml");
        fileList.add("resource/language/Chinese_CN.yml");
        fileList.add("resource/language/Chinese_TW.yml");
        fileList.add("resource/language/English.yml");
        fileList.add("resource/language/Korean_KR.yml");
        fileList.add("resource/language/Portuguese_BR.yml");
        return fileList;
    }
}

