/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension;

import androsa.gaiadimension.client.ClientEvents;
import androsa.gaiadimension.data.GaiaAdvancements;
import androsa.gaiadimension.data.GaiaBiomeTags;
import androsa.gaiadimension.data.GaiaBlockTags;
import androsa.gaiadimension.data.GaiaDamageTags;
import androsa.gaiadimension.data.GaiaDataMaps;
import androsa.gaiadimension.data.GaiaDatapackRegistries;
import androsa.gaiadimension.data.GaiaEntityTags;
import androsa.gaiadimension.data.GaiaEquipmentAssets;
import androsa.gaiadimension.data.GaiaFluidTags;
import androsa.gaiadimension.data.GaiaItemTags;
import androsa.gaiadimension.data.GaiaLootTables;
import androsa.gaiadimension.data.GaiaRecipes;
import androsa.gaiadimension.data.provider.GaiaModelProvider;
import androsa.gaiadimension.registry.bootstrap.GaiaBiomes;
import androsa.gaiadimension.registry.helpers.GaiaConfig;
import androsa.gaiadimension.registry.helpers.RemapHelper;
import androsa.gaiadimension.registry.registration.ModBlockEntities;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModDataComponents;
import androsa.gaiadimension.registry.registration.ModDataMaps;
import androsa.gaiadimension.registry.registration.ModEffects;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.registration.ModFluids;
import androsa.gaiadimension.registry.registration.ModItems;
import androsa.gaiadimension.registry.registration.ModMenus;
import androsa.gaiadimension.registry.registration.ModPOIs;
import androsa.gaiadimension.registry.registration.ModParticles;
import androsa.gaiadimension.registry.registration.ModPredicates;
import androsa.gaiadimension.registry.registration.ModRecipes;
import androsa.gaiadimension.registry.registration.ModSlotDisplay;
import androsa.gaiadimension.registry.registration.ModSounds;
import androsa.gaiadimension.registry.registration.ModStructures;
import androsa.gaiadimension.registry.registration.ModTabs;
import androsa.gaiadimension.registry.registration.ModWorldgen;
import androsa.gaiadimension.registry.values.GaiaFluidAttributes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gaiadimension")
public class GaiaDimensionMod {
    public static final String MODID = "gaiadimension";
    public static final Logger LOGGER = LogManager.getLogger((String)"gaiadimension");
    public static GaiaConfig.ClientConfig clientConfig;
    public static GaiaConfig.CommonConfig commonConfig;

    public GaiaDimensionMod(IEventBus bus, ModContainer container) {
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::gatherClientData);
        bus.addListener(this::gatherServerData);
        bus.addListener(ModDataMaps::registerDataMaps);
        GaiaBiomes.BIOMES.register(bus);
        ModBlocks.BLOCKS.register(bus);
        ModMenus.CONTAINERS.register(bus);
        ModTabs.CREATIVE_TABS.register(bus);
        ModPOIs.POI_TYPES.register(bus);
        ModEffects.MOB_EFFECTS.register(bus);
        ModEntities.ENTITY_DATA_SERIALIZERS.register(bus);
        ModEntities.ENTITY_TYPES.register(bus);
        ModDataComponents.DATA_COMPONENTS.register(bus);
        ModFluids.FLUID_TYPES.register(bus);
        ModFluids.FLUIDS.register(bus);
        ModItems.ITEMS.register(bus);
        ModParticles.PARTICLE_TYPES.register(bus);
        ModPredicates.ENTITY_SUB_PREDICATES.register(bus);
        ModRecipes.RECIPE_BOOK_CATEGORIES.register(bus);
        ModRecipes.RECIPE_DISPLAYS.register(bus);
        ModRecipes.RECIPE_TYPES.register(bus);
        ModRecipes.RECIPE_SERIALIZERS.register(bus);
        ModBlockEntities.TILE_ENTITIES.register(bus);
        ModSlotDisplay.SLOT_DISPLAYS.register(bus);
        ModStructures.STRUCTURE_PIECES.register(bus);
        ModStructures.STRUCTURE_PROCESSORS.register(bus);
        ModStructures.STRUCTURE_TYPES.register(bus);
        ModSounds.SOUND_EVENTS.register(bus);
        ModWorldgen.BIOME_SOURCES.register(bus);
        ModWorldgen.CHUNK_GENERATORS.register(bus);
        ModWorldgen.DECORATORS.register(bus);
        ModWorldgen.FEATURES.register(bus);
        ModWorldgen.FOLIAGE_PLACERS.register(bus);
        ModWorldgen.TRUNK_PLACERS.register(bus);
        ModWorldgen.WORLD_CARVERS.register(bus);
        RemapHelper.remapEntries();
        Pair specPairC = new ModConfigSpec.Builder().configure(GaiaConfig.ClientConfig::new);
        Pair specPairB = new ModConfigSpec.Builder().configure(GaiaConfig.CommonConfig::new);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPairC.getRight());
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPairB.getRight());
        clientConfig = (GaiaConfig.ClientConfig)specPairC.getLeft();
        commonConfig = (GaiaConfig.CommonConfig)specPairB.getLeft();
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModBlocks.addStripping();
            ModBlocks.registerDispenserBehaviour();
            GaiaFluidAttributes.registerFluidInteractions();
        });
        ModBlocks.addPlants();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ClientEvents.registerBlockRenderers();
    }

    public void gatherClientData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        generator.addProvider(true, (DataProvider)new GaiaModelProvider(output));
        generator.addProvider(true, (DataProvider)new GaiaEquipmentAssets(output));
    }

    public void gatherServerData(GatherDataEvent.Server event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        GaiaBlockTags blocktags = new GaiaBlockTags(output, provider);
        generator.addProvider(true, (DataProvider)new GaiaLootTables(output, provider));
        generator.addProvider(true, (DataProvider)new GaiaRecipes.Runner(output, provider));
        generator.addProvider(true, (DataProvider)blocktags);
        generator.addProvider(true, (DataProvider)new GaiaItemTags(output, provider, blocktags.contentsGetter()));
        generator.addProvider(true, (DataProvider)new GaiaFluidTags(output, provider));
        generator.addProvider(true, (DataProvider)new GaiaDataMaps(output, provider));
        GaiaDatapackRegistries datapackEntries = new GaiaDatapackRegistries(output, provider);
        CompletableFuture datapackProvider = datapackEntries.getRegistryProvider();
        generator.addProvider(true, (DataProvider)datapackEntries);
        generator.addProvider(true, (DataProvider)new GaiaBiomeTags(output, datapackProvider));
        generator.addProvider(true, (DataProvider)new GaiaDamageTags(output, datapackProvider));
        generator.addProvider(true, (DataProvider)new GaiaEntityTags(output, datapackProvider));
        generator.addProvider(true, (DataProvider)new GaiaAdvancements(output, datapackProvider));
    }
}

