/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.advancement.criterion;

import androsa.gaiadimension.entity.GrowthSapper;
import androsa.gaiadimension.entity.data.SapperVariant;
import androsa.gaiadimension.registry.registration.ModPredicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record SapperPredicate(Optional<SapperVariant> variant) implements EntitySubPredicate
{
    public static final MapCodec<SapperPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SapperVariant.CODEC.optionalFieldOf("variant").forGetter(SapperPredicate::variant)).apply((Applicative)instance, SapperPredicate::new));

    public MapCodec<? extends EntitySubPredicate> codec() {
        return (MapCodec)ModPredicates.SAPPER.get();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 pos) {
        if (entity instanceof GrowthSapper) {
            GrowthSapper sapper = (GrowthSapper)entity;
            return this.variant.isEmpty() || sapper.getEntityVariant() == this.variant.get();
        }
        return false;
    }

    public static SapperPredicate isVariant(SapperVariant variant) {
        return new SapperPredicate(Optional.of(variant));
    }
}

