/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.registry.values.GaiaTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;
import net.neoforged.neoforge.common.util.TriState;

public class AbstractGaiaGrassBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<? extends AbstractGaiaGrassBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("dirt_block").forGetter(obj -> obj.dirt), (App)AbstractGaiaGrassBlock.propertiesCodec()).apply((Applicative)instance, AbstractGaiaGrassBlock::new));
    private final BlockState dirt;

    public AbstractGaiaGrassBlock(BlockState state, BlockBehaviour.Properties props) {
        super(props);
        this.dirt = state;
    }

    @Deprecated
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 3)) {
            return;
        }
        if (!AbstractGaiaGrassBlock.isLightEnough(state, (BlockGetter)level, pos)) {
            level.setBlockAndUpdate(pos, this.dirt);
        } else if (level.getMaxLocalRawBrightness(pos.above()) >= 9) {
            BlockState blockstate = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (level.getBlockState(blockpos) != this.dirt || !AbstractGaiaGrassBlock.isValidBonemealTargetGrass(blockstate, (LevelAccessor)level, blockpos)) continue;
                level.setBlockAndUpdate(blockpos, blockstate);
            }
        }
    }

    private static boolean isLightEnough(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = reader.getBlockState(blockpos);
        int i = LightEngine.getLightBlockInto((BlockState)state, (BlockState)blockstate, (Direction)Direction.UP, (int)blockstate.getLightBlock());
        return i < 15;
    }

    private static boolean isValidBonemealTargetGrass(BlockState state, LevelAccessor reader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return AbstractGaiaGrassBlock.isLightEnough(state, (BlockGetter)reader, pos) && !reader.getFluidState(blockpos).is(FluidTags.WATER);
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        return plant.is(GaiaTags.Blocks.GAIA_PLANTS) ? TriState.TRUE : TriState.FALSE;
    }

    public boolean isValidBonemealTarget(LevelReader reader, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
    }
}

