/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.block.blockentity.boss.AbstractSpawnerBlockEntity;
import androsa.gaiadimension.registry.helpers.PropertiesHandler;
import androsa.gaiadimension.registry.registration.ModBlockEntities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BossSpawnerBlock
extends Block
implements EntityBlock {
    public static final MapCodec<? extends BossSpawnerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BossType.CODEC.fieldOf("boss").forGetter(obj -> obj.bossType), (App)BossSpawnerBlock.propertiesCodec()).apply((Applicative)instance, BossSpawnerBlock::new));
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private final BossType bossType;

    public BossSpawnerBlock(BossType type, BlockBehaviour.Properties props) {
        super(props);
        this.bossType = type;
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.bossType.getBlockEntity().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entity) {
        return level.isClientSide() ? PropertiesHandler.getTicker(AbstractSpawnerBlockEntity::particleTick) : PropertiesHandler.getTicker(AbstractSpawnerBlockEntity::spawnTick);
    }

    @Deprecated
    public boolean triggerEvent(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        super.triggerEvent(state, worldIn, pos, id, param);
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        return tileentity != null && tileentity.triggerEvent(id, param);
    }

    @Deprecated
    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        return tileentity instanceof MenuProvider ? (MenuProvider)tileentity : null;
    }

    protected ItemStack getCloneItemStack(LevelReader worldIn, BlockPos pos, BlockState state, boolean includeData) {
        return ItemStack.EMPTY;
    }

    public static enum BossType implements StringRepresentable
    {
        MALACHITE("malachite", () -> ModBlockEntities.MALACHITE_SPAWNER.get());

        public static final StringRepresentable.EnumCodec<BossType> CODEC;
        private String name;
        private Supplier<BlockEntityType<? extends AbstractSpawnerBlockEntity<?>>> tileEntity;

        private BossType(String name, Supplier<BlockEntityType<? extends AbstractSpawnerBlockEntity<?>>> tileentity) {
            this.name = name;
            this.tileEntity = tileentity;
        }

        public BlockEntityType<? extends AbstractSpawnerBlockEntity<?>> getBlockEntity() {
            return this.tileEntity.get();
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BossType::values);
        }
    }
}

