/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CurtainBlock
extends Block {
    public static final EnumProperty<Direction.Axis> FACING = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final EnumProperty<CurtainSide> SIDE = EnumProperty.create((String)"side", CurtainSide.class);
    protected static final VoxelShape X_AABB = Block.box((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5);
    protected static final VoxelShape Z_AABB = Block.box((double)7.5, (double)0.0, (double)0.0, (double)8.5, (double)16.0, (double)16.0);

    public CurtainBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.Axis.X)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(SIDE, (Comparable)((Object)CurtainSide.SINGLE)));
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return state.getValue(FACING) == Direction.Axis.X ? X_AABB : Z_AABB;
    }

    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)OPEN) != false ? Shapes.empty() : super.getCollisionShape(state, getter, pos, context);
    }

    @Deprecated
    public BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess ticker, BlockPos pos, Direction direction, BlockPos nPos, BlockState neighbor, RandomSource random) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.UPPER != (direction == Direction.DOWN)) {
            return state.getValue(HALF) == DoubleBlockHalf.UPPER && direction == Direction.UP && !state.canSurvive(reader, pos) ? Blocks.AIR.defaultBlockState() : this.defineHalf(state, neighbor, direction);
        }
        return neighbor.getBlock() instanceof CurtainBlock && neighbor.getValue(HALF) != half ? (BlockState)neighbor.setValue(HALF, (Comparable)half) : Blocks.AIR.defaultBlockState();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BlockState defineHalf(BlockState state, BlockState neighbor, Direction direction) {
        CurtainSide side = (CurtainSide)((Object)state.getValue(SIDE));
        boolean open = (Boolean)state.getValue((Property)OPEN);
        boolean powered = false;
        if (side != CurtainSide.SINGLE) {
            if (neighbor.getBlock() instanceof CurtainBlock) return state;
            if (side == CurtainSide.LEFT) {
                if ((direction != Direction.EAST || state.getValue(FACING) != Direction.Axis.X) && (direction != Direction.SOUTH || state.getValue(FACING) != Direction.Axis.Z)) return state;
                side = CurtainSide.SINGLE;
                open = false;
            } else {
                if (side != CurtainSide.RIGHT) return state;
                if ((direction != Direction.WEST || state.getValue(FACING) != Direction.Axis.X) && (direction != Direction.NORTH || state.getValue(FACING) != Direction.Axis.Z)) return state;
                side = CurtainSide.SINGLE;
                open = false;
            }
        }
        if (!(neighbor.getBlock() instanceof CurtainBlock) || state.getValue(FACING) != neighbor.getValue(FACING)) return (BlockState)((BlockState)((BlockState)state.setValue(SIDE, (Comparable)((Object)side))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
        if (neighbor.getValue(SIDE) == CurtainSide.RIGHT && (direction == Direction.EAST || direction == Direction.SOUTH)) {
            side = CurtainSide.LEFT;
            powered = (Boolean)neighbor.getValue((Property)POWERED);
        }
        if (neighbor.getValue(SIDE) != CurtainSide.LEFT || direction != Direction.WEST && direction != Direction.NORTH) return (BlockState)((BlockState)((BlockState)state.setValue(SIDE, (Comparable)((Object)side))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
        side = CurtainSide.RIGHT;
        powered = (Boolean)neighbor.getValue((Property)POWERED);
        return (BlockState)((BlockState)((BlockState)state.setValue(SIDE, (Comparable)((Object)side))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
    }

    @Deprecated
    public void onExplosionHit(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> stackpos) {
        if (explosion.getBlockInteraction() == Explosion.BlockInteraction.TRIGGER_BLOCK && state.getValue(HALF) == DoubleBlockHalf.UPPER && !level.isClientSide() && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            this.setOpen(null, (Level)level, state, pos, (Boolean)state.getValue((Property)OPEN) == false);
        }
        super.onExplosionHit(state, level, pos, explosion, stackpos);
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean closed) {
        if (state.is((Block)this) && (Boolean)state.getValue((Property)OPEN) != closed) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(closed)), 10);
            this.playSound(entity, level, pos);
            level.gameEvent(entity, (Holder)(closed ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        }
    }

    private void playSound(@Nullable Entity entity, Level level, BlockPos pos) {
        level.playSound(entity, pos, SoundEvents.AMETHYST_BLOCK_STEP, SoundSource.BLOCKS, 0.8f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        level.playSound(entity, pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf half;
        if (!level.isClientSide && (player.isCreative() || !player.hasCorrectToolForDrops(state, level, pos)) && (half = (DoubleBlockHalf)state.getValue(HALF)) == DoubleBlockHalf.LOWER && (blockstate = level.getBlockState(blockpos = pos.above())).is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockpos, blockstate1, 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Deprecated
    public boolean isPathfindable(BlockState state, PathComputationType computation) {
        return switch (computation) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.getValue((Property)OPEN);
            case PathComputationType.WATER -> false;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        if (level.getBlockState(blockpos.below()).canBeReplaced(context)) {
            boolean flag = level.hasNeighborSignal(blockpos) || level.hasNeighborSignal(blockpos.below());
            Direction.Axis axis = context.getHorizontalDirection().getAxis() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            CurtainSide half = switch (axis) {
                case Direction.Axis.X -> {
                    BlockState west = level.getBlockState(blockpos.west());
                    BlockState east = level.getBlockState(blockpos.east());
                    if (west.is((Block)this) && west.getValue(FACING) == Direction.Axis.X && west.getValue(SIDE) == CurtainSide.SINGLE) {
                        yield CurtainSide.RIGHT;
                    }
                    if (east.is((Block)this) && east.getValue(FACING) == Direction.Axis.X && east.getValue(SIDE) == CurtainSide.SINGLE) {
                        yield CurtainSide.LEFT;
                    }
                    yield CurtainSide.SINGLE;
                }
                case Direction.Axis.Z -> {
                    BlockState north = level.getBlockState(blockpos.north());
                    BlockState south = level.getBlockState(blockpos.south());
                    if (north.is((Block)this) && north.getValue(FACING) == Direction.Axis.Z && north.getValue(SIDE) == CurtainSide.SINGLE) {
                        yield CurtainSide.RIGHT;
                    }
                    if (south.is((Block)this) && south.getValue(FACING) == Direction.Axis.Z && south.getValue(SIDE) == CurtainSide.SINGLE) {
                        yield CurtainSide.LEFT;
                    }
                    yield CurtainSide.SINGLE;
                }
                default -> CurtainSide.SINGLE;
            };
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)axis)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue(SIDE, (Comparable)((Object)half));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        level.setBlock(pos.below(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
    }

    @Deprecated
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        this.openBlock(level, pos, player);
        if (state.getValue(SIDE) != CurtainSide.SINGLE) {
            if (state.getValue(SIDE) == CurtainSide.LEFT) {
                if (state.getValue(FACING) == Direction.Axis.X && level.getBlockState(pos.east()).is((Block)this)) {
                    this.openBlock(level, pos.east(), player);
                }
                if (state.getValue(FACING) == Direction.Axis.Z && level.getBlockState(pos.south()).is((Block)this)) {
                    this.openBlock(level, pos.south(), player);
                }
            }
            if (state.getValue(SIDE) == CurtainSide.RIGHT) {
                if (state.getValue(FACING) == Direction.Axis.X && level.getBlockState(pos.west()).is((Block)this)) {
                    this.openBlock(level, pos.west(), player);
                }
                if (state.getValue(FACING) == Direction.Axis.Z && level.getBlockState(pos.north()).is((Block)this)) {
                    this.openBlock(level, pos.north(), player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void openBlock(Level level, BlockPos pos, Player player) {
        BlockState state = level.getBlockState(pos);
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 10);
        this.playSound((Entity)player, level, pos);
        level.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)OPEN) != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    @Deprecated
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orient, boolean moved) {
        boolean flag;
        Direction dir = state.getValue(HALF) == DoubleBlockHalf.UPPER ? Direction.DOWN : Direction.UP;
        boolean bl = flag = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.relative(dir));
        if (!this.defaultBlockState().is(block) && flag != (Boolean)state.getValue((Property)POWERED)) {
            if (flag != (Boolean)state.getValue((Property)OPEN)) {
                this.playSound(null, level, pos);
                level.gameEvent(null, (Holder)(flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            }
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
        if (state.getValue(SIDE) != CurtainSide.SINGLE) {
            if (state.getValue(SIDE) == CurtainSide.LEFT) {
                if (state.getValue(FACING) == Direction.Axis.X && level.getBlockState(pos.east()).is((Block)this)) {
                    this.changeNeighbor(level, state, pos, pos.east(), dir);
                }
                if (state.getValue(FACING) == Direction.Axis.Z && level.getBlockState(pos.south()).is((Block)this)) {
                    this.changeNeighbor(level, state, pos, pos.south(), dir);
                }
            }
            if (state.getValue(SIDE) == CurtainSide.RIGHT) {
                if (state.getValue(FACING) == Direction.Axis.X && level.getBlockState(pos.west()).is((Block)this)) {
                    this.changeNeighbor(level, state, pos, pos.west(), dir);
                }
                if (state.getValue(FACING) == Direction.Axis.Z && level.getBlockState(pos.north()).is((Block)this)) {
                    this.changeNeighbor(level, state, pos, pos.north(), dir);
                }
            }
        }
    }

    private void changeNeighbor(Level level, BlockState state, BlockPos pos, BlockPos opposite, Direction dir) {
        boolean flag;
        BlockState neighbor = level.getBlockState(opposite);
        boolean bl = flag = level.hasNeighborSignal(pos) || level.hasNeighborSignal(opposite.relative(dir));
        if (neighbor.getValue((Property)POWERED) != state.getValue((Property)POWERED)) {
            if (flag != (Boolean)neighbor.getValue((Property)OPEN)) {
                this.playSound(null, level, opposite);
                level.gameEvent(null, (Holder)(flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), opposite);
            }
            level.setBlock(opposite, (BlockState)((BlockState)neighbor.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
        }
    }

    @Deprecated
    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = reader.getBlockState(blockpos);
        return state.getValue(HALF) == DoubleBlockHalf.UPPER ? blockstate.isFaceSturdy((BlockGetter)reader, blockpos, Direction.DOWN) : blockstate.is((Block)this);
    }

    @Deprecated
    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(FACING)) {
                    case Z: {
                        yield (BlockState)state.setValue(FACING, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue(FACING, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    @Deprecated
    public long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(this.defaultBlockState().getValue(HALF) == DoubleBlockHalf.UPPER ? 0 : 1).getY(), (int)pos.getZ());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, FACING, OPEN, POWERED, SIDE});
    }

    public static enum CurtainSide implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private CurtainSide(String name) {
            this.name = name;
        }

        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

