/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.registry.bootstrap.GaiaDimensions;
import androsa.gaiadimension.registry.helpers.GaiaConfig;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModParticles;
import androsa.gaiadimension.registry.values.GaiaTags;
import androsa.gaiadimension.world.GaiaTeleporter;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GaiaPortalBlock
extends Block
implements Portal {
    public static final MapCodec<? extends GaiaPortalBlock> CODEC = GaiaPortalBlock.simpleCodec(GaiaPortalBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    protected static final VoxelShape X_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public GaiaPortalBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.getValue(AXIS) == Direction.Axis.Z ? Z_AABB : X_AABB;
    }

    public boolean tryToCreatePortal(Level worldIn, BlockPos pos) {
        Size gaiaPortalSize = this.isPortal((LevelAccessor)worldIn, pos);
        if (gaiaPortalSize != null && this.canCreatePortalByWorld(worldIn, pos)) {
            gaiaPortalSize.placePortalBlocks((LevelAccessor)worldIn);
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(Level world, BlockPos pos) {
        if (world.dimension().location().equals((Object)GaiaConfig.startDimRL)) {
            if (((Boolean)GaiaConfig.portalCheck.get()).booleanValue()) {
                Optional biome = world.getBiome(pos).unwrapKey();
                GaiaConfig.ListType listtype = (GaiaConfig.ListType)((Object)GaiaConfig.listType.get());
                if (biome.isPresent()) {
                    return listtype == GaiaConfig.ListType.WHITELIST == world.getBiome(pos).is(GaiaTags.Biomes.PORTAL_BIOMES);
                }
                GaiaDimensionMod.LOGGER.warn("The biome doesn't appear to exist. Portal could not be created. If this issue persists, disable biome checking in the world's config.");
                return false;
            }
            return true;
        }
        return world.dimension() == GaiaDimensions.gaia_world;
    }

    @Nullable
    public Size isPortal(LevelAccessor world, BlockPos pos) {
        Size gaiaPortalSizeX = new Size((LevelReader)world, pos, Direction.Axis.X);
        if (gaiaPortalSizeX.isValid() && gaiaPortalSizeX.portalBlockCount == 0) {
            return gaiaPortalSizeX;
        }
        Size gaiaPortalSizeZ = new Size((LevelReader)world, pos, Direction.Axis.Z);
        return gaiaPortalSizeZ.isValid() && gaiaPortalSizeZ.portalBlockCount == 0 ? gaiaPortalSizeZ : null;
    }

    @Deprecated
    public BlockState updateShape(BlockState stateIn, LevelReader worldIn, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        Direction.Axis directionAxis = facing.getAxis();
        Direction.Axis directionAxis1 = (Direction.Axis)stateIn.getValue(AXIS);
        boolean flag = directionAxis1 != directionAxis && directionAxis.isHorizontal();
        return !flag && facingState.getBlock() != this && !new Size(worldIn, currentPos, directionAxis1).canCreatePortal() ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, worldIn, ticker, currentPos, facing, facingPos, facingState, random);
    }

    @Deprecated
    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        Vec3 offset;
        Direction.Axis axis;
        TeleportTransition.PostTeleportTransition transitpost;
        BlockUtil.FoundRectangle rectangle;
        ResourceKey<Level> resourcekey = level.dimension() == GaiaDimensions.gaia_world ? GaiaConfig.startDimRK : GaiaDimensions.gaia_world;
        ServerLevel destLevel = level.getServer().getLevel(resourcekey);
        if (destLevel == null) {
            return null;
        }
        GaiaTeleporter teleporter = new GaiaTeleporter(destLevel);
        WorldBorder border = destLevel.getWorldBorder();
        double scale = DimensionType.getTeleportationScale((DimensionType)level.dimensionType(), (DimensionType)destLevel.dimensionType());
        BlockPos exitPos = border.clampToBounds(entity.getX() * scale, entity.getY(), entity.getZ() * scale);
        Optional<BlockPos> optional = teleporter.getExistingPortal(exitPos, border);
        if (optional.isPresent()) {
            BlockPos portalpos = optional.get();
            BlockState blockstate = destLevel.getBlockState(portalpos);
            rectangle = BlockUtil.getLargestRectangleAround((BlockPos)portalpos, (Direction.Axis)((Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p -> destLevel.getBlockState(p) == blockstate);
            transitpost = TeleportTransition.PLAY_PORTAL_SOUND.then(e -> e.placePortalTicket(portalpos));
        } else {
            Direction.Axis axis2 = entity.level().getBlockState(pos).getOptionalValue(AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> optional1 = teleporter.makePortal(exitPos, axis2);
            if (optional1.isEmpty()) {
                GaiaDimensionMod.LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            rectangle = optional1.get();
            transitpost = TeleportTransition.PLAY_PORTAL_SOUND.then(TeleportTransition.PLACE_PORTAL_TICKET);
        }
        BlockState blockstate = entity.level().getBlockState(pos);
        if (blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            axis = (Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle rec = BlockUtil.getLargestRectangleAround((BlockPos)pos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p -> entity.level().getBlockState(p) == blockstate);
            offset = entity.getRelativePortalPosition(axis, rec);
        } else {
            axis = Direction.Axis.X;
            offset = new Vec3(0.5, 0.0, 0.0);
        }
        Vec3 speed = entity.getDeltaMovement();
        float yRot = entity.getYRot();
        float xRot = entity.getXRot();
        BlockPos posCorner = rectangle.minCorner;
        Direction.Axis stateaxis = destLevel.getBlockState(posCorner).getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        EntityDimensions dimensions = entity.getDimensions(entity.getPose());
        int rot = axis == stateaxis ? 0 : 90;
        Vec3 speedaxis = axis == stateaxis ? speed : new Vec3(speed.z, speed.y, -speed.x);
        double xrot = (double)dimensions.width() / 2.0 + (double)((float)rectangle.axis1Size - dimensions.width()) * offset.x();
        double ypos = (double)((float)rectangle.axis2Size - dimensions.height()) * offset.y();
        double zrot = 0.5 + offset.z();
        boolean isX = stateaxis == Direction.Axis.X;
        Vec3 facing = new Vec3((double)posCorner.getX() + (isX ? xrot : zrot), (double)posCorner.getY() + ypos, (double)posCorner.getZ() + (isX ? zrot : xrot));
        Vec3 vecportal = PortalShape.findCollisionFreePosition((Vec3)facing, (ServerLevel)destLevel, (Entity)entity, (EntityDimensions)dimensions);
        return new TeleportTransition(destLevel, vecportal, speedaxis, yRot + (float)rot, xRot, transitpost);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (float)pos.getX() + rand.nextFloat();
            double y = (float)pos.getY() + rand.nextFloat();
            double z = (float)pos.getZ() + rand.nextFloat();
            double sX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int mul = rand.nextInt(2) * 2 - 1;
            if (worldIn.getBlockState(pos.west()).getBlock() != this && worldIn.getBlockState(pos.east()).getBlock() != this) {
                x = (double)pos.getX() + 0.5 + 0.25 * (double)mul;
                sX = rand.nextFloat() * 2.0f * (float)mul;
            } else {
                z = (double)pos.getZ() + 0.5 + 0.25 * (double)mul;
                sZ = rand.nextFloat() * 2.0f * (float)mul;
            }
            worldIn.addParticle((ParticleOptions)ModParticles.PORTAL.get(), x, y, z, sX, sY, sZ);
        }
    }

    @Deprecated
    public BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public static class Size {
        private final LevelReader world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private static final BlockBehaviour.StatePredicate FRAME_TEST = (state, reader, pos) -> state.getBlock() == ModBlocks.keystone_block.get();
        private final Block PORTAL = (Block)ModBlocks.gaia_portal.get();

        public Size(LevelReader worldIn, BlockPos pos, Direction.Axis facing) {
            this.world = worldIn;
            this.axis = facing;
            this.rightDir = facing == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
            this.bottomLeft = this.calculateBottomLeft(pos);
            if (this.bottomLeft == null) {
                this.bottomLeft = pos;
                this.width = 1;
                this.height = 1;
            } else {
                this.width = this.calculatePortalWidth();
                if (this.width > 0) {
                    this.height = this.calculatePortalHeight();
                }
            }
        }

        @Nullable
        private BlockPos calculateBottomLeft(BlockPos pos) {
            int i = Math.max(0, pos.getY() - 21);
            while (pos.getY() > i && this.isEmptyBlock(this.world.getBlockState(pos.below()))) {
                pos = pos.below();
            }
            Direction direction = this.rightDir.getOpposite();
            int j = this.getDistanceUntilEdge(pos, direction) - 1;
            return j < 0 ? null : pos.relative(direction, j);
        }

        private int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 22; ++i) {
                mutable.set((Vec3i)pos).move(facing, i);
                BlockState state = this.world.getBlockState((BlockPos)mutable);
                if (!this.isEmptyBlock(state)) {
                    if (!FRAME_TEST.test(state, (BlockGetter)this.world, (BlockPos)mutable)) break;
                    return i;
                }
                BlockState state1 = this.world.getBlockState((BlockPos)mutable.move(Direction.DOWN));
                if (!FRAME_TEST.test(state1, (BlockGetter)this.world, (BlockPos)mutable)) break;
            }
            return 0;
        }

        private int calculatePortalWidth() {
            int dist = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
            return dist >= 2 && dist <= 21 ? dist : 0;
        }

        private int calculatePortalHeight() {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int dist = this.getDistanceUntilTop(mutable);
            return dist >= 3 && dist <= 21 && this.hasTopFrame(mutable, dist) ? dist : 0;
        }

        private int getDistanceUntilTop(BlockPos.MutableBlockPos mutable) {
            for (int i = 0; i < 21; ++i) {
                mutable.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, -1);
                if (!FRAME_TEST.test(this.world.getBlockState((BlockPos)mutable), (BlockGetter)this.world, (BlockPos)mutable)) {
                    return i;
                }
                mutable.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, this.width);
                if (!FRAME_TEST.test(this.world.getBlockState((BlockPos)mutable), (BlockGetter)this.world, (BlockPos)mutable)) {
                    return i;
                }
                for (int j = 0; j < this.width; ++j) {
                    mutable.set((Vec3i)this.bottomLeft).move(Direction.UP, i).move(this.rightDir, j);
                    BlockState blockstate = this.world.getBlockState((BlockPos)mutable);
                    if (!this.isEmptyBlock(blockstate)) {
                        return i;
                    }
                    if (blockstate.getBlock() != this.PORTAL) continue;
                    ++this.portalBlockCount;
                }
            }
            return 21;
        }

        private boolean hasTopFrame(BlockPos.MutableBlockPos mutable, int offset) {
            for (int i = 0; i < this.width; ++i) {
                BlockPos.MutableBlockPos mutablepos = mutable.set((Vec3i)this.bottomLeft).move(Direction.UP, offset).move(this.rightDir, i);
                if (FRAME_TEST.test(this.world.getBlockState((BlockPos)mutablepos), (BlockGetter)this.world, (BlockPos)mutablepos)) continue;
                return false;
            }
            return true;
        }

        private boolean isEmptyBlock(BlockState state) {
            Block block = state.getBlock();
            return state.isAir() || block == ModBlocks.gold_fire.get() || block == this.PORTAL;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks(LevelAccessor accessor) {
            BlockState state = (BlockState)this.PORTAL.defaultBlockState().setValue(AXIS, (Comparable)this.axis);
            BlockPos.betweenClosed((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.relative(Direction.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(pos -> accessor.setBlock(pos, state, 18));
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount == this.width * this.height;
        }
    }
}

