/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.block.GaiaPortalBlock;
import androsa.gaiadimension.registry.bootstrap.GaiaDimensions;
import androsa.gaiadimension.registry.helpers.GaiaConfig;
import androsa.gaiadimension.registry.registration.ModBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GoldFireBlock
extends Block {
    public static final MapCodec<? extends GoldFireBlock> CODEC = GoldFireBlock.simpleCodec(GoldFireBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_15;

    public GoldFireBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess ticker, BlockPos currentPos, Direction direction, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return this.canSurvive(state, world, currentPos) ? (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)((Integer)state.getValue((Property)AGE))) : Blocks.AIR.defaultBlockState();
    }

    @Deprecated
    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return worldIn.getBlockState(blockpos).isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP);
    }

    public int tickRate() {
        return 30;
    }

    @Deprecated
    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (worldIn.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            if (!worldIn.isAreaLoaded(pos, 2)) {
                return;
            }
            if (!state.canSurvive((LevelReader)worldIn, pos)) {
                worldIn.removeBlock(pos, false);
            }
            BlockState other = worldIn.getBlockState(pos.below());
            boolean flag = other.isFireSource((LevelReader)worldIn, pos.below(), Direction.UP);
            int i = (Integer)state.getValue((Property)AGE);
            if (!flag && worldIn.isRaining() && this.canDie((Level)worldIn, pos) && random.nextFloat() < 0.2f + (float)i * 0.03f) {
                worldIn.removeBlock(pos, false);
            } else {
                int j = Math.min(15, i + random.nextInt(3) / 2);
                if (i != j) {
                    state = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(j));
                    worldIn.setBlock(pos, state, 4);
                }
                if (!flag) {
                    worldIn.scheduleTick(pos, (Block)this, this.tickRate() + random.nextInt(10));
                    BlockPos blockpos = pos.below();
                    if (!worldIn.getBlockState(blockpos).isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP) || i > 3) {
                        worldIn.removeBlock(pos, false);
                    }
                    if (i == 15 && random.nextInt(4) == 0) {
                        worldIn.removeBlock(pos, false);
                        return;
                    }
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = -1; l <= 1; ++l) {
                    for (int i1 = -1; i1 <= 1; ++i1) {
                        for (int j1 = -1; j1 <= 4; ++j1) {
                            if (l == 0 && j1 == 0 && i1 == 0) continue;
                            blockpos$mutableblockpos.set((Vec3i)pos).move(l, j1, i1);
                        }
                    }
                }
            }
        }
    }

    protected boolean canDie(Level worldIn, BlockPos pos) {
        return worldIn.isRainingAt(pos) || worldIn.isRainingAt(pos.west()) || worldIn.isRainingAt(pos.east()) || worldIn.isRainingAt(pos.north()) || worldIn.isRainingAt(pos.south());
    }

    @Deprecated
    public void onPlace(BlockState state1, Level worldIn, BlockPos pos, BlockState state2, boolean flag) {
        if (state2.getBlock() != state1.getBlock() && (!worldIn.dimension().location().equals((Object)GaiaConfig.startDimRL) && worldIn.dimension() != GaiaDimensions.gaia_world || !((GaiaPortalBlock)((Object)ModBlocks.gaia_portal.get())).tryToCreatePortal(worldIn, pos))) {
            if (!state1.canSurvive((LevelReader)worldIn, pos)) {
                worldIn.removeBlock(pos, false);
            } else {
                worldIn.scheduleTick(pos, (Block)this, this.tickRate() + worldIn.random.nextInt(10));
            }
        }
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(24) == 0) {
            worldIn.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.getX() + rand.nextDouble();
            double d1 = (double)pos.getY() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.getZ() + rand.nextDouble();
            worldIn.addParticle((ParticleOptions)ParticleTypes.CRIT, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

