/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.entity.ISpitfireMob;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SearingRockBlock
extends Block {
    public static final MapCodec<? extends SearingRockBlock> CODEC = SearingRockBlock.simpleCodec(SearingRockBlock::new);

    public SearingRockBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public void stepOn(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        if (entityIn instanceof LivingEntity || !(entityIn instanceof ISpitfireMob)) {
            entityIn.hurt(worldIn.damageSources().hotFloor(), 2.0f);
        }
        super.stepOn(worldIn, pos, state, entityIn);
    }

    @Deprecated
    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.above();
        if (worldIn.getFluidState(pos).is(FluidTags.WATER)) {
            worldIn.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.8f);
            worldIn.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.25, (double)blockpos.getZ() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
        }
    }

    @Deprecated
    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.scheduleTick(pos, (Block)this, 20);
    }
}

