/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.block.blockentity.SmallCrateBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;

public class SmallCrateBlock
extends Block
implements EntityBlock {
    public static final MapCodec<SmallCrateBlock> CODEC = SmallCrateBlock.simpleCodec(SmallCrateBlock::new);
    public static final ResourceLocation NAME = ResourceLocation.withDefaultNamespace((String)"contents");

    public SmallCrateBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SmallCrateBlockEntity(pos, state);
    }

    @Deprecated
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (worldIn.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (player.isSpectator()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (tileentity instanceof SmallCrateBlockEntity) {
            SmallCrateBlockEntity crate = (SmallCrateBlockEntity)tileentity;
            player.openMenu((MenuProvider)crate);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (tileentity instanceof SmallCrateBlockEntity) {
            SmallCrateBlockEntity crate = (SmallCrateBlockEntity)tileentity;
            if (!worldIn.isClientSide() && player.isCreative() && !crate.isEmpty()) {
                ItemStack itemstack = new ItemStack((ItemLike)this);
                itemstack.applyComponents(tileentity.collectComponents());
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemstack);
                itementity.setDefaultPickUpDelay();
                worldIn.addFreshEntity((Entity)itementity);
            } else {
                crate.unpackLootTable(player);
            }
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    @Deprecated
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity tileentity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (tileentity instanceof SmallCrateBlockEntity) {
            SmallCrateBlockEntity crate = (SmallCrateBlockEntity)tileentity;
            builder = builder.withDynamicDrop(NAME, stack -> {
                for (int i = 0; i < crate.getContainerSize(); ++i) {
                    stack.accept(crate.getItem(i));
                }
            });
        }
        return super.getDrops(state, builder);
    }

    @Deprecated
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity = worldIn.getBlockEntity(pos);
            if (tileentity instanceof SmallCrateBlockEntity) {
                worldIn.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        if (stack.has(DataComponents.CONTAINER_LOOT)) {
            tooltip.add((Component)Component.translatable((String)"container.shulkerBox.unknownContents"));
        }
        int i = 0;
        int j = 0;
        for (ItemStack itemstack : ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()) {
            if (itemstack.isEmpty()) continue;
            ++j;
            if (i > 4) continue;
            ++i;
            tooltip.add((Component)Component.translatable((String)"container.shulkerBox.itemCount", (Object[])new Object[]{itemstack.getHoverName(), itemstack.getCount()}));
        }
        if (j - i > 0) {
            tooltip.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).withStyle(ChatFormatting.ITALIC));
        }
    }

    @Deprecated
    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Deprecated
    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Container)worldIn.getBlockEntity(pos)));
    }
}

