/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.blockentity;

import androsa.gaiadimension.block.PurifierBlock;
import androsa.gaiadimension.block.blockentity.RestructurerBlockEntity;
import androsa.gaiadimension.block.menu.PurifierMenu;
import androsa.gaiadimension.recipe.PurifierRecipe;
import androsa.gaiadimension.registry.registration.ModBlockEntities;
import androsa.gaiadimension.registry.registration.ModDataMaps;
import androsa.gaiadimension.registry.registration.ModRecipes;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PurifierBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{4, 1, 2, 3, 5};
    private static final int[] slotsSides = new int[]{1, 2, 3};
    private NonNullList<ItemStack> purifyingItemStacks = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    private int burnTime;
    private int burnDuration;
    private int cookTime;
    private int cookTimeTotal;
    protected final ContainerData slotsArray = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> PurifierBlockEntity.this.burnTime;
                case 1 -> PurifierBlockEntity.this.burnDuration;
                case 2 -> PurifierBlockEntity.this.cookTime;
                case 3 -> PurifierBlockEntity.this.cookTimeTotal;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    PurifierBlockEntity.this.burnTime = value;
                }
                case 1: {
                    PurifierBlockEntity.this.burnDuration = value;
                }
                case 2: {
                    PurifierBlockEntity.this.cookTime = value;
                }
                case 3: {
                    PurifierBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceKey<Recipe<?>>> recipeMap = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends PurifierRecipe> cache = RecipeManager.createCheck((RecipeType)((RecipeType)ModRecipes.PURIFYING.get()));

    public PurifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PURIFIER.get(), pos, state);
    }

    public Component getDefaultName() {
        return Component.translatable((String)"gaiadimension.container.purifier", (Object[])new Object[]{0});
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new PurifierMenu(id, inventory, (Container)this, this.slotsArray);
    }

    public static int getThirdFuelBurnTime(Item item) {
        Integer fuel = (Integer)item.builtInRegistryHolder().getData(ModDataMaps.NULLING_FUEL);
        return fuel != null ? fuel : 0;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.purifyingItemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.purifyingItemStacks, (HolderLookup.Provider)provider);
        this.burnTime = compound.getInt("BurnTime");
        this.cookTime = compound.getInt("CookTime");
        this.cookTimeTotal = compound.getInt("CookTimeTotal");
        this.burnDuration = this.getItemBurnTime((ItemStack)this.purifyingItemStacks.get(1), (ItemStack)this.purifyingItemStacks.get(2), (ItemStack)this.purifyingItemStacks.get(3));
        CompoundTag usedRecipes = compound.getCompound("RecipesUsed");
        for (String s : usedRecipes.getAllKeys()) {
            this.recipeMap.put((Object)ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)s)), usedRecipes.getInt(s));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("BurnTime", this.burnTime);
        compound.putInt("CookTime", this.cookTime);
        compound.putInt("CookTimeTotal", this.cookTimeTotal);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.purifyingItemStacks, (HolderLookup.Provider)provider);
        CompoundTag usedRecipes = new CompoundTag();
        this.recipeMap.forEach((key, i) -> usedRecipes.putInt(key.location().toString(), i.intValue()));
        compound.put("RecipesUsed", (Tag)usedRecipes);
    }

    public static void tick(ServerLevel level, BlockPos pos, BlockState state, PurifierBlockEntity entity) {
        boolean burning = entity.isBurning();
        boolean burn = false;
        if (entity.isBurning()) {
            --entity.burnTime;
        }
        ItemStack input = (ItemStack)entity.purifyingItemStacks.get(0);
        ItemStack goldStack = (ItemStack)entity.purifyingItemStacks.get(1);
        ItemStack essenceStack = (ItemStack)entity.purifyingItemStacks.get(2);
        ItemStack bismuthStack = (ItemStack)entity.purifyingItemStacks.get(3);
        if (entity.burnDuration == 0) {
            entity.burnDuration = entity.getItemBurnTime(goldStack, essenceStack, bismuthStack);
        }
        if (entity.isBurning() || !goldStack.isEmpty() && !essenceStack.isEmpty() && !bismuthStack.isEmpty()) {
            SingleRecipeInput recipeInput = new SingleRecipeInput(input);
            RecipeHolder recipeHolder = !((ItemStack)entity.purifyingItemStacks.get(0)).isEmpty() ? (RecipeHolder)entity.cache.getRecipeFor((RecipeInput)recipeInput, level).orElse(null) : null;
            if (!entity.isBurning() && PurifierBlockEntity.canChange(level.registryAccess(), (RecipeHolder<? extends PurifierRecipe>)recipeHolder, recipeInput, entity.purifyingItemStacks, entity.getMaxStackSize())) {
                entity.burnDuration = entity.burnTime = entity.getItemBurnTime(goldStack, essenceStack, bismuthStack);
                if (entity.isBurning()) {
                    burn = true;
                    ItemStack goldRemain = goldStack.getCraftingRemainder();
                    if (!goldRemain.isEmpty()) {
                        entity.purifyingItemStacks.set(1, (Object)goldRemain);
                    } else if (!goldStack.isEmpty()) {
                        goldStack.shrink(1);
                        if (goldStack.isEmpty()) {
                            entity.purifyingItemStacks.set(1, (Object)goldRemain);
                        }
                    }
                    ItemStack essenceRemain = essenceStack.getCraftingRemainder();
                    if (!essenceRemain.isEmpty()) {
                        entity.purifyingItemStacks.set(2, (Object)essenceRemain);
                    } else if (!essenceStack.isEmpty()) {
                        essenceStack.shrink(1);
                        if (essenceStack.isEmpty()) {
                            entity.purifyingItemStacks.set(2, (Object)essenceRemain);
                        }
                    }
                    ItemStack bismuthRemain = bismuthStack.getCraftingRemainder();
                    if (!bismuthRemain.isEmpty()) {
                        entity.purifyingItemStacks.set(3, (Object)bismuthRemain);
                    } else if (!bismuthStack.isEmpty()) {
                        bismuthStack.shrink(1);
                        if (bismuthStack.isEmpty()) {
                            entity.purifyingItemStacks.set(3, (Object)bismuthRemain);
                        }
                    }
                }
            }
            if (entity.isBurning() && PurifierBlockEntity.canChange(level.registryAccess(), (RecipeHolder<? extends PurifierRecipe>)recipeHolder, recipeInput, entity.purifyingItemStacks, entity.getMaxStackSize())) {
                ++entity.cookTime;
                if (entity.cookTime == entity.cookTimeTotal) {
                    entity.cookTime = 0;
                    entity.cookTimeTotal = PurifierBlockEntity.cookingTime(level, entity);
                    if (entity.changeItem(level.registryAccess(), (RecipeHolder<? extends PurifierRecipe>)recipeHolder, recipeInput, entity.purifyingItemStacks, entity.getMaxStackSize())) {
                        entity.setRecipeUsed(recipeHolder);
                    }
                    burn = true;
                }
            } else {
                entity.cookTime = 0;
            }
        } else if (!entity.isBurning() && entity.cookTime > 0) {
            entity.cookTime = Mth.clamp((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
        }
        if (burning != entity.isBurning()) {
            burn = true;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PurifierBlock.LIT, (Comparable)Boolean.valueOf(entity.isBurning())));
        }
        if (burn) {
            PurifierBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private static boolean canChange(RegistryAccess access, RecipeHolder<? extends PurifierRecipe> recipe, SingleRecipeInput input, NonNullList<ItemStack> stacks, int stacksize) {
        if (!((ItemStack)stacks.get(0)).isEmpty() && recipe != null) {
            ItemStack slot1 = ((PurifierRecipe)recipe.value()).assemble(input, (HolderLookup.Provider)access);
            ItemStack slot2 = ((PurifierRecipe)recipe.value()).byproduct();
            if (slot1.isEmpty() && slot2.isEmpty()) {
                return false;
            }
            ItemStack output = (ItemStack)stacks.get(4);
            ItemStack byproduct = (ItemStack)stacks.get(5);
            if (output.isEmpty() && byproduct.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)slot1) || !ItemStack.isSameItem((ItemStack)byproduct, (ItemStack)slot2)) {
                return false;
            }
            if (output.getCount() + slot1.getCount() <= stacksize && output.getCount() + slot1.getCount() <= output.getMaxStackSize() && byproduct.getCount() + slot2.getCount() <= stacksize && byproduct.getCount() + slot2.getCount() <= byproduct.getMaxStackSize()) {
                return true;
            }
            return output.getCount() + slot1.getCount() <= output.getMaxStackSize() && byproduct.getCount() + slot2.getCount() <= byproduct.getMaxStackSize();
        }
        return false;
    }

    public boolean changeItem(RegistryAccess access, RecipeHolder<? extends PurifierRecipe> recipe, SingleRecipeInput recipeInput, NonNullList<ItemStack> stacks, int stacksize) {
        if (recipe != null && PurifierBlockEntity.canChange(access, recipe, recipeInput, stacks, stacksize)) {
            ItemStack input = (ItemStack)stacks.get(0);
            ItemStack slot1 = ((PurifierRecipe)recipe.value()).assemble(recipeInput, (HolderLookup.Provider)access);
            ItemStack slot2 = ((PurifierRecipe)recipe.value()).byproduct();
            ItemStack output = (ItemStack)stacks.get(4);
            ItemStack byproduct = (ItemStack)stacks.get(5);
            if (output.isEmpty()) {
                stacks.set(4, (Object)slot1.copy());
            } else if (output.getItem() == slot1.getItem()) {
                output.grow(slot1.getCount());
            }
            if (!slot2.isEmpty()) {
                if (byproduct.isEmpty()) {
                    stacks.set(5, (Object)slot2.copy());
                } else if (byproduct.getItem() == slot2.getItem()) {
                    byproduct.grow(slot2.getCount());
                }
            }
            input.shrink(1);
            return true;
        }
        return false;
    }

    public int getItemBurnTime(ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        if (stack1.isEmpty() || stack2.isEmpty() || stack3.isEmpty()) {
            return 0;
        }
        Item itemGlitter = stack1.getItem();
        Item itemShine = stack2.getItem();
        Item itemNull = stack3.getItem();
        return (RestructurerBlockEntity.getFuelBurnTime(itemGlitter) + RestructurerBlockEntity.getSecondFuelBurnTime(itemShine) + PurifierBlockEntity.getThirdFuelBurnTime(itemNull)) / 3;
    }

    private static int cookingTime(ServerLevel level, PurifierBlockEntity container) {
        SingleRecipeInput input = new SingleRecipeInput(container.getItem(0));
        return container.cache.getRecipeFor((RecipeInput)input, level).map(recipe -> ((PurifierRecipe)recipe.value()).cookTime()).orElse(200);
    }

    public static boolean isItemFuel(ItemStack stack) {
        Item item = stack.getItem();
        return RestructurerBlockEntity.getFuelBurnTime(item) > 0 || RestructurerBlockEntity.getSecondFuelBurnTime(item) > 0 || PurifierBlockEntity.getThirdFuelBurnTime(item) > 0;
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return slotsBottom;
        }
        return side == Direction.UP ? slotsTop : slotsSides;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index == 1 || index == 2 || index == 3) {
            Item item = stack.getItem();
            return item == Items.WATER_BUCKET || item == Items.BUCKET;
        }
        return true;
    }

    public int getContainerSize() {
        return this.purifyingItemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.purifyingItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.purifyingItemStacks.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.purifyingItemStacks, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.purifyingItemStacks, (int)index);
    }

    public void setItem(int index, ItemStack stack) {
        Level level;
        ItemStack itemstack = (ItemStack)this.purifyingItemStacks.get(index);
        boolean burning = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack);
        this.purifyingItemStacks.set(index, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (index == 0 && !burning && (level = this.level) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.cookTimeTotal = PurifierBlockEntity.cookingTime(server, this);
            this.cookTime = 0;
            this.setChanged();
        }
    }

    protected NonNullList<ItemStack> getItems() {
        return this.purifyingItemStacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.purifyingItemStacks = stacks;
    }

    public boolean stillValid(Player player) {
        return this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 4 && index != 5 && (index == 0 || PurifierBlockEntity.isItemFuel(stack));
    }

    public void clearContent() {
        this.purifyingItemStacks.clear();
    }

    public void setRecipeUsed(RecipeHolder<?> recipe) {
        if (recipe != null) {
            this.recipeMap.addTo((Object)recipe.id(), 1);
        }
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> stacks) {
    }

    public void awardRecipe(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.unlockRecipe(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> holder : list) {
            if (holder == null) continue;
            player.triggerRecipeCrafted(holder, this.purifyingItemStacks);
        }
        this.recipeMap.clear();
    }

    public List<RecipeHolder<?>> unlockRecipe(ServerLevel level, Vec3 position) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipeMap.object2IntEntrySet()) {
            level.recipeAccess().byKey((ResourceKey)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                PurifierBlockEntity.grantExperience(level, position, entry.getIntValue(), ((PurifierRecipe)recipe.value()).experience());
            });
        }
        return list;
    }

    private static void grantExperience(ServerLevel level, Vec3 position, int amount, float multiplier) {
        int i = Mth.floor((float)((float)amount * multiplier));
        float f = Mth.frac((float)((float)amount * multiplier));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)position, (int)i);
    }

    public void fillStackedContents(StackedItemContents helper) {
        for (ItemStack itemstack : this.purifyingItemStacks) {
            helper.accountStack(itemstack);
        }
    }
}

