/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.blockentity.boss;

import androsa.gaiadimension.registry.registration.ModParticles;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractSpawnerBlockEntity<T extends Mob>
extends BlockEntity {
    private final EntityType<T> bossEntity;
    private boolean spawnedBoss = false;
    private final Random random = new Random();

    public AbstractSpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, EntityType<T> boss) {
        super(type, pos, state);
        this.bossEntity = boss;
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, AbstractSpawnerBlockEntity entity) {
        if (entity.isInRange() && !entity.spawnedBoss) {
            float r = (float)(entity.getColor() >> 16 & 0xFF) / 255.0f;
            float g = (float)(entity.getColor() >> 8 & 0xFF) / 255.0f;
            float b = (float)(entity.getColor() >> 0 & 0xFF) / 255.0f;
            double xPos = (double)pos.getX() + 0.5 + (entity.random.nextDouble() - 0.5);
            double yPos = (double)pos.getY() + 0.5 + (entity.random.nextDouble() - 0.5);
            double zPos = (double)pos.getZ() + 0.5 + (entity.random.nextDouble() - 0.5);
            level.addParticle((ParticleOptions)ModParticles.SPAWNER_CORE.get(), xPos, yPos, zPos, (double)r, (double)g, (double)b);
        }
    }

    public static void spawnTick(Level level, BlockPos pos, BlockState state, AbstractSpawnerBlockEntity entity) {
        if (entity.isInRange() && !entity.spawnedBoss && level.getDifficulty() != Difficulty.PEACEFUL && entity.canSpawnBoss((ServerLevel)level)) {
            level.destroyBlock(entity.getBlockPos(), false);
            entity.spawnedBoss = true;
        }
    }

    public boolean isInRange() {
        return this.getLevel().hasNearbyAlivePlayer((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, this.getSpawnerRange());
    }

    public abstract double getSpawnerRange();

    public abstract int getColor();

    private boolean canSpawnBoss(ServerLevel world) {
        EntitySpawnReason reason = EntitySpawnReason.SPAWNER;
        Mob entity = (Mob)this.bossEntity.create((Level)world, reason);
        entity.moveTo(this.getBlockPos(), 0.0f, 0.0f);
        entity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(this.getBlockPos()), reason, null);
        entity.restrictTo(this.getBlockPos(), this.getHomeDistance());
        return world.addFreshEntity((Entity)entity);
    }

    public abstract int getHomeDistance();
}

