/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.menu;

import androsa.gaiadimension.block.blockentity.PurifierBlockEntity;
import androsa.gaiadimension.block.menu.slots.GoldSlot;
import androsa.gaiadimension.block.menu.slots.NullSlot;
import androsa.gaiadimension.block.menu.slots.PurifyOutputSlot;
import androsa.gaiadimension.block.menu.slots.ShineSlot;
import androsa.gaiadimension.recipe.PurifierRecipe;
import androsa.gaiadimension.registry.registration.ModMenus;
import androsa.gaiadimension.registry.registration.ModRecipes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PurifierMenu
extends AbstractContainerMenu {
    private final Container tilePurifier;
    private final ContainerData slotsArray;
    private final Level world;
    private final RecipeType<PurifierRecipe> recipeType = (RecipeType)ModRecipes.PURIFYING.get();

    public PurifierMenu(int id, Inventory playerinv) {
        this(id, playerinv, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(4));
    }

    public PurifierMenu(int id, Inventory invPlayer, Container purifier, ContainerData slots) {
        super((MenuType)ModMenus.PURIFIER.get(), id);
        int i;
        PurifierMenu.checkContainerSize((Container)purifier, (int)6);
        PurifierMenu.checkContainerDataCount((ContainerData)slots, (int)4);
        this.tilePurifier = purifier;
        this.slotsArray = slots;
        this.world = invPlayer.player.level();
        this.addSlot(new Slot(purifier, 0, 80, 17));
        this.addSlot(new GoldSlot(purifier, 1, 59, 63));
        this.addSlot(new ShineSlot(purifier, 2, 101, 63));
        this.addSlot(new NullSlot(purifier, 3, 80, 35));
        this.addSlot(new PurifyOutputSlot(invPlayer.player, purifier, 4, 46, 91));
        this.addSlot(new PurifyOutputSlot(invPlayer.player, purifier, 5, 114, 91));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)invPlayer, j + i * 9 + 9, 8 + j * 18, 124 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)invPlayer, i, 8 + i * 18, 182));
        }
        this.addDataSlots(slots);
    }

    public boolean stillValid(Player player) {
        return this.tilePurifier.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemstack = slotStack.copy();
            if (index == 4 || index == 5) {
                if (!this.moveItemStackTo(slotStack, 6, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemstack);
            } else if (index != 3 && index != 2 && index != 1 && index != 0 ? (this.isRecipePresent(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : (PurifierBlockEntity.isItemFuel(slotStack) ? !this.moveItemStackTo(slotStack, 1, 4, false) : (index >= 6 && index < 30 ? !this.moveItemStackTo(slotStack, 30, 39, false) : index >= 31 && index < 40 && !this.moveItemStackTo(slotStack, 6, 30, false)))) : !this.moveItemStackTo(slotStack, 6, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemstack;
    }

    private boolean isRecipePresent(ItemStack stack) {
        return this.world.recipeAccess().propertySet(ModRecipes.PURIFIER_INPUT).test(stack);
    }

    public int getTimeLeftScaled() {
        int time = this.slotsArray.get(2);
        int timeTotal = this.slotsArray.get(3);
        return timeTotal != 0 && time != 0 ? time * 24 / timeTotal : 0;
    }

    public int getTimeLeft() {
        int recipes = this.slotsArray.get(1);
        if (recipes == 0) {
            recipes = 200;
        }
        return this.slotsArray.get(0) * 20 / recipes;
    }

    public boolean isBurning() {
        return this.slotsArray.get(0) > 0;
    }
}

