/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block.menu;

import androsa.gaiadimension.block.blockentity.RestructurerBlockEntity;
import androsa.gaiadimension.block.menu.slots.GlitterOutputSlot;
import androsa.gaiadimension.block.menu.slots.GoldSlot;
import androsa.gaiadimension.block.menu.slots.ShineSlot;
import androsa.gaiadimension.recipe.RestructurerRecipe;
import androsa.gaiadimension.registry.registration.ModMenus;
import androsa.gaiadimension.registry.registration.ModRecipes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RestructurerMenu
extends AbstractContainerMenu {
    private final Container tileRestructurer;
    private final ContainerData slotsArray;
    private final Level world;
    private final RecipeType<RestructurerRecipe> recipeType = (RecipeType)ModRecipes.RESTRUCTURING.get();

    public RestructurerMenu(int id, Inventory playerinv) {
        this(id, playerinv, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(4));
    }

    public RestructurerMenu(int id, Inventory invPlayer, Container restructurer, ContainerData slots) {
        super((MenuType)ModMenus.RESTRUCTURER.get(), id);
        int i;
        RestructurerMenu.checkContainerSize((Container)restructurer, (int)5);
        RestructurerMenu.checkContainerDataCount((ContainerData)slots, (int)4);
        this.tileRestructurer = restructurer;
        this.slotsArray = slots;
        this.world = invPlayer.player.level();
        this.addSlot(new Slot(restructurer, 0, 80, 34));
        this.addSlot(new GoldSlot(restructurer, 1, 51, 17));
        this.addSlot(new ShineSlot(restructurer, 2, 109, 17));
        this.addSlot(new GlitterOutputSlot(invPlayer.player, restructurer, 3, 70, 80));
        this.addSlot(new GlitterOutputSlot(invPlayer.player, restructurer, 4, 90, 80));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)invPlayer, j + i * 9 + 9, 8 + j * 18, 115 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)invPlayer, i, 8 + i * 18, 172));
        }
        this.addDataSlots(slots);
    }

    public boolean stillValid(Player player) {
        return this.tileRestructurer.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemstack = slotStack.copy();
            if (index == 3 || index == 4) {
                if (!this.moveItemStackTo(slotStack, 5, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemstack);
            } else if (index != 2 && index != 1 && index != 0 ? (this.isRecipePresent(slotStack) ? !this.moveItemStackTo(slotStack, 0, 1, false) : (RestructurerBlockEntity.isItemFuel(slotStack) ? !this.moveItemStackTo(slotStack, 1, 3, false) : (index >= 5 && index < 30 ? !this.moveItemStackTo(slotStack, 30, 39, false) : index >= 31 && index < 40 && !this.moveItemStackTo(slotStack, 5, 30, false)))) : !this.moveItemStackTo(slotStack, 5, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemstack;
    }

    private boolean isRecipePresent(ItemStack stack) {
        return this.world.recipeAccess().propertySet(ModRecipes.RESTRUCTURER_INPUT).test(stack);
    }

    public int getTimeLeftScaled() {
        int time = this.slotsArray.get(2);
        int timeTotal = this.slotsArray.get(3);
        return timeTotal != 0 && time != 0 ? time * 24 / timeTotal : 0;
    }

    public int getTimeLeft() {
        int recipes = this.slotsArray.get(1);
        if (recipes == 0) {
            recipes = 200;
        }
        return this.slotsArray.get(0) * 13 / recipes;
    }

    public boolean isBurning() {
        return this.slotsArray.get(0) > 0;
    }
}

