/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.client;

import androsa.gaiadimension.block.screen.AgateCraftingScreen;
import androsa.gaiadimension.block.screen.GaiaStoneFurnaceScreen;
import androsa.gaiadimension.block.screen.LargeCrateScreen;
import androsa.gaiadimension.block.screen.PurifierScreen;
import androsa.gaiadimension.block.screen.RestructurerScreen;
import androsa.gaiadimension.block.screen.SmallCrateScreen;
import androsa.gaiadimension.client.GaiaDimensionRenderInfo;
import androsa.gaiadimension.item.inventory.GemPouchScreen;
import androsa.gaiadimension.particle.GaiaBreakingParticle;
import androsa.gaiadimension.particle.GaiaPortalParticle;
import androsa.gaiadimension.particle.GeyserSmokeParticle;
import androsa.gaiadimension.particle.MalachiteMagicParticle;
import androsa.gaiadimension.particle.PurifierFireParticle;
import androsa.gaiadimension.particle.PyriteParticle;
import androsa.gaiadimension.particle.RestructurerFireParticle;
import androsa.gaiadimension.particle.SpawnerCoreParticle;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModFluids;
import androsa.gaiadimension.registry.registration.ModMenus;
import androsa.gaiadimension.registry.registration.ModParticles;
import androsa.gaiadimension.registry.values.GaiaFluidAttributes;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="gaiadimension")
public class ClientEvents {
    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)worldIn, (BlockPos)pos) : 15901620, new Block[]{(Block)ModBlocks.glitter_grass.get(), (Block)ModBlocks.crystal_growth.get()});
        event.register((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)worldIn, (BlockPos)pos) : 0x606060, new Block[]{(Block)ModBlocks.murky_grass.get()});
        event.register((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)worldIn, (BlockPos)pos) : 0xA0A0A0, new Block[]{(Block)ModBlocks.soft_grass.get()});
        event.register((state, worldIn, pos, tintIndex) -> {
            if (worldIn != null && pos != null) {
                return ClientEvents.getAuraColor(pos);
            }
            return 0xFFFFFF;
        }, new Block[]{(Block)ModBlocks.aura_leaves.get()});
        event.register((state, worldIn, pos, tintIndex) -> {
            int hex;
            if (worldIn != null && pos != null) {
                int location = Math.abs(pos.getX() % 5) + Math.abs(pos.getZ() % 5);
                hex = switch (location) {
                    case 0 -> 15355917;
                    case 1 -> 16761420;
                    case 2 -> 12709158;
                    case 3 -> 6815673;
                    case 4 -> 2513647;
                    case 5 -> 6032087;
                    case 7 -> 12792040;
                    case 8 -> 16739502;
                    default -> 6109315;
                };
            } else {
                hex = 1116599;
            }
            return hex;
        }, new Block[]{(Block)ModBlocks.aura_shoot.get()});
        event.register((state, worldIn, pos, tintindex) -> worldIn != null && pos != null ? 43520 : 0xFFFFFF, new Block[]{(Block)ModBlocks.malachite_guard_spawner.get()});
    }

    public static int getBismuthColor(BlockPos pos) {
        int red = (int)((Mth.cos((float)((float)Math.toRadians(pos.getX() * 4))) + 1.0f) / 2.0f * 255.0f);
        int green = (int)((Mth.cos((float)((float)Math.toRadians(pos.getY() * 8))) + 1.0f) / 3.0f * 255.0f);
        int blue = (int)((Mth.cos((float)((float)Math.toRadians(pos.getZ() * 4))) + 1.0f) / 2.0f * 255.0f);
        red = Mth.clamp((int)red, (int)20, (int)170);
        green = Mth.clamp((int)green, (int)20, (int)160);
        blue = Mth.clamp((int)blue, (int)20, (int)200);
        return red << 16 | green << 8 | blue;
    }

    public static int getAuraColor(BlockPos pos) {
        int red = (int)((Mth.cos((float)((float)Math.toRadians((pos.getX() + 100) * 8))) + 1.0f) / 2.0f * 255.0f);
        int green = (int)((Mth.cos((float)((float)Math.toRadians((pos.getY() + 100) * 32))) + 1.0f) / 2.0f * 255.0f);
        int blue = (int)((Mth.cos((float)((float)Math.toRadians((pos.getZ() + 100) * 8))) + 1.0f) / 2.0f * 255.0f);
        red = Mth.clamp((int)red, (int)150, (int)256);
        green = Mth.clamp((int)green, (int)100, (int)220);
        blue = Mth.clamp((int)blue, (int)150, (int)256);
        return red << 16 | green << 8 | blue;
    }

    @SubscribeEvent
    public static void registerFactories(RegisterParticleProvidersEvent e) {
        e.registerSpriteSet((ParticleType)ModParticles.GEYSER_SMOKE.get(), GeyserSmokeParticle.Factory::new);
        e.registerSpriteSet((ParticleType)ModParticles.RESTRUCTURER_FIRE.get(), RestructurerFireParticle.Factory::new);
        e.registerSpriteSet((ParticleType)ModParticles.PURIFIER_FIRE.get(), PurifierFireParticle.Factory::new);
        e.registerSpriteSet((ParticleType)ModParticles.PORTAL.get(), GaiaPortalParticle.Factory::new);
        e.registerSpriteSet((ParticleType)ModParticles.PYRITE.get(), PyriteParticle.Factory::new);
        e.registerSpecial((ParticleType)ModParticles.ITEM_PEBBLE.get(), (ParticleProvider)new GaiaBreakingParticle.PebbleFactory());
        e.registerSpriteSet((ParticleType)ModParticles.SPAWNER_CORE.get(), SpawnerCoreParticle.Factory::new);
        e.registerSpriteSet((ParticleType)ModParticles.MALACHITE_MAGIC.get(), MalachiteMagicParticle.Factory::new);
    }

    @SubscribeEvent
    public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"gaia"), (DimensionSpecialEffects)new GaiaDimensionRenderInfo());
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent e) {
        e.register((MenuType)ModMenus.AGATE_CRAFTING_TABLE.get(), AgateCraftingScreen::new);
        e.register((MenuType)ModMenus.GAIA_STONE_FURNACE.get(), GaiaStoneFurnaceScreen::new);
        e.register((MenuType)ModMenus.GEMSTONE_POUCH.get(), GemPouchScreen::new);
        e.register((MenuType)ModMenus.SMALL_CRATE.get(), SmallCrateScreen::new);
        e.register((MenuType)ModMenus.LARGE_CRATE.get(), LargeCrateScreen::new);
        e.register((MenuType)ModMenus.RESTRUCTURER.get(), RestructurerScreen::new);
        e.register((MenuType)ModMenus.PURIFIER.get(), PurifierScreen::new);
    }

    public static void registerBlockRenderers() {
        ClientEvents.renderFluid(ModFluids.mineral_water_flow);
        ClientEvents.renderFluid(ModFluids.mineral_water_still);
        ClientEvents.renderFluid(ModFluids.sweet_muck_flow);
        ClientEvents.renderFluid(ModFluids.sweet_muck_still);
    }

    private static void renderFluid(Supplier<? extends Fluid> fluid) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid.get(), (RenderType)RenderType.translucent());
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent e) {
        e.registerFluidType(ClientEvents.makeFluidType(GaiaFluidAttributes.mineral_still, GaiaFluidAttributes.mineral_flow, true, null, new Vector4f(0.6875f, 0.75f, 1.0f, 1.0f)), new FluidType[]{(FluidType)ModFluids.MINERAL_WATER.get()});
        e.registerFluidType(ClientEvents.makeFluidType(GaiaFluidAttributes.superhot_still, GaiaFluidAttributes.superhot_flow, false, null, new Vector4f(0.0f, 1.0f, 1.0f, 1.0f)), new FluidType[]{(FluidType)ModFluids.SUPERHOT_MAGMA.get()});
        e.registerFluidType(ClientEvents.makeFluidType(GaiaFluidAttributes.sweet_still, GaiaFluidAttributes.sweet_flow, true, null, new Vector4f(0.5f, 0.0f, 0.5f, 1.0f)), new FluidType[]{(FluidType)ModFluids.SWEET_MUCK.get()});
        e.registerFluidType(ClientEvents.makeFluidType(GaiaFluidAttributes.bismuth_still, GaiaFluidAttributes.bismuth_flow, false, () -> ClientEvents::getBismuthColor, new Vector4f(0.5f, 0.5f, 0.5f, 1.0f)), new FluidType[]{(FluidType)ModFluids.LIQUID_BISMUTH.get()});
        e.registerFluidType(ClientEvents.makeFluidType(GaiaFluidAttributes.aura_still, GaiaFluidAttributes.aura_flow, true, () -> ClientEvents::getAuraColor, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f)), new FluidType[]{(FluidType)ModFluids.LIQUID_AURA.get()});
    }

    private static IClientFluidTypeExtensions makeFluidType(final ResourceLocation stillpath, final ResourceLocation flowingpath, final boolean overlay, final Supplier<Function<BlockPos, Integer>> color, final Vector4f fog) {
        return new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return stillpath;
            }

            public ResourceLocation getFlowingTexture() {
                return flowingpath;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return overlay ? ResourceLocation.withDefaultNamespace((String)"textures/block/water_overlay") : null;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return color != null ? (Integer)((Function)color.get()).apply(pos) | 0xFF000000 : this.getTintColor();
            }

            public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
                return fog;
            }
        };
    }
}

