/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.client;

import androsa.gaiadimension.registry.helpers.GaiaConfig;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class GaiaSkyRender {
    private static final ResourceLocation SUN_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/environment/sun.png");
    private final VertexBuffer starVBO = this.generateStars();

    public boolean render(float partialTicks, ClientLevel world, Camera camera, Matrix4f matrix, Runnable fog) {
        Minecraft minecraft = Minecraft.getInstance();
        LevelRenderer renderer = minecraft.levelRenderer;
        fog.run();
        RenderStateShard.MAIN_TARGET.setupRenderState();
        PoseStack stack = new PoseStack();
        Tesselator tesselator = Tesselator.getInstance();
        float star = GaiaSkyRender.getStarBrightness(world, partialTicks);
        int skycol = world.getSkyColor(minecraft.gameRenderer.getMainCamera().getPosition(), partialTicks);
        float red = ARGB.redFloat((int)skycol);
        float grn = ARGB.greenFloat((int)skycol);
        float blu = ARGB.blueFloat((int)skycol);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION);
        RenderSystem.setShaderColor((float)red, (float)grn, (float)blu, (float)1.0f);
        renderer.skyRenderer.topSkyBuffer.bind();
        renderer.skyRenderer.topSkyBuffer.drawWithShader(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        stack.mulPose(Axis.XP.rotationDegrees(world.getTimeOfDay(partialTicks) * 360.0f));
        float f12 = 30.0f;
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix4f1 = stack.last().pose();
        RenderSystem.depthMask((boolean)false);
        RenderType.OVERLAY_TRANSPARENCY.setupRenderState();
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_TEXTURES);
        RenderSystem.enableBlend();
        bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(0.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(1.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f1, f12, 100.0f, f12).setUv(1.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)true);
        if (star > 0.0f) {
            Matrix4fStack matrixstack = RenderSystem.getModelViewStack();
            matrixstack.pushMatrix();
            matrixstack.mul((Matrix4fc)stack.last().pose());
            RenderSystem.depthMask((boolean)false);
            RenderType.OVERLAY_TRANSPARENCY.setupRenderState();
            RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION);
            RenderSystem.setShaderColor((float)star, (float)star, (float)star, (float)star);
            RenderSystem.enableBlend();
            RenderSystem.setShaderFog((FogParameters)FogParameters.NO_FOG);
            this.starVBO.bind();
            this.starVBO.drawWithShader((Matrix4f)matrixstack, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            VertexBuffer.unbind();
            fog.run();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            matrixstack.popMatrix();
        }
        stack.popPose();
        if (camera.getEntity().getEyePosition((float)partialTicks).y - world.getLevelData().getHorizonHeight((LevelHeightAccessor)world) < 0.0) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            stack.pushPose();
            stack.translate(0.0, 12.0, 0.0);
            renderer.skyRenderer.bottomSkyBuffer.bind();
            renderer.skyRenderer.bottomSkyBuffer.drawWithShader(RenderSystem.getModelViewMatrix(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            VertexBuffer.unbind();
            stack.popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    private VertexBuffer generateStars() {
        VertexBuffer vertexBuffer = new VertexBuffer(BufferUsage.STATIC_WRITE);
        vertexBuffer.bind();
        RandomSource random = RandomSource.create((long)10842L);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int i = 0; i < 1500; ++i) {
            float x = random.nextFloat() * 2.0f - 1.0f;
            float y = random.nextFloat() * 2.0f - 1.0f;
            float z = random.nextFloat() * 2.0f - 1.0f;
            float d3 = 0.15f + random.nextFloat() * 0.1f;
            float area = x * x + y * y + z * z;
            if (!(area < 1.0f) || !(area > 0.01f)) continue;
            area = (float)(1.0 / Math.sqrt(area));
            float xPos = (x *= area) * 100.0f;
            float yPos = (y *= area) * 100.0f;
            float zPos = (z *= area) * 100.0f;
            float d8 = (float)Math.atan2(x, z);
            float d9 = (float)Math.sin(d8);
            float d10 = (float)Math.cos(d8);
            float d11 = (float)Math.atan2(Math.sqrt(x * x + z * z), y);
            float d12 = (float)Math.sin(d11);
            float d13 = (float)Math.cos(d11);
            float d14 = random.nextFloat() * (float)Math.PI * 2.0f;
            float d15 = (float)Math.sin(d14);
            float d16 = (float)Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                float d18 = (float)((j & 2) - 1) * d3;
                float d19 = (float)((j + 1 & 2) - 1) * d3;
                float d21 = d18 * d16 - d19 * d15;
                float d22 = d19 * d16 + d18 * d15;
                float d23 = d21 * d12 + 0.0f * d13;
                float d24 = 0.0f * d12 - d21 * d13;
                float d25 = d24 * d9 - d22 * d10;
                float d26 = d22 * d9 + d24 * d10;
                bufferbuilder.addVertex(xPos + d25, yPos + d23, zPos + d26);
            }
        }
        vertexBuffer.upload(bufferbuilder.buildOrThrow());
        VertexBuffer.unbind();
        return vertexBuffer;
    }

    public static float getStarBrightness(ClientLevel world, float par1) {
        LocalPlayer player = Minecraft.getInstance().player;
        Optional biome = world.getBiome(player.blockPosition()).unwrapKey();
        return biome.filter(GaiaConfig::canDisplayStars).map(biomeRegistryKey -> Float.valueOf(0.5f)).orElseGet(() -> Float.valueOf(world.getStarBrightness(par1))).floatValue();
    }
}

