/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data.provider;

import androsa.gaiadimension.block.AuraShootBlock;
import androsa.gaiadimension.block.CurtainBlock;
import androsa.gaiadimension.registry.registration.ModBlocks;
import java.util.function.Supplier;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplate;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;

public abstract class GaiaBlockStateProvider {
    private final BlockModelGenerators blockModels;
    public static final TextureSlot OVERLAY = TextureSlot.create((String)"overlay");
    public static final TextureSlot BOTTOM2 = TextureSlot.create((String)"bottom2");
    public static final TextureSlot TOP2 = TextureSlot.create((String)"top2");
    public static final TextureSlot SIDE2 = TextureSlot.create((String)"side2");
    public static final ModelTemplate CUBE_ALL_LAYERED_TEMPLATE = ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.parse((String)"gaiadimension:block/util/cube_all_2_layer")).requiredTextureSlot(TextureSlot.ALL).requiredTextureSlot(OVERLAY).build();
    public static final ModelTemplate LEAVES_TEMPLATE = ExtendedModelTemplateBuilder.builder().parent((ResourceLocation)ModelTemplates.CUBE_ALL.model.get()).requiredTextureSlot(TextureSlot.ALL).renderType("cutout").build();
    public static final ModelTemplate TRANSLUCENT_TEMPLATE = ExtendedModelTemplateBuilder.builder().parent((ResourceLocation)ModelTemplates.CUBE_ALL.model.get()).requiredTextureSlot(TextureSlot.ALL).renderType("translucent").build();
    public static final ModelTemplate GRASS_TEMPLATE = ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.parse((String)"gaiadimension:block/util/grass_block")).requiredTextureSlot(TextureSlot.BOTTOM).requiredTextureSlot(TextureSlot.TOP).requiredTextureSlot(TextureSlot.SIDE).requiredTextureSlot(OVERLAY).requiredTextureSlot(TextureSlot.PARTICLE).renderType("cutout").build();
    public static final ModelTemplate CURTAIN_BOTTOM = GaiaBlockStateProvider.curtainTemplate("_bottom");
    public static final ModelTemplate CURTAIN_TOP = GaiaBlockStateProvider.curtainTemplate("_top");
    public static final ModelTemplate CURTAIN_BOTTOM_OPEN = GaiaBlockStateProvider.curtainTemplate("_bottom_open");
    public static final ModelTemplate CURTAIN_TOP_OPEN = GaiaBlockStateProvider.curtainTemplate("_top_open");
    public static final ModelTemplate CURTAIN_BOTTOM_LEFT = GaiaBlockStateProvider.curtainTemplate("_bottom_left");
    public static final ModelTemplate CURTAIN_BOTTOM_RIGHT = GaiaBlockStateProvider.curtainTemplate("_bottom_right");
    public static final ModelTemplate CURTAIN_TOP_LEFT = GaiaBlockStateProvider.curtainTemplate("_top_left");
    public static final ModelTemplate CURTAIN_TOP_RIGHT = GaiaBlockStateProvider.curtainTemplate("_top_right");
    public static final ModelTemplate CURTAIN_BOTTOM_LEFT_OPEN = GaiaBlockStateProvider.curtainTemplate("_bottom_left_open");
    public static final ModelTemplate CURTAIN_BOTTOM_RIGHT_OPEN = GaiaBlockStateProvider.curtainTemplate("_bottom_right_open");
    public static final ModelTemplate CURTAIN_TOP_LEFT_OPEN = GaiaBlockStateProvider.curtainTemplate("_top_left_open");
    public static final ModelTemplate CURTAIN_TOP_RIGHT_OPEN = GaiaBlockStateProvider.curtainTemplate("_top_right_open");
    public static final ModelTemplate POT_CROSS_CUTOUT_TEMPLATE = ExtendedModelTemplateBuilder.builder().parent((ResourceLocation)ModelTemplates.FLOWER_POT_CROSS.model.get()).requiredTextureSlot(TextureSlot.PLANT).renderType("cutout").build();
    public static final TexturedModel.Provider LEAVES_MODEL = TexturedModel.createDefault(TextureMapping::cube, (ModelTemplate)LEAVES_TEMPLATE);
    public static final TexturedModel.Provider TRANSLUCENT_MODEL = TexturedModel.createDefault(TextureMapping::cube, (ModelTemplate)TRANSLUCENT_TEMPLATE);

    public GaiaBlockStateProvider(BlockModelGenerators blockModels) {
        this.blockModels = blockModels;
    }

    public static ModelTemplate curtainTemplate(String suffix) {
        return ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"block/util/curtain_surface")).requiredTextureSlot(TextureSlot.TEXTURE).suffix(suffix).renderType("translucent").build();
    }

    public static TextureMapping cubeAllTwoLayer(String bottom, String top) {
        return new TextureMapping().put(TextureSlot.ALL, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + bottom))).put(OVERLAY, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + top)));
    }

    public static TextureMapping log(DeferredBlock<? extends Block> base) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)base.get()), (String)"_side")).put(TextureSlot.END, TextureMapping.getBlockTexture((Block)((Block)base.get()), (String)"_end")).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)base.get()), (String)"_side"));
    }

    public static TextureMapping grass(Block block, DeferredBlock<? extends Block> bottom) {
        return new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)bottom.get()))).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side")).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)block, (String)"_side")).put(OVERLAY, TextureMapping.getBlockTexture((Block)block, (String)"_overlay"));
    }

    public static TextureMapping stair(DeferredBlock<Block> base) {
        return new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)base.get()))).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)base.get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)base.get())));
    }

    public static TextureMapping pillarStair(DeferredBlock<? extends Block> base) {
        return new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)base.get()), (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)base.get()), (String)"_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)base.get()), (String)"_top"));
    }

    public static TextureMapping slab(DeferredBlock<Block> base) {
        return new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)base.get()))).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)base.get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)base.get())));
    }

    public static TextureMapping curtain(DeferredBlock<? extends Block> block, String suffix) {
        return new TextureMapping().put(TextureSlot.TEXTURE, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)suffix));
    }

    public void basicBlock(Supplier<? extends Block> block) {
        this.blockModels.createTrivialCube(block.get());
    }

    public void leavesBlock(DeferredBlock<? extends Block> block) {
        this.blockModels.createTrivialBlock((Block)block.get(), LEAVES_MODEL);
    }

    public void translucentBlock(DeferredBlock<? extends Block> block) {
        this.blockModels.createTrivialBlock((Block)block.get(), TRANSLUCENT_MODEL);
    }

    public void pillarBlock(DeferredBlock<? extends Block> block) {
        this.blockModels.createRotatedPillarWithHorizontalVariant((Block)block.get(), TexturedModel.COLUMN, TexturedModel.COLUMN_HORIZONTAL);
    }

    public void simpleColumnBlock(DeferredBlock<Block> block) {
        this.blockModels.createTrivialBlock((Block)block.get(), TexturedModel.COLUMN_ALT);
    }

    public void topBottomBlock(DeferredBlock<Block> block) {
        this.blockModels.createTrivialBlock((Block)block.get(), TexturedModel.CUBE_TOP_BOTTOM);
    }

    public void sidedBlock(DeferredBlock<Block> block, String topSuffix, String bottomSuffix, String northSuffix, String eastSuffix, String southSuffix, String westSuffix) {
        TextureMapping mapping = new TextureMapping().put(TextureSlot.UP, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)topSuffix)).put(TextureSlot.DOWN, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)bottomSuffix)).put(TextureSlot.NORTH, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)northSuffix)).put(TextureSlot.EAST, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)eastSuffix)).put(TextureSlot.SOUTH, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)southSuffix)).put(TextureSlot.WEST, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)westSuffix)).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)northSuffix));
        ResourceLocation model = ModelTemplates.CUBE.create((Block)block.get(), mapping, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)block.get()), (ResourceLocation)model));
    }

    public void basicBlockRotated(DeferredBlock<Block> block) {
        this.basicBlockRotated(block, "solid");
    }

    public void basicBlockRotated(DeferredBlock<Block> block, String type) {
        ResourceLocation model = ModelTemplates.CUBE_ALL.extend().renderType(type).build().create((Block)block.get(), TextureMapping.cube((Block)((Block)block.get())), this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createRotatedVariant((Block)((Block)block.get()), (ResourceLocation)model));
        this.blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)model));
    }

    public void basicBlockLayered(DeferredBlock<Block> block, String suffix, String type) {
        String blockname = block.getId().getPath();
        this.basicBlockLayered(block, blockname, blockname + suffix, type);
    }

    public void basicBlockLayered(DeferredBlock<Block> block, String bottom, String top, String type) {
        ExtendedModelTemplate template = CUBE_ALL_LAYERED_TEMPLATE.extend().renderType(type).build();
        ResourceLocation location = template.create((Block)block.get(), GaiaBlockStateProvider.cubeAllTwoLayer(bottom, top), this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)block.get()), (ResourceLocation)location));
        this.blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)location));
    }

    public void layeredEmissive(DeferredBlock<Block> block, String suffix) {
        String blockname = block.getId().getPath();
        this.layeredEmissive(block, blockname, blockname + suffix);
    }

    public void layeredEmissive(DeferredBlock<Block> block, String all, String overlay) {
        ResourceLocation parent = ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"block/util/emissive_2_layer");
        ExtendedModelTemplate template = ExtendedModelTemplateBuilder.builder().parent(parent).requiredTextureSlot(TextureSlot.ALL).requiredTextureSlot(OVERLAY).renderType("cutout").build();
        TextureMapping mapping = new TextureMapping().put(TextureSlot.ALL, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + all))).put(OVERLAY, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + overlay)));
        ResourceLocation model = template.create((Block)block.get(), mapping, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)block.get()), (ResourceLocation)model));
    }

    public void logBlock(DeferredBlock<? extends Block> block) {
        ResourceLocation vertical = ModelTemplates.CUBE_COLUMN.create((Block)block.get(), GaiaBlockStateProvider.log(block), this.blockModels.modelOutput);
        ResourceLocation horizontal = ModelTemplates.CUBE_COLUMN_HORIZONTAL.create((Block)block.get(), GaiaBlockStateProvider.log(block), this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createRotatedPillarWithHorizontalVariant((Block)((Block)block.get()), (ResourceLocation)vertical, (ResourceLocation)horizontal));
    }

    public void woodBlock(DeferredBlock<RotatedPillarBlock> block, DeferredBlock<RotatedPillarBlock> log) {
        TextureMapping base = GaiaBlockStateProvider.log(log);
        TextureMapping mapping = base.copyAndUpdate(TextureSlot.END, base.get(TextureSlot.SIDE));
        ResourceLocation model = ModelTemplates.CUBE_COLUMN.create((Block)block.get(), mapping, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createAxisAlignedPillarBlock((Block)((Block)block.get()), (ResourceLocation)model));
    }

    public void stairsBlock(DeferredBlock<StairBlock> block, DeferredBlock<Block> base) {
        ResourceLocation inner = ModelTemplates.STAIRS_INNER.create((Block)block.get(), GaiaBlockStateProvider.stair(base), this.blockModels.modelOutput);
        ResourceLocation straight = ModelTemplates.STAIRS_STRAIGHT.create((Block)block.get(), GaiaBlockStateProvider.stair(base), this.blockModels.modelOutput);
        ResourceLocation outer = ModelTemplates.STAIRS_OUTER.create((Block)block.get(), GaiaBlockStateProvider.stair(base), this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createStairs((Block)((Block)block.get()), (ResourceLocation)inner, (ResourceLocation)straight, (ResourceLocation)outer));
        this.blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)straight));
    }

    public void pillarStairsBlock(DeferredBlock<StairBlock> block, DeferredBlock<? extends Block> base) {
        ResourceLocation inner = ModelTemplates.STAIRS_INNER.create((Block)block.get(), GaiaBlockStateProvider.pillarStair(base), this.blockModels.modelOutput);
        ResourceLocation straight = ModelTemplates.STAIRS_STRAIGHT.create((Block)block.get(), GaiaBlockStateProvider.pillarStair(base), this.blockModels.modelOutput);
        ResourceLocation outer = ModelTemplates.STAIRS_OUTER.create((Block)block.get(), GaiaBlockStateProvider.pillarStair(base), this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createStairs((Block)((Block)block.get()), (ResourceLocation)inner, (ResourceLocation)straight, (ResourceLocation)outer));
        this.blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)straight));
    }

    public void stairsBlockLayered(DeferredBlock<StairBlock> block, String base, String overlay, String type) {
        ResourceLocation inner_parent = ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"block/util/inner_stairs_2_layer");
        ResourceLocation straight_parent = ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"block/util/stairs_2_layer");
        ResourceLocation outer_parent = ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"block/util/outer_stairs_2_layer");
        ExtendedModelTemplate inner_template = ExtendedModelTemplateBuilder.builder().requiredTextureSlot(TextureSlot.SIDE).requiredTextureSlot(TextureSlot.TOP).requiredTextureSlot(TextureSlot.BOTTOM).requiredTextureSlot(SIDE2).requiredTextureSlot(TOP2).requiredTextureSlot(BOTTOM2).parent(inner_parent).suffix("_inner").renderType("cutout").build();
        ExtendedModelTemplate straight_template = ExtendedModelTemplateBuilder.builder().requiredTextureSlot(TextureSlot.SIDE).requiredTextureSlot(TextureSlot.TOP).requiredTextureSlot(TextureSlot.BOTTOM).requiredTextureSlot(SIDE2).requiredTextureSlot(TOP2).requiredTextureSlot(BOTTOM2).parent(straight_parent).suffix("_straight").renderType("cutout").build();
        ExtendedModelTemplate outer_template = ExtendedModelTemplateBuilder.builder().requiredTextureSlot(TextureSlot.SIDE).requiredTextureSlot(TextureSlot.TOP).requiredTextureSlot(TextureSlot.BOTTOM).requiredTextureSlot(SIDE2).requiredTextureSlot(TOP2).requiredTextureSlot(BOTTOM2).parent(outer_parent).suffix("_outer").renderType("cutout").build();
        TextureMapping mapping = new TextureMapping().put(TextureSlot.TOP, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + base))).put(TextureSlot.BOTTOM, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + base))).put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + base))).put(TOP2, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + overlay))).put(BOTTOM2, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + overlay))).put(SIDE2, ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("block/" + overlay)));
        ResourceLocation inner = inner_template.create((Block)block.get(), mapping, this.blockModels.modelOutput);
        ResourceLocation straight = straight_template.create((Block)block.get(), mapping, this.blockModels.modelOutput);
        ResourceLocation outer = outer_template.create((Block)block.get(), mapping, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createStairs((Block)((Block)block.get()), (ResourceLocation)inner, (ResourceLocation)straight, (ResourceLocation)outer));
        this.blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)straight));
    }

    public void slabBlock(DeferredBlock<SlabBlock> block, DeferredBlock<Block> doubleBlock) {
        ResourceLocation bottom = ModelTemplates.SLAB_BOTTOM.create((Block)block.get(), GaiaBlockStateProvider.slab(doubleBlock), this.blockModels.modelOutput);
        ResourceLocation top = ModelTemplates.SLAB_TOP.create((Block)block.get(), GaiaBlockStateProvider.slab(doubleBlock), this.blockModels.modelOutput);
        ResourceLocation full = ModelLocationUtils.getModelLocation((Block)((Block)doubleBlock.get()));
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSlab((Block)((Block)block.get()), (ResourceLocation)bottom, (ResourceLocation)top, (ResourceLocation)full));
        this.blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)bottom));
    }

    public void crossBlock(DeferredBlock<? extends Block> block, String type) {
        ResourceLocation location = ModelTemplates.CROSS.extend().renderType(type).build().create((Block)block.get(), TextureMapping.cross((Block)((Block)block.get())), this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)block.get()), (ResourceLocation)location));
        this.blockModels.registerSimpleItemModel(block.asItem(), this.blockModels.createFlatItemModelWithBlockTexture(block.asItem(), (Block)block.get()));
    }

    public void crossBlockTinted(DeferredBlock<Block> block) {
        ResourceLocation location = ModelTemplates.TINTED_CROSS.extend().renderType("translucent").build().create((Block)block.get(), TextureMapping.cross((Block)((Block)block.get())), this.blockModels.modelOutput);
        ResourceLocation item = this.blockModels.createFlatItemModelWithBlockTexture(block.asItem(), (Block)block.get());
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)block.get()), (ResourceLocation)location));
        this.blockModels.registerSimpleTintedItemModel((Block)block.get(), item, ItemModelUtils.constantTint((int)15901620));
    }

    public void auraShoot() {
        ResourceLocation base = ModelLocationUtils.getModelLocation((Block)((Block)ModBlocks.aura_shoot.get()));
        ResourceLocation tip = ModelLocationUtils.getModelLocation((Block)((Block)ModBlocks.aura_shoot.get()), (String)"_top");
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)ModBlocks.aura_shoot.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)AuraShootBlock.IS_TOP, (ResourceLocation)tip, (ResourceLocation)base)));
        this.blockModels.registerSimpleTintedItemModel((Block)ModBlocks.aura_shoot.get(), tip, ItemModelUtils.constantTint((int)1116599));
    }

    public void orientableBlockLit(DeferredBlock<Block> block) {
        ResourceLocation off = TexturedModel.ORIENTABLE_ONLY_TOP.create((Block)block.get(), this.blockModels.modelOutput);
        ResourceLocation frontlit = TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_front_lit");
        ResourceLocation on = TexturedModel.ORIENTABLE_ONLY_TOP.get((Block)block.get()).updateTextures(t -> t.put(TextureSlot.FRONT, frontlit)).createWithSuffix((Block)block.get(), "_lit", this.blockModels.modelOutput);
        this.orientableBlock(block, on, off);
    }

    public void orientableBlockBasicLit(DeferredBlock<Block> block) {
        TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side")).put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_front")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side"));
        ResourceLocation off = ModelTemplates.CUBE_ORIENTABLE.create((Block)block.get(), mapping, this.blockModels.modelOutput);
        TextureMapping mappinglit = new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side")).put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_front_lit")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side"));
        ResourceLocation on = ModelTemplates.CUBE_ORIENTABLE.extend().suffix("_lit").build().create((Block)block.get(), mappinglit, this.blockModels.modelOutput);
        this.orientableBlock(block, on, off);
    }

    public void orientableBlock(DeferredBlock<Block> block, ResourceLocation lit, ResourceLocation unlit) {
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)block.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (ResourceLocation)lit, (ResourceLocation)unlit)).with(BlockModelGenerators.createHorizontalFacingDispatch()));
    }

    public void grassBlock(DeferredBlock<Block> block, DeferredBlock<Block> bottom, int tint) {
        if (tint >= 0) {
            ResourceLocation model = GRASS_TEMPLATE.create((Block)block.get(), GaiaBlockStateProvider.grass((Block)block.get(), bottom), this.blockModels.modelOutput);
            this.blockModels.blockStateOutput.accept(BlockModelGenerators.createRotatedVariant((Block)((Block)block.get()), (ResourceLocation)model));
            this.blockModels.registerSimpleTintedItemModel((Block)block.get(), model, ItemModelUtils.constantTint((int)tint));
        } else {
            TextureMapping mapping = new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)((Block)bottom.get()))).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)block.get()), (String)"_side"));
            ResourceLocation model = ModelTemplates.CUBE_BOTTOM_TOP.create((Block)block.get(), mapping, this.blockModels.modelOutput);
            this.blockModels.blockStateOutput.accept(BlockModelGenerators.createRotatedVariant((Block)((Block)block.get()), (ResourceLocation)model));
            this.blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)model));
        }
    }

    public void pottedPlantBlock(DeferredBlock<? extends Block> plant, DeferredBlock<? extends Block> pot) {
        TextureMapping plantmap = TextureMapping.cross((Block)((Block)plant.get()));
        ResourceLocation plantloc = ModelTemplates.CROSS.extend().renderType("cutout").build().create((Block)plant.get(), plantmap, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)plant.get()), (ResourceLocation)plantloc));
        TextureMapping potmap = TextureMapping.plant((Block)((Block)plant.get()));
        ResourceLocation potloc = POT_CROSS_CUTOUT_TEMPLATE.create((Block)pot.get(), potmap, this.blockModels.modelOutput);
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)pot.get()), (ResourceLocation)potloc));
        this.blockModels.registerSimpleItemModel(plant.asItem(), this.blockModels.createFlatItemModelWithBlockTexture(plant.asItem(), (Block)plant.get()));
    }

    public void torchBlock(DeferredBlock<Block> block, DeferredBlock<Block> wall) {
        TextureMapping texturemapping = TextureMapping.torch((Block)((Block)block.get()));
        this.blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)block.get()), (ResourceLocation)ModelTemplates.TORCH.extend().renderType("cutout").build().create((Block)block.get(), texturemapping, this.blockModels.modelOutput)));
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)wall.get()), (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)ModelTemplates.WALL_TORCH.extend().renderType("cutout").build().create((Block)wall.get(), texturemapping, this.blockModels.modelOutput))).with(BlockModelGenerators.createTorchHorizontalDispatch()));
        this.blockModels.registerSimpleFlatItemModel((Block)block.get());
    }

    public void curtainProps(PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean> base, Direction.Axis axis, DoubleBlockHalf half, CurtainBlock.CurtainSide side, boolean open, ResourceLocation model) {
        base.select((Comparable)axis, (Comparable)half, (Comparable)((Object)side), (Comparable)Boolean.valueOf(open), Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.Y_ROT, (Object)(axis == Direction.Axis.Z ? VariantProperties.Rotation.R90 : VariantProperties.Rotation.R0)));
    }

    public void curtainBlock(DeferredBlock<? extends Block> block) {
        Block curtain = (Block)block.get();
        ResourceLocation upper = CURTAIN_TOP.create(curtain, GaiaBlockStateProvider.curtain(block, "_top"), this.blockModels.modelOutput);
        ResourceLocation lower = CURTAIN_BOTTOM.create(curtain, GaiaBlockStateProvider.curtain(block, "_bottom"), this.blockModels.modelOutput);
        ResourceLocation upper_left = CURTAIN_TOP_LEFT.create(curtain, GaiaBlockStateProvider.curtain(block, "_top_left"), this.blockModels.modelOutput);
        ResourceLocation lower_left = CURTAIN_BOTTOM_LEFT.create(curtain, GaiaBlockStateProvider.curtain(block, "_bottom_left"), this.blockModels.modelOutput);
        ResourceLocation upper_right = CURTAIN_TOP_RIGHT.create(curtain, GaiaBlockStateProvider.curtain(block, "_top_right"), this.blockModels.modelOutput);
        ResourceLocation lower_right = CURTAIN_BOTTOM_RIGHT.create(curtain, GaiaBlockStateProvider.curtain(block, "_bottom_right"), this.blockModels.modelOutput);
        ResourceLocation upper_open = CURTAIN_TOP_OPEN.create(curtain, GaiaBlockStateProvider.curtain(block, "_top_open"), this.blockModels.modelOutput);
        ResourceLocation lower_open = CURTAIN_BOTTOM_OPEN.create(curtain, GaiaBlockStateProvider.curtain(block, "_bottom_open"), this.blockModels.modelOutput);
        ResourceLocation upper_left_open = CURTAIN_TOP_LEFT_OPEN.create(curtain, GaiaBlockStateProvider.curtain(block, "_top_left_open"), this.blockModels.modelOutput);
        ResourceLocation lower_left_open = CURTAIN_BOTTOM_LEFT_OPEN.create(curtain, GaiaBlockStateProvider.curtain(block, "_bottom_left_open"), this.blockModels.modelOutput);
        ResourceLocation upper_right_open = CURTAIN_TOP_RIGHT_OPEN.create(curtain, GaiaBlockStateProvider.curtain(block, "_top_right_open"), this.blockModels.modelOutput);
        ResourceLocation lower_right_open = CURTAIN_BOTTOM_RIGHT_OPEN.create(curtain, GaiaBlockStateProvider.curtain(block, "_bottom_right_open"), this.blockModels.modelOutput);
        PropertyDispatch.C4 dispatch = PropertyDispatch.properties(CurtainBlock.FACING, CurtainBlock.HALF, CurtainBlock.SIDE, (Property)CurtainBlock.OPEN);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.SINGLE, false, upper);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.SINGLE, false, lower);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.LEFT, false, upper_left);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.LEFT, false, lower_left);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.RIGHT, false, upper_right);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.RIGHT, false, lower_right);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.SINGLE, true, upper_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.SINGLE, true, lower_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.LEFT, true, upper_left_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.LEFT, true, lower_left_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.RIGHT, true, upper_right_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.X, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.RIGHT, true, lower_right_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.SINGLE, false, upper);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.SINGLE, false, lower);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.LEFT, false, upper_left);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.LEFT, false, lower_left);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.RIGHT, false, upper_right);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.RIGHT, false, lower_right);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.SINGLE, true, upper_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.SINGLE, true, lower_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.LEFT, true, upper_left_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.LEFT, true, lower_left_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.UPPER, CurtainBlock.CurtainSide.RIGHT, true, upper_right_open);
        this.curtainProps((PropertyDispatch.C4<Direction.Axis, DoubleBlockHalf, CurtainBlock.CurtainSide, Boolean>)dispatch, Direction.Axis.Z, DoubleBlockHalf.LOWER, CurtainBlock.CurtainSide.RIGHT, true, lower_right_open);
        this.blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)((Block)block.get())).with((PropertyDispatch)dispatch));
        this.blockModels.registerSimpleFlatItemModel(block.asItem());
    }
}

