/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data.provider;

import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.registration.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class GaiaEntityLootTableProvider
extends EntityLootSubProvider {
    protected GaiaEntityLootTableProvider(HolderLookup.Provider provider) {
        super(FeatureFlags.REGISTRY.allFlags(), provider);
    }

    public void addTable(Supplier<? extends EntityType<?>> entity, LootTable.Builder table) {
        this.add(entity.get(), table);
    }

    public void addTable(Supplier<? extends EntityType<?>> entity, ResourceKey<LootTable> path, LootTable.Builder table) {
        this.add(entity.get(), path, table);
    }

    public LootTable.Builder blankTable() {
        return LootTable.lootTable();
    }

    public LootTable.Builder sapperTable(Supplier<Item> geode) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)geode.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)((ResourceKey)((EntityType)ModEntities.GROWTH_SAPPER.get()).getDefaultLootTable().orElseThrow()))));
    }

    public LootTable.Builder singleDropTable(Supplier<Item> drop, float minCount, float maxCount) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)drop.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minCount, (float)maxCount))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))));
    }

    public LootTable.Builder cookableSingleDropTable(Supplier<Item> raw, float minCount, float maxCount) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)raw.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minCount, (float)maxCount))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))));
    }

    public LootTable.Builder cookableDoubleDropTable(Supplier<Item> cookable, Supplier<Item> drop, float minCount1, float maxCount1, float minCount2, float maxCount2) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)cookable.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minCount1, (float)maxCount1))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)drop.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minCount2, (float)maxCount2))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))));
    }

    public LootTable.Builder warriorTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.scaynyx_ingot.get()))).when(LootItemKilledByPlayerCondition.killedByPlayer()).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.025f, (float)0.01f))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.shiny_bone.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))));
    }

    public LootTable.Builder extractorTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.pink_geode.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.blue_geode.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.green_geode.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.purple_geode.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))));
    }

    public LootTable.Builder malachiteGuardTable() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.malachite_guard_baton.get())))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.malachite_guard_headgear.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.malachite_guard_brace.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.malachite_guard_gear.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.malachite_guard_boots.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))));
    }
}

