/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data.provider;

import androsa.gaiadimension.block.CurtainBlock;
import androsa.gaiadimension.item.ConstructKitItem;
import androsa.gaiadimension.recipe.PurifierRecipeBuilder;
import androsa.gaiadimension.recipe.RestructurerRecipeBuilder;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModDataComponents;
import androsa.gaiadimension.registry.registration.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public abstract class GaiaRecipeProvider
extends RecipeProvider {
    public GaiaRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected String loc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)name).getPath();
    }

    public ShapedRecipeBuilder smallCompressRecipe(ItemLike result, ItemLike ingredient) {
        return this.smallCompressRecipe(result, ingredient, 1);
    }

    public ShapedRecipeBuilder smallCompressRecipe(ItemLike result, ItemLike ingredient, int count) {
        return this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern("##").pattern("##").define(Character.valueOf('#'), ingredient).unlockedBy("has_" + String.valueOf(ingredient.asItem()), this.has(ingredient));
    }

    public ShapedRecipeBuilder largeCompressRecipe(ItemLike result, ItemLike ingredient) {
        return this.largeCompressRecipe(result, ingredient, 1);
    }

    public ShapedRecipeBuilder largeCompressRecipe(ItemLike result, ItemLike ingredient, int count) {
        return this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), ingredient).unlockedBy("has_" + String.valueOf(ingredient.asItem()), this.has(ingredient));
    }

    public void planksRecipe(Supplier<Block> result, TagKey<Item> ingredient, RecipeOutput output) {
        this.woodRecipe((RecipeBuilder)this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get(), 4).requires(ingredient).unlockedBy("has_" + ingredient.location().getPath(), this.has(ingredient)), output, result.get().asItem());
    }

    public ShapedRecipeBuilder slabRecipe(Supplier<SlabBlock> result, DeferredBlock<Block> ingredient) {
        return this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get(), 6).pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get()));
    }

    public ShapedRecipeBuilder stairsRecipe(Supplier<StairBlock> result, DeferredBlock<? extends Block> ingredient) {
        return this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get(), 8).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get()));
    }

    public void blockToItemRecipe(Supplier<Item> result, DeferredBlock<Block> ingredient, RecipeOutput output, String name) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get(), 9).requires((ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())).save(output, this.loc("storage_blocks/" + name));
    }

    public void helmetRecipe(Supplier<Item> result, DeferredItem<Item> ingredient, RecipeOutput output) {
        this.armorRecipe(this.shaped(RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("###").pattern("# #").define(Character.valueOf('#'), (ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())), output, result);
    }

    public void chestRecipe(Supplier<Item> result, DeferredItem<Item> ingredient, RecipeOutput output) {
        this.armorRecipe(this.shaped(RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())), output, result);
    }

    public void legsRecipe(Supplier<Item> result, DeferredItem<Item> ingredient, RecipeOutput output) {
        this.armorRecipe(this.shaped(RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), (ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())), output, result);
    }

    public void bootsRecipe(Supplier<Item> result, DeferredItem<Item> ingredient, RecipeOutput output) {
        this.armorRecipe(this.shaped(RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("# #").pattern("# #").define(Character.valueOf('#'), (ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())), output, result);
    }

    public void armorRecipe(ShapedRecipeBuilder recipe, RecipeOutput output, Supplier<Item> result) {
        recipe.save(output, this.loc("armor/" + BuiltInRegistries.ITEM.getKey((Object)result.get()).getPath()));
    }

    public void axeRecipe(Supplier<Item> result, DeferredItem<Item> ingredient, RecipeOutput output) {
        this.toolRecipe(this.shaped(RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("##").pattern("#/").pattern(" /").define(Character.valueOf('#'), (ItemLike)ingredient.get()).define(Character.valueOf('/'), (ItemLike)ModItems.agate_stick.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())), output, result);
    }

    public void axeRecipeTag(Supplier<Item> result, TagKey<Item> ingredient, RecipeOutput output) {
        this.toolRecipe(this.shaped(RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("##").pattern("#/").pattern(" /").define(Character.valueOf('#'), ingredient).define(Character.valueOf('/'), (ItemLike)ModItems.agate_stick.get()).unlockedBy("has_" + ingredient.location().getPath(), this.has(ingredient)), output, result);
    }

    public void pickaxeRecipe(Supplier<Item> result, DeferredItem<Item> ingredient, RecipeOutput output) {
        this.toolRecipe(this.shaped(RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("###").pattern(" / ").pattern(" / ").define(Character.valueOf('#'), (ItemLike)ingredient.get()).define(Character.valueOf('/'), (ItemLike)ModItems.agate_stick.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())), output, result);
    }

    public void pickaxeRecipeTag(Supplier<Item> result, TagKey<Item> ingredient, RecipeOutput output) {
        this.toolRecipe(this.shaped(RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("###").pattern(" / ").pattern(" / ").define(Character.valueOf('#'), ingredient).define(Character.valueOf('/'), (ItemLike)ModItems.agate_stick.get()).unlockedBy("has_" + ingredient.location().getPath(), this.has(ingredient)), output, result);
    }

    public void shovelRecipe(Supplier<Item> result, DeferredItem<Item> ingredient, RecipeOutput output) {
        this.toolRecipe(this.shaped(RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("#").pattern("/").pattern("/").define(Character.valueOf('#'), (ItemLike)ingredient.get()).define(Character.valueOf('/'), (ItemLike)ModItems.agate_stick.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())), output, result);
    }

    public void shovelRecipeTag(Supplier<Item> result, TagKey<Item> ingredient, RecipeOutput output) {
        this.toolRecipe(this.shaped(RecipeCategory.TOOLS, (ItemLike)result.get()).pattern("#").pattern("/").pattern("/").define(Character.valueOf('#'), ingredient).define(Character.valueOf('/'), (ItemLike)ModItems.agate_stick.get()).unlockedBy("has_" + ingredient.location().getPath(), this.has(ingredient)), output, result);
    }

    public void swordRecipe(Supplier<Item> result, DeferredItem<Item> ingredient, RecipeOutput output) {
        this.toolRecipe(this.shaped(RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("#").pattern("#").pattern("/").define(Character.valueOf('#'), (ItemLike)ingredient.get()).define(Character.valueOf('/'), (ItemLike)ModItems.agate_stick.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get())), output, result);
    }

    public void swordRecipeTag(Supplier<Item> result, TagKey<Item> ingredient, RecipeOutput output) {
        this.toolRecipe(this.shaped(RecipeCategory.COMBAT, (ItemLike)result.get()).pattern("#").pattern("#").pattern("/").define(Character.valueOf('#'), ingredient).define(Character.valueOf('/'), (ItemLike)ModItems.agate_stick.get()).unlockedBy("has_" + ingredient.location().getPath(), this.has(ingredient)), output, result);
    }

    private void toolRecipe(ShapedRecipeBuilder recipe, RecipeOutput output, Supplier<Item> result) {
        recipe.save(output, this.loc("tools/" + BuiltInRegistries.ITEM.getKey((Object)result.get()).getPath()));
    }

    public ShapelessRecipeBuilder drinkRecipe(Supplier<Item> result, Supplier<Item> geode) {
        return this.shapeless(RecipeCategory.FOOD, (ItemLike)result.get()).requires((ItemLike)geode.get()).requires((ItemLike)ModItems.sugar_crystals.get()).requires((ItemLike)ModItems.agate_cup.get()).unlockedBy("has_cup", this.has((ItemLike)ModItems.agate_cup.get()));
    }

    public ShapelessRecipeBuilder sliceRecipe(Supplier<Item> result, Supplier<Item> geode) {
        return this.shapeless(RecipeCategory.FOOD, (ItemLike)result.get(), 4).requires((ItemLike)geode.get()).unlockedBy("has_geode", this.has((ItemLike)geode.get()));
    }

    public ShapelessRecipeBuilder tiliRecipe(Supplier<Item> result, Supplier<Block> ingredient) {
        return this.shapeless(RecipeCategory.FOOD, (ItemLike)result.get()).requires((ItemLike)ingredient.get()).requires((ItemLike)ModBlocks.thiscus.get()).unlockedBy("has_thiscus", this.has((ItemLike)ModBlocks.thiscus.get()));
    }

    public ShapelessRecipeBuilder crustBricks(Supplier<Block> result, Supplier<Block> ingredient) {
        return this.shapeless(RecipeCategory.BUILDING_BLOCKS, (ItemLike)result.get()).requires((ItemLike)ingredient.get()).requires((ItemLike)ModItems.crystal_shard.get()).unlockedBy("has_shard", this.has((ItemLike)ModItems.crystal_shard.get()));
    }

    public ShapedRecipeBuilder curtainRecipe(Supplier<CurtainBlock> result, DeferredBlock<Block> curtain, int amount) {
        return this.shaped(RecipeCategory.DECORATIONS, (ItemLike)result.get(), amount).pattern("//").pattern("##").pattern("##").define(Character.valueOf('/'), ModItems.agate_stick).define(Character.valueOf('#'), (ItemLike)curtain.get()).unlockedBy("has_" + curtain.getId().getPath(), this.has((ItemLike)curtain));
    }

    public ShapelessRecipeBuilder repairKit() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.repair_kit.get());
        stack.set(ModDataComponents.KIT_PART, (Object)ConstructKitItem.Part.LEFT_HORN);
        return this.shapeless(RecipeCategory.MISC, stack).requires(ModItems.blank_kit).requires(ModItems.opalite).unlockedBy("has_opalite", this.has((ItemLike)ModItems.opalite));
    }

    public ShapelessRecipeBuilder augmentKit(Supplier<Item> result, DeferredBlock<Block> ingredient) {
        ItemStack stack = new ItemStack((ItemLike)result.get());
        stack.set(ModDataComponents.KIT_PART, (Object)ConstructKitItem.Part.LEFT_HORN);
        return this.shapeless(RecipeCategory.MISC, stack).requires(ModItems.blank_kit).requires(ModItems.opalite).requires((ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient));
    }

    public ShapelessRecipeBuilder replaceKit(Supplier<Item> result, DeferredBlock<Block> ingredient) {
        ItemStack stack = new ItemStack((ItemLike)result.get());
        stack.set(ModDataComponents.KIT_PART, (Object)ConstructKitItem.Part.LEFT_HORN);
        return this.shapeless(RecipeCategory.MISC, stack).requires(ModItems.blank_kit).requires((ItemLike)ingredient.get()).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient));
    }

    public void woodRecipe(RecipeBuilder recipe, RecipeOutput output, Item result) {
        recipe.save(output, this.loc("wood/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
    }

    public SimpleCookingRecipeBuilder smeltingRecipe(ItemLike result, DeferredBlock<? extends Block> ingredient, float exp) {
        return this.smeltingRecipe(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder smeltingRecipe(ItemLike result, DeferredItem<Item> ingredient, float exp) {
        return this.smeltingRecipe(result, ingredient, exp, 1);
    }

    public SimpleCookingRecipeBuilder smeltingRecipe(ItemLike result, DeferredBlock<? extends Block> ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(ingredient), (RecipeCategory)RecipeCategory.MISC, (ItemStack)new ItemStack(result, count), (float)exp, (int)200).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient));
    }

    public SimpleCookingRecipeBuilder smeltingRecipe(ItemLike result, DeferredItem<Item> ingredient, float exp, int count) {
        return SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(ingredient), (RecipeCategory)RecipeCategory.MISC, (ItemStack)new ItemStack(result, count), (float)exp, (int)200).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient));
    }

    public RestructurerRecipeBuilder restructureBlackResidue(Supplier<Item> result, DeferredItem<Item> ingredient, float exp, int count) {
        return RestructurerRecipeBuilder.restructuring(Ingredient.of(ingredient), new ItemStack((ItemLike)result.get(), count), new ItemStack((ItemLike)ModItems.black_residue.get(), 1), exp, 200).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get()));
    }

    public RestructurerRecipeBuilder restructuringTektite(Supplier<Block> result, DeferredBlock<Block> ingredient, float exp, int count) {
        return RestructurerRecipeBuilder.restructuring(Ingredient.of(ingredient), new ItemStack((ItemLike)result.get(), count), new ItemStack((ItemLike)ModItems.tektite.get(), 1), exp, 200).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient.get()));
    }

    public RestructurerRecipeBuilder restructuringItems(ItemLike result, ItemLike byproduct, DeferredItem<Item> ingredient, float exp, int count) {
        return RestructurerRecipeBuilder.restructuring(Ingredient.of(ingredient), new ItemStack(result, count), new ItemStack(byproduct, 1), exp, 200).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient));
    }

    public RestructurerRecipeBuilder restructuringItems(ItemLike result, ItemLike byproduct, DeferredBlock<Block> ingredient, float exp, int count) {
        return RestructurerRecipeBuilder.restructuring(Ingredient.of(ingredient), new ItemStack(result, count), new ItemStack(byproduct, 1), exp, 200).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient));
    }

    public PurifierRecipeBuilder purifyingItems(ItemLike result, ItemLike byproduct, DeferredItem<Item> ingredient, float exp, int count, int bycount) {
        return PurifierRecipeBuilder.purifying(Ingredient.of((ItemLike)((ItemLike)ingredient.get())), new ItemStack(result, count), new ItemStack(byproduct, bycount), exp, 200).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient));
    }

    public PurifierRecipeBuilder purifyingItems(ItemLike result, ItemLike byproduct, DeferredBlock<? extends Block> ingredient, float exp, int count, int bycount) {
        return PurifierRecipeBuilder.purifying(Ingredient.of((ItemLike)((ItemLike)ingredient.get())), new ItemStack(result, count), new ItemStack(byproduct, bycount), exp, 200).unlockedBy("has_" + ingredient.getId().getPath(), this.has((ItemLike)ingredient));
    }
}

