/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.registry.registration.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;

public class BismuthUletrus
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.defineId(BismuthUletrus.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public BismuthUletrus(EntityType<? extends BismuthUletrus> entity, Level world) {
        super(entity, world);
        this.xpReward = 5;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RESTING, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
    }

    public boolean getResting() {
        return (Boolean)this.entityData.get(RESTING);
    }

    public void setResting(boolean rest) {
        this.entityData.set(RESTING, (Object)rest);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setResting(compound.getBoolean("UletrusResting"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("UletrusResting", this.getResting());
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_BISMUTH_ULETRUS_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_BISMUTH_ULETRUS_HURT.get();
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        this.setResting(false);
        return super.hurtServer(level, source, amount);
    }

    public static boolean canSpawnHere(EntityType<BismuthUletrus> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        return spawn == EntitySpawnReason.SPAWNER || world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getBrightness(LightLayer.SKY, pos) > 8;
    }

    public void tick() {
        super.tick();
        if (this.getResting()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 0.0, 0.0));
        }
    }

    protected void customServerAiStep(ServerLevel level) {
        super.customServerAiStep(level);
        BlockPos blockpos = this.blockPosition();
        BlockPos blockpos1 = blockpos.below();
        if (this.getResting()) {
            if (level.getBlockState(blockpos1).isRedstoneConductor((BlockGetter)level, blockpos)) {
                if (this.random.nextInt(1000) == 0) {
                    this.setResting(false);
                }
            } else {
                this.setResting(false);
            }
        } else if (this.getDeltaMovement().x() == 0.0 && this.getDeltaMovement().z() == 0.0 && this.random.nextInt(1000) == 0 && level.getBlockState(blockpos1).isRedstoneConductor((BlockGetter)level, blockpos)) {
            this.setResting(true);
        }
    }
}

