/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.registry.registration.ModEffects;
import androsa.gaiadimension.registry.registration.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;

public class CorruptSapper
extends Monster {
    public CorruptSapper(EntityType<? extends CorruptSapper> entity, Level world) {
        super(entity, world);
        this.xpReward = 1 + this.random.nextInt(3) * 2;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.7, false));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_CORRUPT_SAPPER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_CORRUPT_SAPPER_HURT.get();
    }

    public boolean doHurtTarget(ServerLevel level, Entity entityIn) {
        if (super.doHurtTarget(level, entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i;
                LivingEntity living = (LivingEntity)entityIn;
                switch (level.getDifficulty()) {
                    case EASY: {
                        int n = 3;
                        break;
                    }
                    case NORMAL: {
                        int n = 6;
                        break;
                    }
                    case HARD: {
                        int n = 12;
                        break;
                    }
                    default: {
                        int n = i = 0;
                    }
                }
                if (i > 0) {
                    living.addEffect(new MobEffectInstance(ModEffects.goldstone_plague, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean checkSpawnRules(LevelAccessor world, EntitySpawnReason reason) {
        return true;
    }

    public static boolean canSpawnHere(EntityType<CorruptSapper> entity, ServerLevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        if (world.getDifficulty() != Difficulty.PEACEFUL) {
            if (spawn == EntitySpawnReason.SPAWNER) {
                return CorruptSapper.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
            }
            return world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getBrightness(LightLayer.SKY, pos) > 8;
        }
        return false;
    }
}

