/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.entity.data.SapperVariant;
import androsa.gaiadimension.registry.bootstrap.GaiaBiomes;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.registration.ModSounds;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class GrowthSapper
extends PathfinderMob {
    private static final EntityDataAccessor<SapperVariant> SAPPER_VARIANT = SynchedEntityData.defineId(GrowthSapper.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.SAPPER_VARIANT.get()));

    public GrowthSapper(EntityType<? extends GrowthSapper> entity, Level world) {
        super(entity, world);
        this.xpReward = 1 + this.random.nextInt(3);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SAPPER_VARIANT, (Object)SapperVariant.COMMON);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
    }

    public SapperVariant getEntityVariant() {
        return (SapperVariant)((Object)this.entityData.get(SAPPER_VARIANT));
    }

    public void setSapperVariant(SapperVariant type) {
        this.entityData.set(SAPPER_VARIANT, (Object)type);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSapperVariant(SapperVariant.getVariant(compound.getInt("SapperVariant")));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("SapperVariant", this.getEntityVariant().getId());
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_GROWTH_SAPPER_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_GROWTH_SAPPER_HURT.get();
    }

    public static boolean canSpawnHere(EntityType<GrowthSapper> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        return spawn == EntitySpawnReason.SPAWNER || world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getRawBrightness(pos, 0) > 8;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, EntitySpawnReason reason, @Nullable SpawnGroupData spawnDataIn) {
        Optional biome = worldIn.getBiome(this.blockPosition()).unwrapKey();
        if (Objects.equals(biome, Optional.of(GaiaBiomes.pink_agate_forest)) || Objects.equals(biome, Optional.of(GaiaBiomes.crystal_plains))) {
            this.setSapperVariant(SapperVariant.COMMON);
        } else if (Objects.equals(biome, Optional.of(GaiaBiomes.blue_agate_taiga))) {
            this.setSapperVariant(SapperVariant.CHILLED);
        } else if (Objects.equals(biome, Optional.of(GaiaBiomes.green_agate_jungle))) {
            this.setSapperVariant(SapperVariant.NUTRIENT);
        } else if (Objects.equals(biome, Optional.of(GaiaBiomes.purple_agate_swamp))) {
            this.setSapperVariant(SapperVariant.MYSTIFIED);
        } else {
            this.setSapperVariant(SapperVariant.getRandomVariant(worldIn.getRandom()));
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }
}

