/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.registry.registration.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class MarkuzarPlant
extends Mob {
    public MarkuzarPlant(EntityType<? extends MarkuzarPlant> entity, Level world) {
        super(entity, world);
        this.xpReward = 1 + this.random.nextInt(3);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_MARKUZAR_PLANT_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_MARKUZAR_PLANT_HURT.get();
    }

    public void knockback(double distance, double x, double y) {
    }

    public void move(MoverType type, Vec3 pos) {
        if (type == MoverType.PISTON) {
            super.move(type, pos);
        }
    }

    public boolean checkSpawnRules(LevelAccessor world, EntitySpawnReason reason) {
        return true;
    }

    public static boolean canSpawnHere(EntityType<MarkuzarPlant> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.below();
        return world.getBlockState(blockpos).isValidSpawn((BlockGetter)world, blockpos, entity) && world.getBrightness(LightLayer.SKY, blockpos) > 8;
    }
}

