/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.entity.OpaliteContruct;
import androsa.gaiadimension.entity.data.MookaitePartType;
import androsa.gaiadimension.entity.projectile.MookaiteAmmo;
import androsa.gaiadimension.entity.projectile.MookaiteMagic;
import androsa.gaiadimension.registry.bootstrap.GaiaDamage;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.registration.ModSounds;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class MookaiteConstruct
extends PathfinderMob {
    private static final EntityDataAccessor<Optional<UUID>> BOND_CREATOR_UUID = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Optional<UUID>> OPALITE_COMPANION_UUID = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> IS_BURNING = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_CONSTRUCTING = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<MookaitePartType> LEFT_HORN_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> RIGHT_HORN_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> LEFT_EYE_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> RIGHT_EYE_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> LEFT_SHOULDER_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> RIGHT_SHOULDER_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> LEFT_ARM_BRACE_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> RIGHT_ARM_BRACE_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> LEFT_LEG_BRACE_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    public static final EntityDataAccessor<MookaitePartType> RIGHT_LEG_BRACE_TYPE = SynchedEntityData.defineId(MookaiteConstruct.class, (EntityDataSerializer)((EntityDataSerializer)ModEntities.MOOKAITE_PART.get()));
    private static final float ARMOR = 0.5f;
    private static final float KNOCKBACK_RESISTANCE = 0.75f;
    private static final float ATTACK_KNOCKBACK = 1.0f;
    private static final float ATTACK_DAMAGE = 3.0f;
    private static final float MOVEMENT_SPEED = 0.25f;
    public static final MookaitePart LEFT_HORN = new MookaitePart("left_horn", () -> LEFT_HORN_TYPE, () -> RIGHT_HORN_TYPE, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, 0.75f);
    public static final MookaitePart RIGHT_HORN = new MookaitePart("right_horn", () -> RIGHT_HORN_TYPE, () -> LEFT_HORN_TYPE, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, 0.75f);
    public static final MookaitePart LEFT_EYE = new MookaitePart("left_eye", () -> LEFT_EYE_TYPE, () -> RIGHT_EYE_TYPE, (Holder<Attribute>)Attributes.ARMOR, 0.5f);
    public static final MookaitePart RIGHT_EYE = new MookaitePart("right_eye", () -> RIGHT_EYE_TYPE, () -> RIGHT_EYE_TYPE, (Holder<Attribute>)Attributes.ARMOR, 0.5f);
    public static final MookaitePart LEFT_SHOULDER = new MookaitePart("left_shoulder", () -> LEFT_SHOULDER_TYPE, () -> RIGHT_SHOULDER_TYPE, (Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, 1.0f);
    public static final MookaitePart RIGHT_SHOULDER = new MookaitePart("right_shoulder", () -> RIGHT_SHOULDER_TYPE, () -> LEFT_SHOULDER_TYPE, (Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, 1.0f);
    public static final MookaitePart LEFT_ARM = new MookaitePart("left_arm_brace", () -> LEFT_ARM_BRACE_TYPE, () -> RIGHT_ARM_BRACE_TYPE, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, 3.0f);
    public static final MookaitePart RIGHT_ARM = new MookaitePart("right_arm_brace", () -> RIGHT_ARM_BRACE_TYPE, () -> LEFT_ARM_BRACE_TYPE, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, 3.0f);
    public static final MookaitePart LEFT_LEG = new MookaitePart("left_leg_brace", () -> LEFT_LEG_BRACE_TYPE, () -> RIGHT_LEG_BRACE_TYPE, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.25f);
    public static final MookaitePart RIGHT_LEG = new MookaitePart("right_leg_brace", () -> RIGHT_LEG_BRACE_TYPE, () -> LEFT_LEG_BRACE_TYPE, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.25f);
    public static final List<MookaitePart> PARTS = ImmutableList.of((Object)LEFT_HORN, (Object)RIGHT_HORN, (Object)LEFT_EYE, (Object)RIGHT_EYE, (Object)LEFT_SHOULDER, (Object)RIGHT_SHOULDER, (Object)LEFT_ARM, (Object)RIGHT_ARM, (Object)LEFT_LEG, (Object)RIGHT_LEG);
    protected int attackCooldown = 200;

    public MookaiteConstruct(EntityType<? extends MookaiteConstruct> entity, Level level) {
        super(entity, level);
        this.xpReward = 5;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.75).add(Attributes.ARMOR, 0.5).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOND_CREATOR_UUID, Optional.empty());
        builder.define(OPALITE_COMPANION_UUID, Optional.empty());
        builder.define(IS_BURNING, (Object)false);
        builder.define(IS_CONSTRUCTING, (Object)false);
        builder.define(LEFT_HORN_TYPE, (Object)MookaitePartType.NONE);
        builder.define(RIGHT_HORN_TYPE, (Object)MookaitePartType.NONE);
        builder.define(LEFT_EYE_TYPE, (Object)MookaitePartType.NONE);
        builder.define(RIGHT_EYE_TYPE, (Object)MookaitePartType.NONE);
        builder.define(LEFT_SHOULDER_TYPE, (Object)MookaitePartType.NONE);
        builder.define(RIGHT_SHOULDER_TYPE, (Object)MookaitePartType.NONE);
        builder.define(LEFT_ARM_BRACE_TYPE, (Object)MookaitePartType.NONE);
        builder.define(RIGHT_ARM_BRACE_TYPE, (Object)MookaitePartType.NONE);
        builder.define(LEFT_LEG_BRACE_TYPE, (Object)MookaitePartType.NONE);
        builder.define(RIGHT_LEG_BRACE_TYPE, (Object)MookaitePartType.NONE);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("BonderUUID")) {
            this.setBonder(tag.getUUID("BonderUUID"));
        }
        if (tag.hasUUID("OpaliteUUID")) {
            this.setOpaliteCompanion(tag.getUUID("OpaliteUUID"));
        }
        this.setBurning(tag.getBoolean("IsBurning"));
        this.setConstructing(tag.getBoolean("IsConstructing"));
        this.setPart(LEFT_HORN, MookaitePartType.fromName(tag.getString("LeftHornType")));
        this.setPart(RIGHT_HORN, MookaitePartType.fromName(tag.getString("RightHornType")));
        this.setPart(LEFT_EYE, MookaitePartType.fromName(tag.getString("LeftEyeType")));
        this.setPart(RIGHT_EYE, MookaitePartType.fromName(tag.getString("RightEyeType")));
        this.setPart(LEFT_SHOULDER, MookaitePartType.fromName(tag.getString("LeftShoulderType")));
        this.setPart(RIGHT_SHOULDER, MookaitePartType.fromName(tag.getString("RightShoulderType")));
        this.setPart(LEFT_ARM, MookaitePartType.fromName(tag.getString("LeftArmBraceType")));
        this.setPart(RIGHT_ARM, MookaitePartType.fromName(tag.getString("RightArmBraceType")));
        this.setPart(LEFT_LEG, MookaitePartType.fromName(tag.getString("LeftLegBraceType")));
        this.setPart(RIGHT_LEG, MookaitePartType.fromName(tag.getString("RightLegBraceType")));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.getBonder() != null) {
            tag.putUUID("BonderUUID", this.getBonder());
        }
        if (this.getOpaliteCompanion() != null) {
            tag.putUUID("OpaliteUUID", this.getOpaliteCompanion());
        }
        tag.putBoolean("IsBurning", this.isBurning());
        tag.putBoolean("IsConstructing", this.isConstructing());
        tag.putString("LeftHornType", this.getPart(LEFT_HORN).getSerializedName());
        tag.putString("RightHornType", this.getPart(RIGHT_HORN).getSerializedName());
        tag.putString("LeftEyeType", this.getPart(LEFT_EYE).getSerializedName());
        tag.putString("RightEyeType", this.getPart(RIGHT_EYE).getSerializedName());
        tag.putString("LeftShoulderType", this.getPart(LEFT_SHOULDER).getSerializedName());
        tag.putString("RightShoulderType", this.getPart(RIGHT_SHOULDER).getSerializedName());
        tag.putString("LeftArmBraceType", this.getPart(LEFT_ARM).getSerializedName());
        tag.putString("RightArmBraceType", this.getPart(RIGHT_ARM).getSerializedName());
        tag.putString("LeftLegBraceType", this.getPart(LEFT_LEG).getSerializedName());
        tag.putString("RightLegBraceType", this.getPart(RIGHT_LEG).getSerializedName());
    }

    public void setBonder(UUID id) {
        this.entityData.set(BOND_CREATOR_UUID, Optional.ofNullable(id));
    }

    public UUID getBonder() {
        return ((Optional)this.entityData.get(BOND_CREATOR_UUID)).orElse(null);
    }

    public void setOpaliteCompanion(UUID id) {
        this.entityData.set(OPALITE_COMPANION_UUID, Optional.ofNullable(id));
    }

    public UUID getOpaliteCompanion() {
        return ((Optional)this.entityData.get(OPALITE_COMPANION_UUID)).orElse(null);
    }

    public void setBurning(boolean flag) {
        this.entityData.set(IS_BURNING, (Object)flag);
    }

    public boolean isBurning() {
        return (Boolean)this.entityData.get(IS_BURNING);
    }

    public void setConstructing(boolean flag) {
        this.entityData.set(IS_CONSTRUCTING, (Object)flag);
    }

    public boolean isConstructing() {
        return (Boolean)this.entityData.get(IS_CONSTRUCTING);
    }

    public MookaitePartType getPart(MookaitePart part) {
        return this.getPart(part.main().get());
    }

    public MookaitePartType getPart(EntityDataAccessor<MookaitePartType> part) {
        return (MookaitePartType)((Object)this.entityData.get(part));
    }

    public void setPart(MookaitePart part, MookaitePartType value) {
        this.entityData.set(part.main().get(), (Object)value);
        this.calculateMultiplier(part, value);
    }

    public int countColors(MookaitePartType colour) {
        int amount = 0;
        for (MookaitePart part : PARTS) {
            if (this.getPart(part) != colour) continue;
            ++amount;
        }
        return amount;
    }

    public void calculateMultiplier(MookaitePart part, MookaitePartType value) {
        AttributeInstance attribute = this.getAttribute(part.attribute());
        double total = part.base() * (value.getMultiplier() + this.getPart(part.pair().get()).getMultiplier());
        attribute.setBaseValue(total);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new LookAtCompanionGoal(this));
        this.goalSelector.addGoal(2, (Goal)new ScarletShockwaveGoal(this));
        this.goalSelector.addGoal(2, (Goal)new AuburnFireGoal(this));
        this.goalSelector.addGoal(2, (Goal)new GoldMagicGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MauveElectricGoal(this));
        this.goalSelector.addGoal(2, (Goal)new IvoryProjectileGoal(this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 32.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_MOOKAITE_CONSTRUCT_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_MOOKAITE_CONSTRUCT_DEATH.get();
    }

    @Deprecated
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawn, @Nullable SpawnGroupData data) {
        this.setPart(LEFT_HORN, MookaitePartType.getRandom(this.random));
        this.setPart(RIGHT_HORN, MookaitePartType.getRandom(this.random));
        this.setPart(LEFT_EYE, MookaitePartType.getRandom(this.random));
        this.setPart(RIGHT_EYE, MookaitePartType.getRandom(this.random));
        this.setPart(LEFT_SHOULDER, MookaitePartType.getRandom(this.random));
        this.setPart(RIGHT_SHOULDER, MookaitePartType.getRandom(this.random));
        this.setPart(LEFT_ARM, MookaitePartType.getRandom(this.random));
        this.setPart(RIGHT_ARM, MookaitePartType.getRandom(this.random));
        this.setPart(LEFT_LEG, MookaitePartType.getRandom(this.random));
        this.setPart(RIGHT_LEG, MookaitePartType.getRandom(this.random));
        return super.finalizeSpawn(level, difficulty, spawn, data);
    }

    public static boolean canSpawnHere(EntityType<MookaiteConstruct> entity, LevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        return spawn == EntitySpawnReason.SPAWNER || world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getRawBrightness(pos, 0) > 8;
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.getOpaliteCompanion() != null;
    }

    public boolean isInvulnerableTo(ServerLevel level, DamageSource source) {
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            return this.countColors(MookaitePartType.SCARLET) >= 10;
        }
        if (source.is(DamageTypeTags.IS_FIRE)) {
            return this.countColors(MookaitePartType.AUBURN) >= 10;
        }
        if (source.is(DamageTypes.MAGIC) || source.is(DamageTypes.INDIRECT_MAGIC)) {
            return this.countColors(MookaitePartType.GOLD) >= 10;
        }
        if (source.is(GaiaDamage.STATIC)) {
            return this.countColors(MookaitePartType.MAUVE) >= 10;
        }
        if (source.is(DamageTypes.FREEZE)) {
            return this.countColors(MookaitePartType.BEIGE) >= 10;
        }
        if (source.is(DamageTypeTags.IS_PROJECTILE)) {
            return this.countColors(MookaitePartType.IVORY) >= 10;
        }
        return super.isInvulnerableTo(level, source);
    }

    public void aiStep() {
        super.aiStep();
        if (this.countColors(MookaitePartType.BEIGE) > 0) {
            int ticks = 220 - this.countColors(MookaitePartType.BEIGE) * 20;
            if (this.level().getGameTime() % (long)ticks == 0L) {
                this.setHealth(this.getHealth() + 1.0f);
            }
        }
        if (this.isBurning()) {
            Vec3 look = this.getLookAngle();
            double dist = 0.7f;
            double targetX = this.getX() + look.x * dist;
            double targetY = this.getEyeY() + look.y;
            double targetZ = this.getZ() + look.z * dist;
            for (int i = 0; i < 3; ++i) {
                double velX = look.x();
                double velY = look.y();
                double velZ = look.z();
                double spread = 5.0 + this.getRandom().nextDouble() * 1.5;
                double velocity = 0.35 + this.getRandom().nextDouble() * 0.15;
                velX += this.getRandom().nextGaussian() * 0.03 * spread;
                velY += this.getRandom().nextGaussian() * 0.03 * spread;
                velZ += this.getRandom().nextGaussian() * 0.03 * spread;
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, targetX, targetY, targetZ, velX *= velocity, velY *= velocity, velZ *= velocity);
            }
        }
        --this.attackCooldown;
    }

    public void die(DamageSource source) {
        if (CommonHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel level2 = (ServerLevel)level;
            if (this.getOpaliteCompanion() != null && (entity = level2.getEntity(this.getOpaliteCompanion())) instanceof OpaliteContruct) {
                OpaliteContruct opalite = (OpaliteContruct)entity;
                opalite.setMookaiteCompanion(null);
            }
        }
        super.die(source);
    }

    public record MookaitePart(String name, Supplier<EntityDataAccessor<MookaitePartType>> main, Supplier<EntityDataAccessor<MookaitePartType>> pair, Holder<Attribute> attribute, float base) {
    }

    static class LookAtCompanionGoal
    extends Goal {
        protected final MookaiteConstruct mob;
        protected Entity lookAt;

        public LookAtCompanionGoal(MookaiteConstruct entity) {
            this.mob = entity;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            Level level = this.mob.level();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                this.lookAt = server.getEntity(this.mob.getOpaliteCompanion());
            }
            return this.mob.isConstructing() && this.mob.getOpaliteCompanion() != null;
        }

        public boolean canContinueToUse() {
            if (!this.lookAt.isAlive()) {
                return false;
            }
            if (this.mob.distanceToSqr(this.lookAt) > 400.0) {
                return false;
            }
            return this.mob.isConstructing();
        }

        public void stop() {
            this.lookAt = null;
        }

        public void tick() {
            if (this.lookAt.isAlive()) {
                this.mob.getLookControl().setLookAt(this.lookAt.getX(), this.lookAt.getEyeY(), this.lookAt.getZ());
            }
        }
    }

    static class ScarletShockwaveGoal
    extends TimedGoal {
        private int stompTime;

        public ScarletShockwaveGoal(MookaiteConstruct entity) {
            super(entity, MookaitePartType.SCARLET);
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        @Override
        protected boolean testAttack() {
            List list = this.mookaite.level().getEntities((Entity)this.mookaite, this.mookaite.getBoundingBox().inflate(2.0), entity -> {
                Player player;
                LivingEntity living;
                if (entity instanceof LivingEntity && (living = (LivingEntity)entity) == this.mookaite.getTarget()) {
                    return true;
                }
                if (entity instanceof Player && (player = (Player)entity) == this.mookaite.getTarget()) {
                    return EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity);
                }
                return false;
            });
            for (Entity entity2 : list) {
                if (!entity2.onGround() || !(entity2.distanceToSqr(entity2) > 1.0) || !(entity2.distanceToSqr(entity2) < 4.0) || !entity2.isAlive()) continue;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.stompTime <= 20;
        }

        public void start() {
            this.stompTime = 0;
        }

        public void tick() {
            if (this.stompTime >= 10) {
                float range = 2.0f + (float)this.mookaite.countColors(this.color);
                List targets = this.mookaite.level().getEntities((Entity)this.mookaite, this.mookaite.getBoundingBox().inflate((double)range), entity -> !entity.getUUID().equals(this.mookaite.getOpaliteCompanion()) && !entity.getUUID().equals(this.mookaite.getBonder()) && entity.onGround());
                this.mookaite.playSound(ModSounds.ENTITY_MOOKAITE_CONSTRUCT_STOMP.get(), 1.0f, 1.0f);
                for (Entity entity2 : targets) {
                    Vec3 targetV3D = entity2.getDeltaMovement();
                    entity2.hurt(this.mookaite.damageSources().mobAttack((LivingEntity)this.mookaite), 3.0f);
                    entity2.setDeltaMovement(targetV3D.x() * 0.25, targetV3D.y() + (double)0.2f, targetV3D.z() * 0.25);
                }
                if (!this.mookaite.level().isClientSide()) {
                    int size = 2 + this.mookaite.countColors(this.color);
                    for (int x = -size; x <= size; ++x) {
                        for (int z = -size; z <= size; ++z) {
                            BlockPos pos = this.mookaite.blockPosition().offset(x, 0, z);
                            BlockState state = this.mookaite.level().getBlockState(pos.below());
                            ((ServerLevel)this.mookaite.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX(), this.mookaite.getY() + this.mookaite.random.nextDouble() * 0.25, (double)pos.getZ(), 5, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            ++this.stompTime;
        }
    }

    static class AuburnFireGoal
    extends TimedGoal {
        private LivingEntity target;
        private int burnTime;

        public AuburnFireGoal(MookaiteConstruct entity) {
            super(entity, MookaitePartType.AUBURN);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected boolean testAttack() {
            LivingEntity living = this.mookaite.getTarget();
            if (living != null && !living.fireImmune() && this.mookaite.distanceTo((Entity)living) > 2.0f && this.mookaite.hasLineOfSight((Entity)living)) {
                this.target = living;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target.isAlive() && this.mookaite.isAlive() && this.burnTime > 0;
        }

        public void start() {
            this.burnTime = 20 * this.mookaite.countColors(this.color);
            this.mookaite.setBurning(true);
        }

        @Override
        public void stop() {
            super.stop();
            this.mookaite.setBurning(false);
        }

        public void tick() {
            this.mookaite.getLookControl().setLookAt((Entity)this.target);
            this.faceVec(this.target.getEyePosition(), 100.0f, 100.0f);
            if (this.burnTime > 5) {
                for (Entity entity : this.targetsInRange()) {
                    if (entity == null) continue;
                    this.target.hurt(this.mookaite.damageSources().inFire(), 1.0f);
                }
                if (!this.mookaite.level().isClientSide() && this.burnTime % 5 == 0) {
                    this.mookaite.playSound(ModSounds.ENTITY_MOOKAITE_CONSTRUCT_BREATH.get(), 1.0f, 1.0f);
                }
            }
            --this.burnTime;
        }

        public void faceVec(Vec3 pos, float yawConstraint, float pitchConstraint) {
            double xPos = pos.x() - this.mookaite.getX();
            double zPos = pos.z() - this.mookaite.getZ();
            double yPos = this.mookaite.getY() + 0.25 - pos.y();
            double distance = Mth.sqrt((float)((float)(xPos * xPos + zPos * zPos)));
            float xyAngle = (float)(Math.atan2(zPos, xPos) * 180.0 / Math.PI) - 90.0f;
            float zdAngle = (float)(-(Math.atan2(yPos, distance) * 180.0 / Math.PI));
            this.mookaite.setXRot(-this.updateRotation(this.mookaite.getXRot(), zdAngle, pitchConstraint));
            this.mookaite.setYRot(this.updateRotation(this.mookaite.getYRot(), xyAngle, yawConstraint));
        }

        private float updateRotation(float current, float target, float maxDelta) {
            float delta = Mth.clamp((float)Mth.wrapDegrees((float)(target - current)), (float)(-maxDelta), (float)maxDelta);
            return current + delta;
        }

        private List<Entity> targetsInRange() {
            double range = 30.0;
            double offset = 5.0;
            Vec3 srcVec = new Vec3(this.mookaite.getX(), this.mookaite.getY() + 0.25, this.mookaite.getZ());
            Vec3 lookVec = this.mookaite.getViewVector(1.0f);
            Vec3 destVec = srcVec.add(lookVec.x * range, lookVec.y * range, lookVec.z * range);
            float area = 3.0f;
            double hitDist = 0.0;
            ArrayList affectedList = Lists.newArrayList();
            List possibleList = this.mookaite.level().getEntities((Entity)this.mookaite, this.mookaite.getBoundingBox().move(lookVec.x * offset, lookVec.y * offset, lookVec.z * offset).inflate((double)area), entity -> entity.isPickable() && !entity.getUUID().equals(this.mookaite.getOpaliteCompanion()) && !entity.getUUID().equals(this.mookaite.getBonder()) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE).test((Entity)entity));
            for (Entity possibleEntity : possibleList) {
                double possibleDist;
                float borderSize = possibleEntity.getPickRadius();
                AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize);
                Optional interceptPos = collisionBB.clip(srcVec, destVec);
                if (collisionBB.contains(srcVec)) {
                    if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                    affectedList.add(possibleEntity);
                    hitDist = 0.0;
                    continue;
                }
                if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
                affectedList.add(possibleEntity);
                hitDist = possibleDist;
            }
            return affectedList;
        }
    }

    static class GoldMagicGoal
    extends TimedGoal {
        private LivingEntity target;
        private boolean fired;

        public GoldMagicGoal(MookaiteConstruct entity) {
            super(entity, MookaitePartType.GOLD);
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        protected boolean testAttack() {
            LivingEntity livingentity = this.mookaite.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                boolean flag = this.mookaite.getSensing().hasLineOfSight((Entity)livingentity);
                double dist = this.mookaite.distanceToSqr((Entity)livingentity);
                if (dist < 144.0 && flag && !livingentity.hasEffect(MobEffects.POISON)) {
                    this.target = livingentity;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return !this.fired;
        }

        public void start() {
            this.fired = false;
        }

        public void tick() {
            this.mookaite.getLookControl().setLookAt((Entity)this.target, 10.0f, 10.0f);
            double tx = this.target.getX() - this.mookaite.getX();
            double ty = this.target.getEyeY() - (double)1.1f;
            double tz = this.target.getZ() - this.mookaite.getZ();
            MookaiteMagic bullet = new MookaiteMagic(this.mookaite.level(), (LivingEntity)this.mookaite, new ItemStack(ModBlocks.gold_mookaite));
            bullet.shoot(tx, ty - bullet.getY(), tz, 1.6f, 12.0f);
            this.mookaite.playSound(ModSounds.ENTITY_MOOKAITE_CONSTRUCT_CAST.get(), 1.0f, 1.0f / (this.mookaite.getRandom().nextFloat() * 0.4f + 0.8f));
            this.mookaite.level().addFreshEntity((Entity)bullet);
            this.fired = true;
        }
    }

    static class MauveElectricGoal
    extends TimedGoal {
        private int duration;

        public MauveElectricGoal(MookaiteConstruct entity) {
            super(entity, MookaitePartType.MAUVE);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected boolean testAttack() {
            return this.mookaite.getTarget() != null && this.mookaite.getRandom().nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return this.duration > 0;
        }

        public void start() {
            this.mookaite.getNavigation().stop();
            this.duration = 20 * (5 + this.mookaite.countColors(this.color));
        }

        public void tick() {
            List targets = this.mookaite.level().getEntities((Entity)this.mookaite, this.mookaite.getBoundingBox().inflate(2.0), entity -> !entity.getUUID().equals(this.mookaite.getOpaliteCompanion()) && !entity.getUUID().equals(this.mookaite.getBonder()));
            for (Entity entity2 : targets) {
                Vec3 targetV3D = entity2.getDeltaMovement();
                entity2.hurt(this.mookaite.damageSources().mobAttack((LivingEntity)this.mookaite), 2.0f);
                entity2.setDeltaMovement(targetV3D.x() * (double)0.35f, targetV3D.y() + (double)0.15f, targetV3D.z() * (double)0.35f);
            }
            if (!this.mookaite.level().isClientSide()) {
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        ((ServerLevel)this.mookaite.level()).sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.mookaite.getRandomX(2.0), this.mookaite.getRandomY(), this.mookaite.getRandomZ(2.0), 10, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            --this.duration;
        }
    }

    static class IvoryProjectileGoal
    extends TimedGoal {
        private LivingEntity target;
        private int attackTime;
        private int attackStep;
        private int maxSteps;

        public IvoryProjectileGoal(MookaiteConstruct entity) {
            super(entity, MookaitePartType.IVORY);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected boolean testAttack() {
            LivingEntity livingentity = this.mookaite.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                boolean flag = this.mookaite.getSensing().hasLineOfSight((Entity)livingentity);
                double dist = this.mookaite.distanceToSqr((Entity)livingentity);
                if (dist < 1024.0 && flag) {
                    this.target = livingentity;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.target.isAlive() && this.attackStep < this.maxSteps;
        }

        public void start() {
            this.mookaite.getNavigation().stop();
            this.maxSteps = this.mookaite.countColors(this.color) + 1;
            this.attackStep = 0;
            this.attackTime = 0;
        }

        public void tick() {
            this.mookaite.getLookControl().setLookAt((Entity)this.target, 10.0f, 10.0f);
            double tx = this.target.getX() - this.mookaite.getX();
            double ty = this.target.getEyeY();
            double tz = this.target.getZ() - this.mookaite.getZ();
            --this.attackTime;
            if (this.attackTime <= 0) {
                MookaiteAmmo bullet = new MookaiteAmmo(this.mookaite.level(), (LivingEntity)this.mookaite, new ItemStack(ModBlocks.ivory_mookaite));
                bullet.shoot(tx, ty - bullet.getY(), tz, 1.6f, 12.0f);
                this.mookaite.playSound(ModSounds.ENTITY_MOOKAITE_CONSTRUCT_SHOOT.get(), 1.0f, 1.0f / (this.mookaite.getRandom().nextFloat() * 0.4f + 0.8f));
                this.mookaite.level().addFreshEntity((Entity)bullet);
                ++this.attackStep;
                this.attackTime = 5;
            }
            super.tick();
        }
    }

    static abstract class TimedGoal
    extends Goal {
        protected final MookaiteConstruct mookaite;
        protected final MookaitePartType color;

        public TimedGoal(MookaiteConstruct entity, MookaitePartType color) {
            this.mookaite = entity;
            this.color = color;
        }

        public boolean canUse() {
            if (this.mookaite.getOpaliteCompanion() != null & this.mookaite.getBonder() != null && this.mookaite.countColors(this.color) > 0 && this.mookaite.attackCooldown <= 0) {
                return this.testAttack();
            }
            return false;
        }

        protected abstract boolean testAttack();

        public void stop() {
            this.mookaite.attackCooldown = 200;
        }
    }
}

