/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity.boss;

import androsa.gaiadimension.entity.HowliteWolf;
import androsa.gaiadimension.registry.registration.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;

public class BlueHowliteWolf
extends Monster {
    public BlueHowliteWolf(EntityType<? extends BlueHowliteWolf> entity, Level world) {
        super(entity, world);
        this.xpReward = 30;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.MOVEMENT_SPEED, 0.9);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, HowliteWolf.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{HowliteWolf.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.ENTITY_BLUE_HOWLITE_WOLF_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ENTITY_BLUE_HOWLITE_WOLF_HURT.get();
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public boolean checkSpawnRules(LevelAccessor world, EntitySpawnReason reason) {
        return true;
    }

    public static boolean canSpawnHere(EntityType<BlueHowliteWolf> entity, ServerLevelAccessor world, EntitySpawnReason spawn, BlockPos pos, RandomSource random) {
        if (world.getDifficulty() != Difficulty.PEACEFUL) {
            if (spawn == EntitySpawnReason.SPAWNER) {
                return BlueHowliteWolf.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
            }
            return world.getBlockState(pos.below()).isValidSpawn((BlockGetter)world, pos.below(), entity) && world.getBrightness(LightLayer.SKY, pos) > 8;
        }
        return false;
    }
}

