/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.fluids;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class SuperhotMagmaFluid
extends BaseFlowingFluid {
    public SuperhotMagmaFluid(BaseFlowingFluid.Properties props) {
        super(props);
    }

    protected void beforeDestroyingBlock(LevelAccessor iWorld, BlockPos pos, BlockState state) {
        this.triggerEffects(iWorld, pos);
        super.beforeDestroyingBlock(iWorld, pos, state);
    }

    protected boolean canBeReplacedWith(FluidState fluidstate, BlockGetter reader, BlockPos pos, Fluid fluid, Direction direction) {
        return fluidstate.getHeight(reader, pos) >= 0.44444445f && fluid.is(FluidTags.WATER);
    }

    public void animateTick(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos blockpos = pos.above();
        if (worldIn.getBlockState(blockpos).isAir() && !worldIn.getBlockState(blockpos).isSolidRender()) {
            if (random.nextInt(100) == 0) {
                double d0 = (float)pos.getX() + random.nextFloat();
                double d1 = pos.getY() + 1;
                double d2 = (float)pos.getZ() + random.nextFloat();
                worldIn.addParticle((ParticleOptions)ParticleTypes.LAVA, d0, d1, d2, 0.0, 0.0, 0.0);
                worldIn.playLocalSound(d0, d1, d2, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                worldIn.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public void randomTick(ServerLevel world, BlockPos pos, FluidState state, RandomSource random) {
        block7: {
            if (!world.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!world.isLoaded(blockpos = blockpos.offset(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState blockstate = world.getBlockState(blockpos);
                    if (blockstate.isAir()) {
                        if (!this.isSurroundingBlockFlammable((LevelAccessor)world, blockpos)) continue;
                        world.setBlockAndUpdate(blockpos, Blocks.FIRE.defaultBlockState());
                        return;
                    }
                    if (!blockstate.blocksMotion()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.offset(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!world.isLoaded(blockpos1)) {
                        return;
                    }
                    if (!world.isEmptyBlock(blockpos1.above()) || !this.getCanBlockBurn((LevelAccessor)world, blockpos1)) continue;
                    world.setBlockAndUpdate(blockpos1.above(), Blocks.FIRE.defaultBlockState());
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(LevelAccessor worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.getCanBlockBurn(worldIn, pos.relative(direction))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(LevelAccessor worldIn, BlockPos pos) {
        return (pos.getY() < 0 || pos.getY() >= 256 || worldIn.hasChunkAt(pos)) && worldIn.getBlockState(pos).ignitedByLava();
    }

    private void triggerEffects(LevelAccessor world, BlockPos pos) {
        world.levelEvent(1501, pos, 0);
    }
}

