/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.item.inventory;

import androsa.gaiadimension.item.inventory.GemPouchContainer;
import androsa.gaiadimension.registry.registration.ModDataComponents;
import androsa.gaiadimension.registry.values.GaiaTags;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class GemPouchMenu
implements Container,
MenuProvider {
    private final ItemStack invItem;
    private NonNullList<ItemStack> inventory;

    public GemPouchMenu(ItemStack stack) {
        this.invItem = stack;
        this.inventory = NonNullList.withSize((int)20, (Object)ItemStack.EMPTY);
        this.readFromStack(stack);
    }

    public int getContainerSize() {
        return 20;
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack stack = this.getItem(index);
        if (!stack.isEmpty()) {
            if (stack.getCount() > count) {
                stack = stack.split(count);
                this.setChanged();
            } else {
                this.setItem(index, ItemStack.EMPTY);
            }
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 16;
    }

    public void setChanged() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty() || this.getItem(i).getCount() != 0) continue;
            this.inventory.set(i, (Object)ItemStack.EMPTY);
        }
        this.writeToStack(this.invItem);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return stack.is(GaiaTags.Items.GEM_POUCH_ITEMS);
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gaiadimension.container.gemstone_pouch");
    }

    public void readFromStack(ItemStack stack) {
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ((ItemContainerContents)stack.getOrDefault(ModDataComponents.POUCH_CONTENTS, (Object)ItemContainerContents.EMPTY)).copyInto(this.inventory);
    }

    public void writeToStack(ItemStack stack) {
        stack.set(ModDataComponents.POUCH_CONTENTS, (Object)ItemContainerContents.fromItems(this.inventory));
    }

    public AbstractContainerMenu createMenu(int menuId, Inventory playerInv, Player player) {
        return new GemPouchContainer(menuId, playerInv, this);
    }
}

