/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class CavernTickModel
extends EntityModel<LivingEntityRenderState> {
    public ModelPart head;
    public ModelPart spike1;
    public ModelPart spike2;
    public ModelPart spike3;

    public CavernTickModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("body");
        this.head = body.getChild("head");
        this.spike1 = body.getChild("spike_left");
        this.spike2 = body.getChild("spike_mid");
        this.spike3 = body.getChild("spike_right");
    }

    public static LayerDefinition makeBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 7.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)-3.0f));
        body.addOrReplaceChild("spike_left", CubeListBuilder.create().texOffs(14, 11).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 5.0f), PartPose.offsetAndRotation((float)-1.5f, (float)0.5f, (float)2.0f, (float)0.87266463f, (float)-0.5235988f, (float)-0.61086524f));
        body.addOrReplaceChild("spike_mid", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.5f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("spike_right", CubeListBuilder.create().texOffs(0, 17).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 5.0f), PartPose.offsetAndRotation((float)1.5f, (float)0.5f, (float)2.0f, (float)0.87266463f, (float)0.5235988f, (float)0.61086524f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(17, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        head.addOrReplaceChild("horn", CubeListBuilder.create().texOffs(23, 8).addBox(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)-1.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)24);
    }

    public void setupAnim(LivingEntityRenderState state) {
        this.spike1.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.05f)) * 0.1f + 0.7853982f;
        this.spike2.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.05f)) * 0.1f + 0.7853982f;
        this.spike3.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.05f)) * 0.1f + 0.7853982f;
        this.head.yRot = state.yRot / 57.295776f;
    }
}

