/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.SquidRenderState;
import net.minecraft.util.Mth;

public class MineralArenthisModel
extends EntityModel<SquidRenderState> {
    public ModelPart body;
    public ModelPart tail;
    public ModelPart tailfin;
    public ModelPart[] tentacles = new ModelPart[10];

    public MineralArenthisModel(ModelPart root) {
        super(root);
        this.body = root.getChild("cap_top").getChild("cap_bottom").getChild("head").getChild("body");
        this.tail = this.body.getChild("tail");
        this.tailfin = this.tail.getChild("tail_fin");
        Arrays.setAll(this.tentacles, num -> root.getChild(MineralArenthisModel.getTentacleName(num)));
    }

    public static LayerDefinition makeBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition topcap = root.addOrReplaceChild("cap_top", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 0.0f, -8.0f, 16.0f, 7.0f, 16.0f), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition bottomcap = topcap.addOrReplaceChild("cap_bottom", CubeListBuilder.create().texOffs(44, 3).addBox(-10.0f, 0.0f, -10.0f, 20.0f, 6.0f, 20.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition head = bottomcap.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 23).addBox(-3.5f, 0.0f, -3.5f, 7.0f, 4.0f, 7.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition body = head.addOrReplaceChild("body", CubeListBuilder.create().texOffs(104, 0).addBox(-2.5f, 0.0f, -2.0f, 5.0f, 5.0f, 4.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        body.addOrReplaceChild("fin_left", CubeListBuilder.create().texOffs(-4, 41).addBox(0.0f, 0.0f, -2.0f, 10.0f, 0.0f, 4.0f), PartPose.offsetAndRotation((float)2.2f, (float)0.5f, (float)0.1f, (float)0.0f, (float)0.0f, (float)1.2217305f));
        body.addOrReplaceChild("fin_right", CubeListBuilder.create().texOffs(-4, 36).addBox(-10.0f, 0.0f, -2.0f, 10.0f, 0.0f, 4.0f), PartPose.offsetAndRotation((float)-2.2f, (float)0.5f, (float)0.1f, (float)0.0f, (float)0.0f, (float)-1.2217305f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 7.0f, 2.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        tail.addOrReplaceChild("tail_fin", CubeListBuilder.create().texOffs(86, 30).addBox(-5.5f, 0.0f, 0.0f, 11.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        CubeListBuilder tentaclecube = CubeListBuilder.create().texOffs(28, 23).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f);
        for (int j = 0; j < 10; ++j) {
            double d0 = (double)j * Math.PI * 2.0 / 10.0;
            float f = (float)Math.cos(d0) * 8.0f;
            float f1 = (float)Math.sin(d0) * 8.0f;
            d0 = (double)j * Math.PI * -2.0 / 10.0 + 1.5707963267948966;
            root.addOrReplaceChild(MineralArenthisModel.getTentacleName(j), tentaclecube, PartPose.offsetAndRotation((float)f, (float)5.0f, (float)f1, (float)0.0f, (float)((float)d0), (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)80);
    }

    public static String getTentacleName(int num) {
        return "tentacle_" + num;
    }

    public void setupAnim(SquidRenderState state) {
        this.body.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.025f)) * 0.3f;
        this.tail.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.025f)) * 0.3f;
        this.tailfin.xRot = Mth.sin((float)(state.ageInTicks * (float)Math.PI * 0.025f)) * 0.3f;
        for (ModelPart modelrenderer : this.tentacles) {
            modelrenderer.xRot = state.tentacleAngle;
        }
    }
}

