/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class RockyLuggerothModel
extends EntityModel<LivingEntityRenderState> {
    public ModelPart root;
    public ModelPart head;
    public ModelPart foot1;
    public ModelPart foot2;
    public ModelPart foot3;
    public ModelPart foot4;

    public RockyLuggerothModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.foot1 = root.getChild("foot_front_left");
        this.foot2 = root.getChild("foot_front_right");
        this.foot3 = root.getChild("foot_back_left");
        this.foot4 = root.getChild("foot_back_right");
    }

    public static LayerDefinition makeBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 0).addBox(-2.5f, -2.0f, -5.0f, 5.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)18.8f, (float)-8.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -5.0f, 8.0f, 3.0f, 16.0f), PartPose.offset((float)0.0f, (float)16.0f, (float)-3.0f));
        PartDefinition shell = body.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(46, 9).addBox(-5.0f, -18.0f, -10.0f, 10.0f, 18.0f, 20.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        shell.addOrReplaceChild("ridge", CubeListBuilder.create().texOffs(0, 41).addBox(-6.0f, 0.0f, -11.0f, 12.0f, 1.0f, 22.0f), PartPose.ZERO);
        root.addOrReplaceChild("foot_front_left", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)-2.5f, (float)18.0f, (float)-6.0f));
        root.addOrReplaceChild("foot_front_right", CubeListBuilder.create().texOffs(52, 0).addBox(0.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)2.5f, (float)18.0f, (float)-6.0f));
        root.addOrReplaceChild("foot_back_left", CubeListBuilder.create().texOffs(64, 0).addBox(-3.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)-2.5f, (float)18.0f, (float)6.0f));
        root.addOrReplaceChild("foot_back_right", CubeListBuilder.create().texOffs(76, 0).addBox(0.0f, 0.0f, 0.0f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)2.5f, (float)18.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        this.head.yRot = state.yRot / 57.295776f;
        this.head.xRot = state.xRot / 57.295776f;
        this.foot1.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.5f * state.walkAnimationSpeed;
        this.foot2.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.5f * state.walkAnimationSpeed;
        this.foot3.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 0.5f * state.walkAnimationSpeed;
        this.foot4.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 0.5f * state.walkAnimationSpeed;
    }
}

