/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.potion;

import androsa.gaiadimension.registry.bootstrap.GaiaDamage;
import androsa.gaiadimension.registry.registration.ModEffects;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.values.GaiaTags;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="gaiadimension")
public class CorruptionEffect
extends MobEffect {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"attack_boost");

    public CorruptionEffect(int color) {
        super(MobEffectCategory.HARMFUL, color);
        this.addAttributeModifier(Attributes.ATTACK_DAMAGE, NAME, 4.0, AttributeModifier.Operation.ADD_VALUE);
    }

    public boolean applyEffectTick(ServerLevel level, LivingEntity living, int amplifier) {
        if (!living.getType().is(GaiaTags.Entities.CORRUPT)) {
            living.hurt(GaiaDamage.getDamage((Level)level, GaiaDamage.CORRUPTION), 2.0f);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int j = 25 >> amplifier;
        return j <= 0 || duration % j == 0;
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent.Pre e) {
        LivingEntity attacker;
        Entity entity;
        DamageSource source;
        if (e.getEntity().hasEffect(ModEffects.goldstone_plague) && (source = e.getContainer().getSource()).getDirectEntity() != null && (entity = source.getDirectEntity()) instanceof LivingEntity && (attacker = (LivingEntity)entity).getType().is(GaiaTags.Entities.CORRUPT)) {
            e.getContainer().setNewDamage(e.getOriginalDamage() * 1.5f);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent e) {
        Entity corrputSpawn = ((EntityType)ModEntities.CORRUPT_SAPPER.get()).create(e.getEntity().getCommandSenderWorld(), EntitySpawnReason.CONVERSION);
        if (e.getSource().is(GaiaDamage.CORRUPTION)) {
            e.getEntity().getCommandSenderWorld().addFreshEntity(corrputSpawn);
        }
    }

    @SubscribeEvent
    public static void applyEffect(MobEffectEvent.Applicable e) {
        if (e.getEntity().getType().is(GaiaTags.Entities.CORRUPT)) {
            e.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }
}

