/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public abstract class DoubleOutputRecipe
implements Recipe<SingleRecipeInput> {
    private final String group;
    private final Ingredient input;
    private final ItemStack result;
    private final ItemStack byproduct;
    protected final float experience;
    protected final int cookTime;
    private PlacementInfo placement;

    public DoubleOutputRecipe(String group, Ingredient input, ItemStack result, ItemStack byproduct, float exp, int time) {
        this.group = group;
        this.input = input;
        this.result = result;
        this.byproduct = byproduct;
        this.experience = exp;
        this.cookTime = time;
    }

    public String group() {
        return this.group;
    }

    public Ingredient input() {
        return this.input;
    }

    public ItemStack result() {
        return this.result;
    }

    public ItemStack byproduct() {
        return this.byproduct;
    }

    public float experience() {
        return this.experience;
    }

    public int cookTime() {
        return this.cookTime;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.input.test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public PlacementInfo placementInfo() {
        if (this.placement == null) {
            this.placement = PlacementInfo.create((Ingredient)this.input);
        }
        return this.placement;
    }

    public static class Serializer<T extends DoubleOutputRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(DoubleOutputRecipe::group), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(DoubleOutputRecipe::input), (App)ItemStack.CODEC.fieldOf("result").forGetter(DoubleOutputRecipe::result), (App)ItemStack.CODEC.fieldOf("byproduct").forGetter(DoubleOutputRecipe::byproduct), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(DoubleOutputRecipe::experience), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)timeIn).forGetter(DoubleOutputRecipe::cookTime)).apply((Applicative)instance, factoryIn::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Recipe::group, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, DoubleOutputRecipe::input, (StreamCodec)ItemStack.STREAM_CODEC, DoubleOutputRecipe::result, (StreamCodec)ItemStack.STREAM_CODEC, DoubleOutputRecipe::byproduct, (StreamCodec)ByteBufCodecs.FLOAT, DoubleOutputRecipe::experience, (StreamCodec)ByteBufCodecs.INT, DoubleOutputRecipe::cookTime, factoryIn::create);

        public Serializer(Factory<T> factoryIn, int timeIn) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends DoubleOutputRecipe> {
        public T create(String var1, Ingredient var2, ItemStack var3, ItemStack var4, float var5, int var6);
    }
}

