/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.helpers;

import androsa.gaiadimension.GaiaDimensionMod;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

public class GaiaConfig {
    private static final String config = "gaiadimension.config.";
    public static ModConfigSpec.ConfigValue<List<? extends String>> starsInSky;
    public static ResourceLocation startDimRL;
    public static ResourceKey<Level> startDimRK;
    public static List<? extends String> starBiomes;
    public static ModConfigSpec.ConfigValue<? extends String> startDimension;
    public static ModConfigSpec.BooleanValue portalCheck;
    public static ModConfigSpec.EnumValue<ListType> listType;

    public static boolean canDisplayStars(ResourceKey<Biome> define) {
        return ((List)starsInSky.get()).contains(define.location().toString());
    }

    public static void checkDimension() {
        ResourceLocation rl = ResourceLocation.tryParse((String)((String)startDimension.get()));
        if (rl == null) {
            GaiaDimensionMod.LOGGER.warn("Could not create a ResourceLocation with the Start Dimension! Is there a typo, or is there an incorrect character?");
            rl = Level.OVERWORLD.location();
        }
        startDimRL = rl;
        startDimRK = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)startDimRL);
    }

    static {
        starBiomes = Collections.singletonList("gaiadimension:purple_agate_swamp");
    }

    @EventBusSubscriber(modid="gaiadimension", bus=EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void onConfigChanged(ModConfigEvent.Reloading event) {
            ModConfigSpec forgeSpec;
            IConfigSpec iConfigSpec;
            if (event.getConfig().getModId().equals("gaiadimension") && (iConfigSpec = event.getConfig().getSpec()) instanceof ModConfigSpec && (forgeSpec = (ModConfigSpec)iConfigSpec).isLoaded()) {
                GaiaDimensionMod.LOGGER.debug("ForgeConfigSpec is: {}.\nThis is to verify that there is or is not a ForgeConfigSpec.\nDo report this if the ForgeConfigSpec comes out as a null, as this is impossible.", (Object)forgeSpec);
                GaiaConfig.checkDimension();
            }
        }
    }

    @EventBusSubscriber(modid="gaiadimension", bus=EventBusSubscriber.Bus.GAME)
    public static class ForgeBus {
        @SubscribeEvent
        public static void onConfigLoaded(ServerStartingEvent event) {
            GaiaConfig.checkDimension();
        }
    }

    public static enum ListType {
        BLACKLIST,
        WHITELIST;

    }

    public static class CommonConfig {
        public CommonConfig(ModConfigSpec.Builder builder) {
            startDimension = builder.translation("gaiadimension.config.start_dimension").comment("The Dimension that Gaia will connect to. Results may vary based on the Level chosen. Existing portals will remain regardless of what is set here until they are broken, however they may no longer connect.").define("startDimension", (Object)"minecraft:overworld");
            portalCheck = builder.translation("gaiadimension.config.portal_creation").comment("Change how the portal can be created. If true, the portal will check where it is allowed to spawn based on the type of list and what contents are in the list.").define("portalCheck", true);
            listType = builder.translation("gaiadimension.config.list_type").comment("Changes whether the portal_biomes Biome Tag is a blacklist or a whitelist. A blacklist will exclude biomes from the portal, anything not on the list is allowed. A whitelist will allow biomes for the portal, anything on the list is allowed. If portalCheck is false, this value is unused.").defineEnum("listType", (Enum)ListType.WHITELIST);
        }
    }

    public static class ClientConfig {
        public ClientConfig(ModConfigSpec.Builder builder) {
            starsInSky = builder.translation("gaiadimension.config.stars_in_sky").comment("A list of biomes to always display stars. This will only work in the dimension as this is where stars are rendered per biome").defineList("starsInSky", starBiomes, p -> true);
        }
    }
}

