/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.helpers;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class PropertiesHandler {
    public static BlockBehaviour.Properties glassProps(MapColor color, float hardness) {
        return PropertiesHandler.basicProps(color, SoundType.GLASS, hardness, 0.0f).noOcclusion();
    }

    public static BlockBehaviour.Properties sandProps(MapColor color, float hardness, SoundType sound) {
        return PropertiesHandler.basicProps(color, sound, hardness, 0.0f);
    }

    public static BlockBehaviour.Properties stoneProps(MapColor color, float hardness, float resistance) {
        return PropertiesHandler.stoneProps(color, hardness, resistance, false);
    }

    public static BlockBehaviour.Properties stoneProps(MapColor color, float hardness, float resistance, boolean tool) {
        BlockBehaviour.Properties props = PropertiesHandler.basicProps(color, SoundType.STONE, hardness, resistance);
        if (tool) {
            props.requiresCorrectToolForDrops();
        }
        return props;
    }

    public static BlockBehaviour.Properties soilProps(MapColor color) {
        return PropertiesHandler.basicProps(color, SoundType.GRAVEL, 0.9f, 0.0f);
    }

    public static BlockBehaviour.Properties grassProps(MapColor color) {
        return PropertiesHandler.basicProps(color, SoundType.GRASS, 0.9f, 0.0f).randomTicks();
    }

    public static BlockBehaviour.Properties saplingProps(MapColor color) {
        return PropertiesHandler.basicProps(color, SoundType.GLASS, 0.0f).noCollission().randomTicks();
    }

    public static BlockBehaviour.Properties leavesProps(MapColor color) {
        return PropertiesHandler.basicProps(color, SoundType.GLASS, 0.3f, 0.0f).noOcclusion();
    }

    public static BlockBehaviour.Properties logProps(MapColor color) {
        return PropertiesHandler.logProps(color, color);
    }

    public static BlockBehaviour.Properties logProps(MapColor top, MapColor side) {
        return BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? top : side).strength(1.5f, 2.0f).sound(SoundType.STONE);
    }

    public static BlockBehaviour.Properties tileProps(MapColor color) {
        return PropertiesHandler.stoneProps(color, 10.0f, 150.0f);
    }

    public static BlockBehaviour.Properties curtainProps(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).strength(1.0f).sound(SoundType.GLASS).noOcclusion().pushReaction(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties storageProps(MapColor color) {
        return PropertiesHandler.basicProps(color, SoundType.METAL, 5.0f, 10.0f).requiresCorrectToolForDrops();
    }

    public static BlockBehaviour.Properties oreProps(MapColor color) {
        return PropertiesHandler.stoneProps(color, 4.0f, 25.0f, true);
    }

    public static BlockBehaviour.Properties bloomProps() {
        return PropertiesHandler.plantProps(MapColor.TERRACOTTA_MAGENTA, false);
    }

    public static BlockBehaviour.Properties plantProps(MapColor color, boolean isGlass) {
        return BlockBehaviour.Properties.of().mapColor(color).strength(0.0f).sound(isGlass ? SoundType.GLASS : SoundType.GRASS).noCollission();
    }

    public static BlockBehaviour.Properties muckyProps(MapColor color, float speed, float jump) {
        return BlockBehaviour.Properties.of().mapColor(color).strength(0.6f, 0.0f).sound(SoundType.MUD).speedFactor(speed).jumpFactor(jump).isRedstoneConductor((state, getter, pos) -> true).isViewBlocking((state, getter, pos) -> true).isSuffocating((state, getter, pos) -> true);
    }

    public static BlockBehaviour.Properties gaiaBrickProps() {
        return PropertiesHandler.stoneProps(MapColor.COLOR_MAGENTA, 2.0f, 20.0f, true);
    }

    public static BlockBehaviour.Properties jadeProps() {
        return PropertiesHandler.stoneProps(MapColor.COLOR_LIGHT_GREEN, 2.0f, 20.0f, true);
    }

    public static BlockBehaviour.Properties copalProps() {
        return PropertiesHandler.stoneProps(MapColor.TERRACOTTA_ORANGE, 2.0f, 20.0f, true);
    }

    public static BlockBehaviour.Properties jetProps() {
        return PropertiesHandler.stoneProps(MapColor.COLOR_BLACK, 2.0f, 20.0f, true);
    }

    public static BlockBehaviour.Properties amethystProps() {
        return PropertiesHandler.stoneProps(MapColor.COLOR_PURPLE, 2.0f, 20.0f, true);
    }

    public static BlockBehaviour.Properties malachiteProps() {
        return PropertiesHandler.stoneProps(MapColor.COLOR_GREEN, 20.0f, 200.0f, true);
    }

    public static BlockBehaviour.Properties spawnerProps() {
        return BlockBehaviour.Properties.of().strength(-1.0f).sound(SoundType.METAL).noOcclusion();
    }

    public static BlockBehaviour.Properties torchProps() {
        return BlockBehaviour.Properties.of().strength(0.0f).lightLevel(state -> 14).noCollission();
    }

    public static BlockBehaviour.Properties liquidProps(MapColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).replaceable().noCollission().pushReaction(PushReaction.DESTROY).noLootTable().sound(SoundType.EMPTY).liquid();
    }

    public static BlockBehaviour.Properties basicProps(MapColor color, SoundType sound, float strength) {
        return PropertiesHandler.basicProps(color, sound, strength, strength);
    }

    public static BlockBehaviour.Properties basicProps(MapColor color, SoundType sound, float hardness, float resistance) {
        return BlockBehaviour.Properties.of().mapColor(color).strength(hardness, resistance).sound(sound);
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityTicker<? super E> ticker) {
        return ticker;
    }
}

