/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.registration;

import androsa.gaiadimension.entity.AgateGolem;
import androsa.gaiadimension.entity.AncientLagrahk;
import androsa.gaiadimension.entity.ArchaicWarrior;
import androsa.gaiadimension.entity.AureateEvraun;
import androsa.gaiadimension.entity.BismuthUletrus;
import androsa.gaiadimension.entity.CavernTick;
import androsa.gaiadimension.entity.ContortedNaga;
import androsa.gaiadimension.entity.CorruptSapper;
import androsa.gaiadimension.entity.CrystalGolem;
import androsa.gaiadimension.entity.GrowthGrazer;
import androsa.gaiadimension.entity.GrowthSapper;
import androsa.gaiadimension.entity.HowliteWolf;
import androsa.gaiadimension.entity.LesserShockshooter;
import androsa.gaiadimension.entity.LesserSpitfire;
import androsa.gaiadimension.entity.MalachiteDrone;
import androsa.gaiadimension.entity.MarkuzarPlant;
import androsa.gaiadimension.entity.MineralArenthis;
import androsa.gaiadimension.entity.MookaiteConstruct;
import androsa.gaiadimension.entity.Muckling;
import androsa.gaiadimension.entity.MutantGrowthExtractor;
import androsa.gaiadimension.entity.NomadicLagrahk;
import androsa.gaiadimension.entity.OpaliteContruct;
import androsa.gaiadimension.entity.PrimalBeast;
import androsa.gaiadimension.entity.RockyLuggeroth;
import androsa.gaiadimension.entity.RuggedLurmorus;
import androsa.gaiadimension.entity.Saltion;
import androsa.gaiadimension.entity.ShallowArenthis;
import androsa.gaiadimension.entity.Shalurker;
import androsa.gaiadimension.entity.SpellElemental;
import androsa.gaiadimension.entity.boss.BlueHowliteWolf;
import androsa.gaiadimension.entity.boss.MalachiteGuard;
import androsa.gaiadimension.entity.data.GuardPhase;
import androsa.gaiadimension.entity.data.LagrahkVariant;
import androsa.gaiadimension.entity.data.MookaitePartType;
import androsa.gaiadimension.entity.data.SapperVariant;
import androsa.gaiadimension.entity.data.ThreeStagePhase;
import androsa.gaiadimension.entity.projectile.AgateArrow;
import androsa.gaiadimension.entity.projectile.MookaiteAmmo;
import androsa.gaiadimension.entity.projectile.MookaiteAreaEffect;
import androsa.gaiadimension.entity.projectile.MookaiteMagic;
import androsa.gaiadimension.entity.projectile.ThrownPebble;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="gaiadimension", bus=EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"gaiadimension");
    public static final DeferredRegister<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZERS = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"gaiadimension");
    public static final DeferredHolder<EntityType<?>, EntityType<AgateArrow>> AGATE_ARROW = ModEntities.registerProjectile("agate_arrow", AgateArrow::new, true, 150, 1, 0.5f, 0.5f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownPebble>> THROWN_PEBBLE = ModEntities.registerProjectile("thrown_pebble", ThrownPebble::new, true, 150, 2, 0.25f, 0.25f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<MookaiteAmmo>> MOOKAITE_AMMO_BULLET = ModEntities.registerProjectile("mookaite_ammo_bullet", MookaiteAmmo::new, true, 150, 2, 0.25f, 0.25f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<MookaiteMagic>> MOOKAITE_MAGIC_BULLET = ModEntities.registerProjectile("mookaite_magic_bullet", MookaiteMagic::new, true, 150, 10, 0.25f, 0.25f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<MookaiteAreaEffect>> MOOKAITE_MAGIC_AREA = ModEntities.registerProjectile("mookaite_magic_area", MookaiteAreaEffect::new, true, 150, Integer.MAX_VALUE, 6.0f, 0.5f, true);
    public static final DeferredHolder<EntityType<?>, EntityType<AgateGolem>> AGATE_GOLEM = ModEntities.registerEntity("agate_golem", AgateGolem::new, MobCategory.CREATURE, 1.2f, 2.7f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<AncientLagrahk>> ANCIENT_LAGRAHK = ModEntities.registerEntity("ancient_lagrahk", AncientLagrahk::new, MobCategory.MONSTER, 1.5f, 4.0f, 3.55f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<ArchaicWarrior>> ARCHAIC_WARRIOR = ModEntities.registerEntity("archaic_warrior", ArchaicWarrior::new, MobCategory.MONSTER, 0.6f, 1.95f, 1.74f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<BismuthUletrus>> BISMUTH_ULETRUS = ModEntities.registerEntity("bismuth_uletrus", BismuthUletrus::new, MobCategory.CREATURE, 2.0f, 1.8f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<CavernTick>> CAVERN_TICK = ModEntities.registerEntity("cavern_tick", CavernTick::new, MobCategory.MONSTER, 0.4f, 0.3f, 0.1f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<ContortedNaga>> CONTORTED_NAGA = ModEntities.registerEntity("contorted_naga", ContortedNaga::new, MobCategory.MONSTER, 1.0f, 2.6f, 2.3f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<CorruptSapper>> CORRUPT_SAPPER = ModEntities.registerEntity("corrupt_sapper", CorruptSapper::new, MobCategory.MONSTER, 1.0f, 1.0f, 0.7f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<CrystalGolem>> CRYSTAL_GOLEM = ModEntities.registerEntity("crystal_golem", CrystalGolem::new, MobCategory.CREATURE, 1.2f, 2.7f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<GrowthSapper>> GROWTH_SAPPER = ModEntities.registerEntity("growth_sapper", GrowthSapper::new, MobCategory.CREATURE, 1.0f, 1.0f, 0.7f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<HowliteWolf>> HOWLITE_WOLF = ModEntities.registerEntity("howlite_wolf", HowliteWolf::new, MobCategory.CREATURE, 1.0f, 1.0f, 0.68f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<LesserShockshooter>> LESSER_SHOCKSHOOTER = ModEntities.registerEntity("lesser_shockshooter", LesserShockshooter::new, MobCategory.MONSTER, 0.5f, 2.0f, 1.8f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<LesserSpitfire>> LESSER_SPITFIRE = ModEntities.registerEntity("lesser_spitfire", LesserSpitfire::new, MobCategory.MONSTER, 0.5f, 2.0f, 1.8f, true);
    public static final DeferredHolder<EntityType<?>, EntityType<MarkuzarPlant>> MARKUZAR_PLANT = ModEntities.registerEntity("markuzar_plant", MarkuzarPlant::new, MobCategory.AMBIENT, 0.6f, 2.0f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<MineralArenthis>> MINERAL_ARENTHIS = ModEntities.registerEntity("mineral_arenthis", MineralArenthis::new, MobCategory.WATER_CREATURE, 1.5f, 1.5f, 0.85f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<Muckling>> MUCKLING = ModEntities.registerEntity("muckling", Muckling::new, MobCategory.MONSTER, 0.5f, 0.5f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<MutantGrowthExtractor>> MUTANT_GROWTH_EXTRACTOR = ModEntities.registerEntity("mutant_growth_extractor", MutantGrowthExtractor::new, MobCategory.CREATURE, 1.0f, 1.5f, 1.3f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<NomadicLagrahk>> NOMADIC_LAGRAHK = ModEntities.registerEntity("nomadic_lagrahk", NomadicLagrahk::new, MobCategory.CREATURE, 1.5f, 4.0f, 3.55f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<PrimalBeast>> PRIMAL_BEAST = ModEntities.registerEntity("primal_beast", PrimalBeast::new, MobCategory.MONSTER, 1.0f, 2.0f, 1.9f, true);
    public static final DeferredHolder<EntityType<?>, EntityType<RockyLuggeroth>> ROCKY_LUGGEROTH = ModEntities.registerEntity("rocky_luggeroth", RockyLuggeroth::new, MobCategory.CREATURE, 1.0f, 1.6f, 0.35f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<RuggedLurmorus>> RUGGED_LURMORUS = ModEntities.registerEntity("rugged_lurmorus", RuggedLurmorus::new, MobCategory.CREATURE, 3.5f, 8.0f, 7.6f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<Saltion>> SALTION = ModEntities.registerEntity("saltion", Saltion::new, MobCategory.CREATURE, 1.0f, 0.3f, 0.25f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<ShallowArenthis>> SHALLOW_ARENTHIS = ModEntities.registerEntity("shallow_arenthis", ShallowArenthis::new, MobCategory.WATER_CREATURE, 0.6f, 0.6f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<Shalurker>> SHALURKER = ModEntities.registerEntity("shalurker", Shalurker::new, MobCategory.MONSTER, 0.6f, 1.9f, 1.75f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<SpellElemental>> SPELLBOUND_ELEMENTAL = ModEntities.registerEntity("spellbound_elemental", SpellElemental::new, MobCategory.CREATURE, 0.5f, 2.0f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<MalachiteDrone>> MALACHITE_DRONE = ModEntities.registerEntity("malachite_drone", MalachiteDrone::new, MobCategory.MONSTER, 1.0f, 2.0f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<MookaiteConstruct>> MOOKAITE_CONSTRUCT = ModEntities.registerEntity("mookaite_construct", MookaiteConstruct::new, MobCategory.CREATURE, 1.2f, 3.2f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<OpaliteContruct>> OPALITE_CONSTRUCT = ModEntities.registerEntity("opalite_construct", OpaliteContruct::new, MobCategory.CREATURE, 1.0f, 1.5f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<GrowthGrazer>> GROWTH_GRAZER = ModEntities.registerEntity("growth_grazer", GrowthGrazer::new, MobCategory.CREATURE, 1.0f, 1.0f, 0.7f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<AureateEvraun>> AUREATE_EVRAUN = ModEntities.registerEntity("aureate_evraun", AureateEvraun::new, MobCategory.CREATURE, 2.7f, 3.8f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<BlueHowliteWolf>> BLUE_HOWLITE_WOLF = ModEntities.registerEntity("blue_howlite_wolf", BlueHowliteWolf::new, MobCategory.MONSTER, 1.2f, 2.2f, 2.1f, false);
    public static final DeferredHolder<EntityType<?>, EntityType<MalachiteGuard>> MALACHITE_GUARD = ModEntities.registerEntity("malachite_guard", MalachiteGuard::new, MobCategory.MONSTER, 0.8f, 3.3f, 3.0f, false);
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<MookaitePartType>> MOOKAITE_PART = ENTITY_DATA_SERIALIZERS.register("mookaite_part", () -> EntityDataSerializer.forValueType(MookaitePartType.STREAM_CODEC));
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<GuardPhase>> GUARD_PHASE = ENTITY_DATA_SERIALIZERS.register("guard_phase", () -> EntityDataSerializer.forValueType(GuardPhase.STREAM_CODEC));
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<ThreeStagePhase>> THREE_STAGE_PHASE = ENTITY_DATA_SERIALIZERS.register("three_stage_phase", () -> EntityDataSerializer.forValueType(ThreeStagePhase.STREAM_CODEC));
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<SapperVariant>> SAPPER_VARIANT = ENTITY_DATA_SERIALIZERS.register("sapper_variant", () -> EntityDataSerializer.forValueType(SapperVariant.STREAM_CODEC));
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<LagrahkVariant>> LAGRAHK_VARIANT = ENTITY_DATA_SERIALIZERS.register("lagrahk_variant", () -> EntityDataSerializer.forValueType(LagrahkVariant.STREAM_CODEC));

    public static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> registerProjectile(String name, EntityType.EntityFactory<E> entity, boolean updates, int range, int interval, float width, float height, boolean fireproof) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)name));
        EntityType.Builder entitytype = ModEntities.makeBuilder(entity, MobCategory.MISC, width, height).setShouldReceiveVelocityUpdates(updates).setTrackingRange(range).setUpdateInterval(interval).noLootTable();
        if (fireproof) {
            entitytype.fireImmune();
        }
        return ENTITY_TYPES.register(name, () -> entitytype.build(key));
    }

    public static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> registerEntity(String name, EntityType.EntityFactory<E> entity, MobCategory classification, float width, float height, boolean fireproof) {
        return ModEntities.registerEntity(name, entity, classification, width, height, 0.0f, fireproof);
    }

    public static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> registerEntity(String name, EntityType.EntityFactory<E> entity, MobCategory classification, float width, float height, float eye, boolean fireproof) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)name));
        EntityType.Builder type = ModEntities.makeBuilder(entity, classification, width, height);
        if (fireproof) {
            type.fireImmune();
        }
        if (eye > 0.0f) {
            type.eyeHeight(eye);
        }
        return ENTITY_TYPES.register(name, () -> type.build(key));
    }

    private static <E extends Entity> EntityType.Builder<E> makeBuilder(EntityType.EntityFactory<E> entity, MobCategory classification, float width, float height) {
        return EntityType.Builder.of(entity, (MobCategory)classification).sized(width, height);
    }

    @SubscribeEvent
    public static void registerSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        ModEntities.registerPlacement(event, AGATE_GOLEM, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AgateGolem::canSpawnHere);
        ModEntities.registerPlacement(event, ANCIENT_LAGRAHK, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AncientLagrahk::canSpawnHere);
        ModEntities.registerPlacement(event, ARCHAIC_WARRIOR, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        ModEntities.registerPlacement(event, BISMUTH_ULETRUS, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BismuthUletrus::canSpawnHere);
        ModEntities.registerPlacement(event, BLUE_HOWLITE_WOLF, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlueHowliteWolf::canSpawnHere);
        ModEntities.registerPlacement(event, CAVERN_TICK, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        ModEntities.registerPlacement(event, CONTORTED_NAGA, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ContortedNaga::canSpawnHere);
        ModEntities.registerPlacement(event, CORRUPT_SAPPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CorruptSapper::canSpawnHere);
        ModEntities.registerPlacement(event, CRYSTAL_GOLEM, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrystalGolem::canSpawnHere);
        ModEntities.registerPlacement(event, GROWTH_SAPPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GrowthSapper::canSpawnHere);
        ModEntities.registerPlacement(event, HOWLITE_WOLF, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HowliteWolf::canSpawnHere);
        ModEntities.registerPlacement(event, LESSER_SHOCKSHOOTER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LesserShockshooter::canSpawnHere);
        ModEntities.registerPlacement(event, LESSER_SPITFIRE, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LesserSpitfire::canSpawnHere);
        ModEntities.registerPlacement(event, MARKUZAR_PLANT, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MarkuzarPlant::canSpawnHere);
        ModEntities.registerPlacement(event, MINERAL_ARENTHIS, SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MineralArenthis::canSpawnHere);
        ModEntities.registerPlacement(event, MUCKLING, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Muckling::canSpawnHere);
        ModEntities.registerPlacement(event, MUTANT_GROWTH_EXTRACTOR, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MutantGrowthExtractor::canSpawnHere);
        ModEntities.registerPlacement(event, NOMADIC_LAGRAHK, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, NomadicLagrahk::canSpawnHere);
        ModEntities.registerPlacement(event, PRIMAL_BEAST, SpawnPlacementTypes.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PrimalBeast::canSpawnHere);
        ModEntities.registerPlacement(event, ROCKY_LUGGEROTH, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RockyLuggeroth::canSpawnHere);
        ModEntities.registerPlacement(event, RUGGED_LURMORUS, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RuggedLurmorus::canSpawnHere);
        ModEntities.registerPlacement(event, SALTION, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Saltion::canSpawnHere);
        ModEntities.registerPlacement(event, SHALLOW_ARENTHIS, SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ShallowArenthis::canSpawnHere);
        ModEntities.registerPlacement(event, SHALURKER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkMonsterSpawnRules);
        ModEntities.registerPlacement(event, SPELLBOUND_ELEMENTAL, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpellElemental::canSpawnHere);
        ModEntities.registerPlacement(event, MALACHITE_DRONE, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::checkAnyLightMonsterSpawnRules);
        ModEntities.registerPlacement(event, MOOKAITE_CONSTRUCT, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MookaiteConstruct::canSpawnHere);
        ModEntities.registerPlacement(event, OPALITE_CONSTRUCT, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OpaliteContruct::canSpawnHere);
        ModEntities.registerPlacement(event, GROWTH_GRAZER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GrowthGrazer::canSpawnHere);
        ModEntities.registerPlacement(event, AUREATE_EVRAUN, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AureateEvraun::canSpawnHere);
    }

    private static <E extends Mob, T extends EntityType<E>> void registerPlacement(RegisterSpawnPlacementsEvent event, Supplier<T> entity, SpawnPlacementType type, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<E> predicate) {
        event.register((EntityType)entity.get(), type, heightmap, predicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent evt) {
        ModEntities.setAttributes(evt, AGATE_GOLEM, AgateGolem.registerAttributes());
        ModEntities.setAttributes(evt, ANCIENT_LAGRAHK, AncientLagrahk.registerAttributes());
        ModEntities.setAttributes(evt, ARCHAIC_WARRIOR, ArchaicWarrior.registerAttributes());
        ModEntities.setAttributes(evt, BISMUTH_ULETRUS, BismuthUletrus.registerAttributes());
        ModEntities.setAttributes(evt, CAVERN_TICK, CavernTick.registerAttributes());
        ModEntities.setAttributes(evt, CONTORTED_NAGA, ContortedNaga.registerAttributes());
        ModEntities.setAttributes(evt, CORRUPT_SAPPER, CorruptSapper.registerAttributes());
        ModEntities.setAttributes(evt, CRYSTAL_GOLEM, CrystalGolem.registerAttributes());
        ModEntities.setAttributes(evt, GROWTH_SAPPER, GrowthSapper.registerAttributes());
        ModEntities.setAttributes(evt, HOWLITE_WOLF, HowliteWolf.registerAttributes());
        ModEntities.setAttributes(evt, LESSER_SHOCKSHOOTER, LesserShockshooter.registerAttributes());
        ModEntities.setAttributes(evt, LESSER_SPITFIRE, LesserSpitfire.registerAttributes());
        ModEntities.setAttributes(evt, MARKUZAR_PLANT, MarkuzarPlant.registerAttributes());
        ModEntities.setAttributes(evt, MINERAL_ARENTHIS, MineralArenthis.registerAttributes());
        ModEntities.setAttributes(evt, MUCKLING, Monster.createMonsterAttributes());
        ModEntities.setAttributes(evt, MUTANT_GROWTH_EXTRACTOR, MutantGrowthExtractor.registerAttributes());
        ModEntities.setAttributes(evt, NOMADIC_LAGRAHK, NomadicLagrahk.registerAttributes());
        ModEntities.setAttributes(evt, PRIMAL_BEAST, PrimalBeast.registerAttributes());
        ModEntities.setAttributes(evt, ROCKY_LUGGEROTH, RockyLuggeroth.registerAttributes());
        ModEntities.setAttributes(evt, RUGGED_LURMORUS, RuggedLurmorus.registerAttributes());
        ModEntities.setAttributes(evt, SALTION, Saltion.registerAttributes());
        ModEntities.setAttributes(evt, SHALLOW_ARENTHIS, ShallowArenthis.registerAttributes());
        ModEntities.setAttributes(evt, SHALURKER, Shalurker.registerAttributes());
        ModEntities.setAttributes(evt, SPELLBOUND_ELEMENTAL, SpellElemental.registerAttributes());
        ModEntities.setAttributes(evt, MALACHITE_DRONE, MalachiteDrone.registerAttributes());
        ModEntities.setAttributes(evt, MOOKAITE_CONSTRUCT, MookaiteConstruct.registerAttributes());
        ModEntities.setAttributes(evt, OPALITE_CONSTRUCT, OpaliteContruct.registerAttributes());
        ModEntities.setAttributes(evt, GROWTH_GRAZER, GrowthGrazer.registerAttributes());
        ModEntities.setAttributes(evt, AUREATE_EVRAUN, AureateEvraun.registerAttributes());
        ModEntities.setAttributes(evt, BLUE_HOWLITE_WOLF, BlueHowliteWolf.registerAttributes());
        ModEntities.setAttributes(evt, MALACHITE_GUARD, MalachiteGuard.registerAttributes());
    }

    private static <E extends LivingEntity> void setAttributes(EntityAttributeCreationEvent evt, Supplier<EntityType<E>> entity, AttributeSupplier.Builder builder) {
        evt.put(entity.get(), builder.build());
    }
}

