/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry.values;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class GaiaTags {
    private static final String ID = "gaiadimension";

    private static TagKey<Item> tagItem(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)name));
    }

    private static TagKey<Item> tagItemCommon(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    private static TagKey<Block> tagBlock(String name) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)name));
    }

    private static TagKey<Block> tagBlockCommon(String name) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
    }

    private static TagKey<Fluid> tagFluid(String name) {
        return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)name));
    }

    private static TagKey<Biome> tagStructure(String name) {
        return GaiaTags.tagBiome("has_structure/" + name);
    }

    private static TagKey<Biome> tagBiome(String name) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)name));
    }

    private static TagKey<EntityType<?>> tagEntity(String name) {
        return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)name));
    }

    public static class Entities {
        public static final TagKey<EntityType<?>> GAIAN = GaiaTags.tagEntity("gaian");
        public static final TagKey<EntityType<?>> CORRUPT = GaiaTags.tagEntity("corrupt");
        public static final TagKey<EntityType<?>> CORRUPTION_IMMUNE = GaiaTags.tagEntity("corruption_immune");
    }

    public static class Biomes {
        public static final TagKey<Biome> HAS_MINI_TOWER = GaiaTags.tagStructure("mini_tower");
        public static final TagKey<Biome> HAS_MALACHITE_WATCHTOWER = GaiaTags.tagStructure("malachite_watchtower");
        public static final TagKey<Biome> PORTAL_BIOMES = GaiaTags.tagBiome("portal_biomes");
        public static final TagKey<Biome> GAIA_BIOMES = GaiaTags.tagBiome("is_gaia");
        public static final TagKey<Biome> AGATE_BIOMES = GaiaTags.tagBiome("is_agate");
        public static final TagKey<Biome> GOLDEN_BIOMES = GaiaTags.tagBiome("is_golden");
    }

    public static class Fluids {
        public static final TagKey<Fluid> MINERAL_WATER = GaiaTags.tagFluid("mineral_water");
        public static final TagKey<Fluid> SUPERHOT_MAGMA = GaiaTags.tagFluid("superhot_magma");
        public static final TagKey<Fluid> SWEET_MUCK = GaiaTags.tagFluid("sweet_muck");
        public static final TagKey<Fluid> LIQUID_BISMUTH = GaiaTags.tagFluid("liquid_bismuth");
        public static final TagKey<Fluid> LIQUID_AURA = GaiaTags.tagFluid("liquid_aura");
    }

    public static class Blocks {
        public static final TagKey<Block> GAIA_STONE = GaiaTags.tagBlock("base_stone_gaia");
        public static final TagKey<Block> VOLCANIC = GaiaTags.tagBlock("base_stone_volcanic");
        public static final TagKey<Block> STATIC = GaiaTags.tagBlock("base_stone_static");
        public static final TagKey<Block> PRIMAL = GaiaTags.tagBlock("base_stone_primal");
        public static final TagKey<Block> MOOKAITE = GaiaTags.tagBlock("mookaite");
        public static final TagKey<Block> GAIA_CARVER_REPLACEABLES = GaiaTags.tagBlock("gaia_carver_replaceables");
        public static final TagKey<Block> GAIA_GRASS = GaiaTags.tagBlock("gaia_grass");
        public static final TagKey<Block> GAIA_SOIL = GaiaTags.tagBlock("gaia_soil");
        public static final TagKey<Block> TILES = GaiaTags.tagBlock("agate_tiles");
        public static final TagKey<Block> PINK_AGATE_LOGS = GaiaTags.tagBlock("pink_agate_logs");
        public static final TagKey<Block> BLUE_AGATE_LOGS = GaiaTags.tagBlock("blue_agate_logs");
        public static final TagKey<Block> GREEN_AGATE_LOGS = GaiaTags.tagBlock("green_agate_logs");
        public static final TagKey<Block> PURPLE_AGATE_LOGS = GaiaTags.tagBlock("purple_agate_logs");
        public static final TagKey<Block> FOSSILIZED_LOGS = GaiaTags.tagBlock("fossilized_logs");
        public static final TagKey<Block> CORRUPTED_LOGS = GaiaTags.tagBlock("corrupted_logs");
        public static final TagKey<Block> BURNT_LOGS = GaiaTags.tagBlock("burnt_logs");
        public static final TagKey<Block> BURNING_LOGS = GaiaTags.tagBlock("burning_logs");
        public static final TagKey<Block> AURA_LOGS = GaiaTags.tagBlock("aura_logs");
        public static final TagKey<Block> GOLDEN_LOGS = GaiaTags.tagBlock("golden_logs");
        public static final TagKey<Block> GAIA_BRICKS = GaiaTags.tagBlock("gaia_bricks");
        public static final TagKey<Block> AMETHYST_BRICKS = GaiaTags.tagBlock("amethyst_bricks");
        public static final TagKey<Block> COPAL_BRICKS = GaiaTags.tagBlock("copal_bricks");
        public static final TagKey<Block> JADE_BRICKS = GaiaTags.tagBlock("jade_bricks");
        public static final TagKey<Block> JET_BRICKS = GaiaTags.tagBlock("jet_bricks");
        public static final TagKey<Block> ORES_SUGILITE = GaiaTags.tagBlockCommon("ore/sugilite");
        public static final TagKey<Block> ORES_HEMATITE = GaiaTags.tagBlockCommon("ore/hematite");
        public static final TagKey<Block> ORES_CINNABAR = GaiaTags.tagBlockCommon("ore/cinnabar");
        public static final TagKey<Block> ORES_LABRADORITE = GaiaTags.tagBlockCommon("ore/labradorite");
        public static final TagKey<Block> ORES_MOONSTONE = GaiaTags.tagBlockCommon("ore/moonstone");
        public static final TagKey<Block> ORES_RED_OPAL = GaiaTags.tagBlockCommon("ore/red_opal");
        public static final TagKey<Block> ORES_BLUE_OPAL = GaiaTags.tagBlockCommon("ore/blue_opal");
        public static final TagKey<Block> ORES_GREEN_OPAL = GaiaTags.tagBlockCommon("ore/green_opal");
        public static final TagKey<Block> ORES_WHITE_OPAL = GaiaTags.tagBlockCommon("ore/white_opal");
        public static final TagKey<Block> ORES_PYRITE = GaiaTags.tagBlockCommon("ore/pyrite");
        public static final TagKey<Block> ORES_OPALITE = GaiaTags.tagBlockCommon("ore/opalite");
        public static final TagKey<Block> ORES_CELESTINE = GaiaTags.tagBlockCommon("ore/celestine");
        public static final TagKey<Block> STORAGE_BLOCKS_SUGILITE = GaiaTags.tagBlockCommon("storage_blocks/sugilite");
        public static final TagKey<Block> STORAGE_BLOCKS_HEMATITE = GaiaTags.tagBlockCommon("storage_blocks/hematite");
        public static final TagKey<Block> STORAGE_BLOCKS_CINNABAR = GaiaTags.tagBlockCommon("storage_blocks/cinnabar");
        public static final TagKey<Block> STORAGE_BLOCKS_LABRADORITE = GaiaTags.tagBlockCommon("storage_blocks/labradorite");
        public static final TagKey<Block> STORAGE_BLOCKS_MOONSTONE = GaiaTags.tagBlockCommon("storage_blocks/moonstone");
        public static final TagKey<Block> STORAGE_BLOCKS_RED_OPAL = GaiaTags.tagBlockCommon("storage_blocks/red_opal");
        public static final TagKey<Block> STORAGE_BLOCKS_BLUE_OPAL = GaiaTags.tagBlockCommon("storage_blocks/blue_opal");
        public static final TagKey<Block> STORAGE_BLOCKS_GREEN_OPAL = GaiaTags.tagBlockCommon("storage_blocks/green_opal");
        public static final TagKey<Block> STORAGE_BLOCKS_WHITE_OPAL = GaiaTags.tagBlockCommon("storage_blocks/white_opal");
        public static final TagKey<Block> STORAGE_BLOCKS_PYRITE = GaiaTags.tagBlockCommon("storage_blocks/pyrite");
        public static final TagKey<Block> STORAGE_BLOCKS_TEKTITE = GaiaTags.tagBlockCommon("storage_blocks/tektite");
        public static final TagKey<Block> STORAGE_BLOCKS_GOLDSTONE = GaiaTags.tagBlockCommon("storage_blocks/goldstone");
        public static final TagKey<Block> STORAGE_BLOCKS_AURA_CRYSTAL = GaiaTags.tagBlockCommon("storage_blocks/aura");
        public static final TagKey<Block> STORAGE_BLOCKS_BISMUTH = GaiaTags.tagBlockCommon("storage_blocks/bismuth");
        public static final TagKey<Block> STORAGE_BLOCKS_OPALITE = GaiaTags.tagBlockCommon("storage_blocks/opalite");
        public static final TagKey<Block> STORAGE_BLOCKS_STIBNITE = GaiaTags.tagBlockCommon("storage_blocks/stibnite");
        public static final TagKey<Block> STORAGE_BLOCKS_PROUSTITE = GaiaTags.tagBlockCommon("storage_blocks/proustite");
        public static final TagKey<Block> STORAGE_BLOCKS_EUCLASE = GaiaTags.tagBlockCommon("storage_blocks/euclase");
        public static final TagKey<Block> STORAGE_BLOCKS_ALBITE = GaiaTags.tagBlockCommon("storage_blocks/albite");
        public static final TagKey<Block> STORAGE_BLOCKS_CARNELIAN = GaiaTags.tagBlockCommon("storage_blocks/carnelian");
        public static final TagKey<Block> STORAGE_BLOCKS_BENITOITE = GaiaTags.tagBlockCommon("storage_blocks/benitoite");
        public static final TagKey<Block> STORAGE_BLOCKS_DIOPSIDE = GaiaTags.tagBlockCommon("storage_blocks/diopside");
        public static final TagKey<Block> STORAGE_BLOCKS_GOSHENITE = GaiaTags.tagBlockCommon("storage_blocks/goshenite");
        public static final TagKey<Block> STORAGE_BLOCKS_CELESTINE = GaiaTags.tagBlockCommon("storage_blocks/celestine");
        public static final TagKey<Block> GAIA_PLANTS = GaiaTags.tagBlock("gaia_plants");
        public static final TagKey<Block> INCORRECT_FOR_AGATE = GaiaTags.tagBlock("incorrect_for_agate_tool");
        public static final TagKey<Block> INCORRECT_FOR_SUGILITE = GaiaTags.tagBlock("incorrect_for_sugilite_tool");
        public static final TagKey<Block> INCORRECT_FOR_STIBNITE = GaiaTags.tagBlock("incorrect_for_stibnite_tool");
        public static final TagKey<Block> INCORRECT_FOR_EUCLASE = GaiaTags.tagBlock("incorrect_for_euclase_tool");
        public static final TagKey<Block> INCORRECT_FOR_CARNELIAN = GaiaTags.tagBlock("incorrect_for_carnelian_tool");
        public static final TagKey<Block> INCORRECT_FOR_BENITOITE = GaiaTags.tagBlock("incorrect_for_benitoite_tool");
        public static final TagKey<Block> INCORRECT_FOR_GOSHENITE = GaiaTags.tagBlock("incorrect_for_goshenite_tool");
        public static final TagKey<Block> INCORRECT_FOR_MALACHITE = GaiaTags.tagBlock("incorrect_for_malachite_tool");
        public static final TagKey<Block> INCORRECT_FOR_TIGER_EYE = GaiaTags.tagBlock("incorrect_for_tiger_eye_tool");
        public static final TagKey<Block> INCORRECT_FOR_SPINEL = GaiaTags.tagBlock("incorrect_for_spinel_tool");
        public static final TagKey<Block> INCORRECT_FOR_ZIRCON = GaiaTags.tagBlock("incorrect_for_zircon_tool");
        public static final TagKey<Block> INCORRECT_FOR_CORRUPT = GaiaTags.tagBlock("incorrect_for_corrupt_tool");
        public static final TagKey<Block> INCORRECT_FOR_BIXBITE = GaiaTags.tagBlock("incorrect_for_bixbite_tool");
        public static final TagKey<Block> INCORRECT_FOR_TSAVORITE = GaiaTags.tagBlock("incorrect_for_tsavorite_tool");
        public static final TagKey<Block> INCORRECT_FOR_LARVIKITE = GaiaTags.tagBlock("incorrect_for_larvikite_tool");
        public static final TagKey<Block> INCORRECT_FOR_CHAMPION = GaiaTags.tagBlock("incorrect_for_champion_tool");
    }

    public static class Items {
        public static final TagKey<Item> ORES_SUGILITE = GaiaTags.tagItemCommon("ore/sugilite");
        public static final TagKey<Item> ORES_HEMATITE = GaiaTags.tagItemCommon("ore/hematite");
        public static final TagKey<Item> ORES_CINNABAR = GaiaTags.tagItemCommon("ore/cinnabar");
        public static final TagKey<Item> ORES_LABRADORITE = GaiaTags.tagItemCommon("ore/labradorite");
        public static final TagKey<Item> ORES_MOONSTONE = GaiaTags.tagItemCommon("ore/moonstone");
        public static final TagKey<Item> ORES_RED_OPAL = GaiaTags.tagItemCommon("ore/red_opal");
        public static final TagKey<Item> ORES_BLUE_OPAL = GaiaTags.tagItemCommon("ore/blue_opal");
        public static final TagKey<Item> ORES_GREEN_OPAL = GaiaTags.tagItemCommon("ore/green_opal");
        public static final TagKey<Item> ORES_WHITE_OPAL = GaiaTags.tagItemCommon("ore/white_opal");
        public static final TagKey<Item> ORES_PYRITE = GaiaTags.tagItemCommon("ore/pyrite");
        public static final TagKey<Item> ORES_OPALITE = GaiaTags.tagItemCommon("ore/opalite");
        public static final TagKey<Item> STORAGE_BLOCKS_SUGILITE = GaiaTags.tagItemCommon("storage_blocks/sugilite");
        public static final TagKey<Item> STORAGE_BLOCKS_HEMATITE = GaiaTags.tagItemCommon("storage_blocks/hematite");
        public static final TagKey<Item> STORAGE_BLOCKS_CINNABAR = GaiaTags.tagItemCommon("storage_blocks/cinnabar");
        public static final TagKey<Item> STORAGE_BLOCKS_LABRADORITE = GaiaTags.tagItemCommon("storage_blocks/labradorite");
        public static final TagKey<Item> STORAGE_BLOCKS_MOONSTONE = GaiaTags.tagItemCommon("storage_blocks/moonstone");
        public static final TagKey<Item> STORAGE_BLOCKS_RED_OPAL = GaiaTags.tagItemCommon("storage_blocks/red_opal");
        public static final TagKey<Item> STORAGE_BLOCKS_BLUE_OPAL = GaiaTags.tagItemCommon("storage_blocks/blue_opal");
        public static final TagKey<Item> STORAGE_BLOCKS_GREEN_OPAL = GaiaTags.tagItemCommon("storage_blocks/green_opal");
        public static final TagKey<Item> STORAGE_BLOCKS_WHITE_OPAL = GaiaTags.tagItemCommon("storage_blocks/white_opal");
        public static final TagKey<Item> STORAGE_BLOCKS_PYRITE = GaiaTags.tagItemCommon("storage_blocks/pyrite");
        public static final TagKey<Item> STORAGE_BLOCKS_TEKTITE = GaiaTags.tagItemCommon("storage_blocks/tektite");
        public static final TagKey<Item> STORAGE_BLOCKS_GOLDSTONE = GaiaTags.tagItemCommon("storage_blocks/goldstone");
        public static final TagKey<Item> STORAGE_BLOCKS_AURA_CRYSTAL = GaiaTags.tagItemCommon("storage_blocks/aura");
        public static final TagKey<Item> STORAGE_BLOCKS_BISMUTH = GaiaTags.tagItemCommon("storage_blocks/bismuth");
        public static final TagKey<Item> STORAGE_BLOCKS_STIBNITE = GaiaTags.tagItemCommon("storage_blocks/stibnite");
        public static final TagKey<Item> STORAGE_BLOCKS_PROUSTITE = GaiaTags.tagItemCommon("storage_blocks/proustite");
        public static final TagKey<Item> STORAGE_BLOCKS_EUCLASE = GaiaTags.tagItemCommon("storage_blocks/euclase");
        public static final TagKey<Item> STORAGE_BLOCKS_ALBITE = GaiaTags.tagItemCommon("storage_blocks/albite");
        public static final TagKey<Item> STORAGE_BLOCKS_CARNELIAN = GaiaTags.tagItemCommon("storage_blocks/carnelian");
        public static final TagKey<Item> STORAGE_BLOCKS_BENITOITE = GaiaTags.tagItemCommon("storage_blocks/benitoite");
        public static final TagKey<Item> STORAGE_BLOCKS_DIOPSIDE = GaiaTags.tagItemCommon("storage_blocks/diopside");
        public static final TagKey<Item> STORAGE_BLOCKS_GOSHENITE = GaiaTags.tagItemCommon("storage_blocks/goshenite");
        public static final TagKey<Item> DUSTS_FINE = GaiaTags.tagItemCommon("dusts/fine");
        public static final TagKey<Item> DUSTS_GOLDSTONE = GaiaTags.tagItemCommon("dusts/goldstone");
        public static final TagKey<Item> DUSTS_HOT = GaiaTags.tagItemCommon("dusts/hot");
        public static final TagKey<Item> INGOTS_SCAYNYX = GaiaTags.tagItemCommon("ingots/scaynyx");
        public static final TagKey<Item> RODS_AGATE = GaiaTags.tagItemCommon("rods/agate");
        public static final TagKey<Item> GEMS_SUGILITE = GaiaTags.tagItemCommon("gems/sugilite");
        public static final TagKey<Item> GEMS_HEMATITE = GaiaTags.tagItemCommon("gems/hematite");
        public static final TagKey<Item> GEMS_CINNABAR = GaiaTags.tagItemCommon("gems/cinnabar");
        public static final TagKey<Item> GEMS_LABRADORITE = GaiaTags.tagItemCommon("gems/labradorite");
        public static final TagKey<Item> GEMS_MOONSTONE = GaiaTags.tagItemCommon("gems/moonstone");
        public static final TagKey<Item> GEMS_RED_OPAL = GaiaTags.tagItemCommon("gems/red_opal");
        public static final TagKey<Item> GEMS_BLUE_OPAL = GaiaTags.tagItemCommon("gems/blue_opal");
        public static final TagKey<Item> GEMS_GREEN_OPAL = GaiaTags.tagItemCommon("gems/green_opal");
        public static final TagKey<Item> GEMS_WHITE_OPAL = GaiaTags.tagItemCommon("gems/white_opal");
        public static final TagKey<Item> GEMS_STIBNITE = GaiaTags.tagItemCommon("gems/stibnite");
        public static final TagKey<Item> GEMS_PROUSTITE = GaiaTags.tagItemCommon("gems/proustite");
        public static final TagKey<Item> GEMS_EUCLASE = GaiaTags.tagItemCommon("gems/euclase");
        public static final TagKey<Item> GEMS_ALBITE = GaiaTags.tagItemCommon("gems/albite");
        public static final TagKey<Item> GEMS_CARNELIAN = GaiaTags.tagItemCommon("gems/carnelian");
        public static final TagKey<Item> GEMS_BENITOITE = GaiaTags.tagItemCommon("gems/benitoite");
        public static final TagKey<Item> GEMS_DIOPSIDE = GaiaTags.tagItemCommon("gems/diopside");
        public static final TagKey<Item> GEMS_GOSHENITE = GaiaTags.tagItemCommon("gems/goshenite");
        public static final TagKey<Item> GEMS_PYRITE = GaiaTags.tagItemCommon("gems/pyrite");
        public static final TagKey<Item> GEMS_TEKTITE = GaiaTags.tagItemCommon("gems/tektite");
        public static final TagKey<Item> GEMS_GOLDSTONE = GaiaTags.tagItemCommon("gems/goldstone");
        public static final TagKey<Item> GEMS_AURA = GaiaTags.tagItemCommon("gems/aura");
        public static final TagKey<Item> GEMS_BISMUTH = GaiaTags.tagItemCommon("gems/bismuth");
        public static final TagKey<Item> GEMS_OPALITE = GaiaTags.tagItemCommon("gems/opalite");
        public static final TagKey<Item> GEMS_CELESTINE = GaiaTags.tagItemCommon("gems/celestine");
        public static final TagKey<Item> SUGILITE_ARMOR_MATERIAL = GaiaTags.tagItem("sugilite_armor_materials");
        public static final TagKey<Item> PROUSTITE_ARMOR_MATERIAL = GaiaTags.tagItem("proustite_armor_materials");
        public static final TagKey<Item> ALBITE_ARMOR_MATERIAL = GaiaTags.tagItem("albite_armor_materials");
        public static final TagKey<Item> CARNELIAN_ARMOR_MATERIAL = GaiaTags.tagItem("carnelian_armor_materials");
        public static final TagKey<Item> DIOPSIDE_ARMOR_MATERIAL = GaiaTags.tagItem("diopside_armor_materials");
        public static final TagKey<Item> GOSHENITE_ARMOR_MATERIAL = GaiaTags.tagItem("goshenite_armor_materials");
        public static final TagKey<Item> AGATE_TOOL_MATERIAL = GaiaTags.tagItem("agate_tool_materials");
        public static final TagKey<Item> SUGILITE_TOOL_MATERIAL = GaiaTags.tagItem("sugilite_tool_materials");
        public static final TagKey<Item> STIBNITE_TOOL_MATERIAL = GaiaTags.tagItem("stibnite_tool_materials");
        public static final TagKey<Item> EUCLASE_TOOL_MATERIAL = GaiaTags.tagItem("euclase_tool_materials");
        public static final TagKey<Item> CARNELIAN_TOOL_MATERIAL = GaiaTags.tagItem("carnelian_tool_materials");
        public static final TagKey<Item> BENITOITE_TOOL_MATERIAL = GaiaTags.tagItem("benitoite_tool_materials");
        public static final TagKey<Item> GOSHENITE_TOOL_MATERIAL = GaiaTags.tagItem("goshenite_tool_materials");
        public static final TagKey<Item> UNOBTAINIUM = GaiaTags.tagItem("unobtainium");
        public static final TagKey<Item> MOOKAITE = GaiaTags.tagItem("mookaite");
        public static final TagKey<Item> TILES = GaiaTags.tagItem("agate_tiles");
        public static final TagKey<Item> PINK_AGATE_LOGS = GaiaTags.tagItem("pink_agate_logs");
        public static final TagKey<Item> BLUE_AGATE_LOGS = GaiaTags.tagItem("blue_agate_logs");
        public static final TagKey<Item> GREEN_AGATE_LOGS = GaiaTags.tagItem("green_agate_logs");
        public static final TagKey<Item> PURPLE_AGATE_LOGS = GaiaTags.tagItem("purple_agate_logs");
        public static final TagKey<Item> FOSSILIZED_LOGS = GaiaTags.tagItem("fossilized_logs");
        public static final TagKey<Item> CORRUPTED_LOGS = GaiaTags.tagItem("corrupted_logs");
        public static final TagKey<Item> BURNT_LOGS = GaiaTags.tagItem("burnt_logs");
        public static final TagKey<Item> BURNING_LOGS = GaiaTags.tagItem("burning_logs");
        public static final TagKey<Item> AURA_LOGS = GaiaTags.tagItem("aura_logs");
        public static final TagKey<Item> GOLDEN_LOGS = GaiaTags.tagItem("golden_logs");
        public static final TagKey<Item> GAIA_BRICKS = GaiaTags.tagItem("gaia_bricks");
        public static final TagKey<Item> AMETHYST_BRICKS = GaiaTags.tagItem("amethyst_bricks");
        public static final TagKey<Item> COPAL_BRICKS = GaiaTags.tagItem("copal_bricks");
        public static final TagKey<Item> JADE_BRICKS = GaiaTags.tagItem("jade_bricks");
        public static final TagKey<Item> JET_BRICKS = GaiaTags.tagItem("jet_bricks");
        public static final TagKey<Item> GEM_POUCH_ITEMS = GaiaTags.tagItem("gem_pouch_items");
        public static final TagKey<Item> CRUDE_STORAGE_BLACKLIST = GaiaTags.tagItem("crude_storage_blacklist");
        public static final TagKey<Item> MEGA_STORAGE_BLACKLIST = GaiaTags.tagItem("mega_storage_blacklist");
        public static final TagKey<Item> SHULKER_BOXES = ItemTags.create((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"shulker_boxes"));
    }
}

