/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.renderer;

import androsa.gaiadimension.entity.boss.MalachiteGuard;
import androsa.gaiadimension.entity.data.ThreeStagePhase;
import androsa.gaiadimension.model.MalachiteGuardModel;
import androsa.gaiadimension.model.renderstate.MalachiteGuardRenderState;
import androsa.gaiadimension.registry.helpers.ModEntitiesRendering;
import androsa.gaiadimension.renderer.layer.MalachiteDefenceLayer;
import androsa.gaiadimension.renderer.layer.MalachiteGuardGlowLayer;
import androsa.gaiadimension.renderer.layer.MalachiteResistLayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class MalachiteGuardRenderer<T extends MalachiteGuard, M extends MalachiteGuardModel>
extends MobRenderer<T, MalachiteGuardRenderState, M> {
    public MalachiteGuardRenderer(EntityRendererProvider.Context manager, M model, float shadowSize) {
        super(manager, model, shadowSize);
        this.addLayer(new MalachiteGuardGlowLayer(this));
        this.addLayer(new MalachiteDefenceLayer(this, manager.getModelSet()));
        this.addLayer(new MalachiteResistLayer(this, manager.getModelSet()));
    }

    public MalachiteGuardRenderState createRenderState() {
        return new MalachiteGuardRenderState();
    }

    public void extractRenderState(T entity, MalachiteGuardRenderState state, float partialTicks) {
        super.extractRenderState(entity, (LivingEntityRenderState)state, partialTicks);
        state.phase = ((MalachiteGuard)((Object)entity)).getPhase();
        state.chargePhase = ((MalachiteGuard)((Object)entity)).getChargePhase();
        state.stompPhase = ((MalachiteGuard)((Object)entity)).getStompPhase();
    }

    public ResourceLocation getTextureLocation(MalachiteGuardRenderState entity) {
        return ModEntitiesRendering.makeTexture("malachite_guard", "");
    }

    protected boolean isShaking(MalachiteGuardRenderState entity) {
        return entity.chargePhase == ThreeStagePhase.CHARGE;
    }
}

