/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world;

import androsa.gaiadimension.block.GaiaPortalBlock;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModPOIs;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;

public class GaiaTeleporter {
    private static final Block KEYSTONE = (Block)ModBlocks.keystone_block.get();
    private final ServerLevel world;

    public GaiaTeleporter(ServerLevel world) {
        this.world = world;
    }

    public Optional<BlockPos> getExistingPortal(BlockPos pos, WorldBorder border) {
        PoiManager poimanager = this.world.getPoiManager();
        int i = 16;
        poimanager.ensureLoadedAndValid((LevelReader)this.world, pos, i);
        return poimanager.getInSquare(type -> type.is(ModPOIs.GAIA_PORTAL.getKey()), pos, i, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).filter(arg_0 -> ((WorldBorder)border).isWithinBounds(arg_0)).filter(poi -> this.world.getBlockState(poi).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)).min(Comparator.comparingDouble(poi -> poi.distSqr((Vec3i)pos)).thenComparingInt(Vec3i::getY));
    }

    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder border = this.world.getWorldBorder();
        int height = Math.min(this.world.getMaxY(), this.world.getMinY() + this.world.getLogicalHeight()) - 1;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (BlockPos.MutableBlockPos mut : BlockPos.spiralAround((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            if (!border.isWithinBounds((BlockPos)mut) || !border.isWithinBounds((BlockPos)mut.move(direction, 1))) continue;
            mut.move(direction.getOpposite(), 1);
            for (int l = height; l >= this.world.getMinY(); --l) {
                int j1;
                mut.setY(l);
                if (!this.canReplaceBlock(mut)) continue;
                int i1 = l;
                while (l > this.world.getMinY() && this.canReplaceBlock(mut.move(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > height || (j1 = i1 - l) > 0 && j1 < 3) continue;
                mut.setY(l);
                if (!this.checkRegionForPlacement((BlockPos)mut, mutable, direction, 0)) continue;
                double d2 = pos.distSqr((Vec3i)mut);
                if (this.checkRegionForPlacement((BlockPos)mut, mutable, direction, -1) && this.checkRegionForPlacement((BlockPos)mut, mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = mut.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = mut.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.getX(), Mth.clamp((int)pos.getY(), (int)70, (int)(this.world.getHeight() - 10)), pos.getZ()).immutable();
            Direction drotated = direction.getClockWise();
            if (!border.isWithinBounds(blockpos)) {
                return Optional.empty();
            }
            for (int fOffset = -1; fOffset < 2; ++fOffset) {
                for (int fWidth = 0; fWidth < 2; ++fWidth) {
                    for (int fHeight = -1; fHeight < 3; ++fHeight) {
                        boolean flag = fHeight < 0;
                        mutable.setWithOffset((Vec3i)blockpos, fWidth * direction.getStepX() + fOffset * drotated.getStepX(), fHeight, fWidth * direction.getStepZ() + fOffset * direction.getStepZ());
                        this.world.setBlockAndUpdate((BlockPos)mutable, flag ? KEYSTONE.defaultBlockState() : Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
        for (int fWidth = -1; fWidth < 3; ++fWidth) {
            for (int fHeight = -1; fHeight < 4; ++fHeight) {
                if (fWidth != -1 && fWidth != 2 && fHeight != -1 && fHeight != 3) continue;
                mutable.setWithOffset((Vec3i)blockpos, fWidth * direction.getStepX(), fHeight, fWidth * direction.getStepZ());
                this.world.setBlockAndUpdate((BlockPos)mutable, KEYSTONE.defaultBlockState());
            }
        }
        BlockState portal = (BlockState)((GaiaPortalBlock)((Object)ModBlocks.gaia_portal.get())).defaultBlockState().setValue(GaiaPortalBlock.AXIS, (Comparable)axis);
        for (int pWidth = 0; pWidth < 2; ++pWidth) {
            for (int pHeight = 0; pHeight < 3; ++pHeight) {
                mutable.setWithOffset((Vec3i)blockpos, pWidth * direction.getStepX(), pHeight, pWidth * direction.getStepZ());
                this.world.setBlock((BlockPos)mutable, portal, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.immutable(), 2, 3));
    }

    private boolean checkRegionForPlacement(BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.getClockWise();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.setWithOffset((Vec3i)originalPos, directionIn.getStepX() * i + direction.getStepX() * offsetScale, j, directionIn.getStepZ() * i + direction.getStepZ() * offsetScale);
                if (j < 0 && !this.world.getBlockState((BlockPos)offsetPos).isSolid()) {
                    return false;
                }
                if (j < 0 || this.world.isEmptyBlock((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockPos.MutableBlockPos mutable) {
        BlockState state = this.world.getBlockState((BlockPos)mutable);
        return state.canBeReplaced() && state.getFluidState().isEmpty();
    }
}

