/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.chunk;

import androsa.gaiadimension.world.chunk.warp.TerrainPoint;
import androsa.gaiadimension.world.layer.GaiaLayerUtil;
import androsa.gaiadimension.world.layer.util.Layer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GaiaBiomeSource
extends BiomeSource {
    public static final MapCodec<GaiaBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RecordCodecBuilder.create(pair -> pair.group((App)TerrainPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.CODEC.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)pair, Pair::of)).listOf().fieldOf("biomes").forGetter(object -> object.list), (App)Codec.FLOAT.fieldOf("base_offset").forGetter(object -> Float.valueOf(object.offset)), (App)Codec.FLOAT.fieldOf("base_factor").forGetter(object -> Float.valueOf(object.factor)), (App)RegistryOps.retrieveGetter((ResourceKey)Registries.BIOME)).apply((Applicative)instance, GaiaBiomeSource::new));
    public long seed;
    private final HolderGetter<Biome> registry;
    private Layer genBiomes;
    private final float offset;
    private final float factor;
    private final List<Pair<TerrainPoint, Holder<Biome>>> list;

    public GaiaBiomeSource(List<Pair<TerrainPoint, Holder<Biome>>> list, float offset, float factor, HolderGetter<Biome> registry) {
        this.registry = registry;
        this.list = list;
        this.offset = offset;
        this.factor = factor;
    }

    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return this.list.stream().map(Pair::getSecond);
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z, Climate.Sampler sampler) {
        this.lazyLoad();
        return this.genBiomes.get(this.registry, x, z);
    }

    public float getBaseOffset() {
        return this.offset;
    }

    public float getBaseFactor() {
        return this.factor;
    }

    public float getBiomeDepth(int x, int y, int z, Climate.Sampler sampler) {
        Biome biome = (Biome)this.getNoiseBiome(x, y, z, sampler).value();
        return this.getBiomeDepth(biome);
    }

    public float getBiomeDepth(Biome biome) {
        return this.getBiomeValue(biome, TerrainPoint::depth);
    }

    public float getBiomeScale(int x, int y, int z, Climate.Sampler sampler) {
        Biome biome = (Biome)this.getNoiseBiome(x, y, z, sampler).value();
        return this.getBiomeScale(biome);
    }

    public float getBiomeScale(Biome biome) {
        return this.getBiomeValue(biome, TerrainPoint::scale);
    }

    private float getBiomeValue(Biome biome, Function<? super TerrainPoint, Float> function) {
        this.lazyLoad();
        return this.list.stream().filter(p -> ((Biome)((Holder)p.getSecond()).value()).equals(biome)).map(Pair::getFirst).map(function).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
    }

    private void lazyLoad() {
        if (this.genBiomes == null) {
            this.seed = ServerLifecycleHooks.getCurrentServer().getWorldData().worldGenOptions().seed();
            this.genBiomes = GaiaLayerUtil.makeLayers(this.seed, this.registry);
        }
    }
}

