/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.chunk;

import androsa.gaiadimension.registry.registration.ModBlocks;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceSystem;

public class GaiaSurfaceSystem
extends SurfaceSystem {
    public static final BlockState SCARLET_MOOKAITE = ((Block)ModBlocks.scarlet_mookaite.get()).defaultBlockState();
    public static final BlockState AUBURN_MOOKAITE = ((Block)ModBlocks.auburn_mookaite.get()).defaultBlockState();
    public static final BlockState GOLD_MOOKAITE = ((Block)ModBlocks.gold_mookaite.get()).defaultBlockState();
    public static final BlockState IVORY_MOOKAITE = ((Block)ModBlocks.ivory_mookaite.get()).defaultBlockState();
    public static final BlockState MAUVE_MOOKAITE = ((Block)ModBlocks.mauve_mookaite.get()).defaultBlockState();
    public static final BlockState BEIGE_MOOKAITE = ((Block)ModBlocks.beige_mookaite.get()).defaultBlockState();
    private final BlockState[] mookaiteBands;

    public GaiaSurfaceSystem(RandomState random, BlockState defaultstone, int sealevel, PositionalRandomFactory posrandom) {
        super(random, defaultstone, sealevel, posrandom);
        this.mookaiteBands = GaiaSurfaceSystem.generateBands(posrandom.fromHashOf(ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)"mookaite_bands")));
    }

    protected BlockState getBand(int x, int y, int z) {
        int i = (int)Math.round(this.clayBandsOffsetNoise.getValue((double)x, 0.0, (double)z) * 4.0);
        return this.mookaiteBands[(y + i + this.mookaiteBands.length) % this.mookaiteBands.length];
    }

    private static BlockState[] generateBands(RandomSource random) {
        Object[] ablockstate = new BlockState[192];
        Arrays.fill(ablockstate, AUBURN_MOOKAITE);
        for (int k = 0; k < ablockstate.length; ++k) {
            if ((k += random.nextInt(5) + 1) >= ablockstate.length) continue;
            ablockstate[k] = BEIGE_MOOKAITE;
        }
        int l = random.nextIntBetweenInclusive(9, 15);
        int i = 0;
        for (int j = 0; i < l && j < ablockstate.length; ++i, j += random.nextInt(16) + 4) {
            ablockstate[j] = IVORY_MOOKAITE;
            if (j - 1 > 0 && random.nextBoolean()) {
                ablockstate[j - 1] = BEIGE_MOOKAITE;
            }
            if (j + 1 >= ablockstate.length || !random.nextBoolean()) continue;
            ablockstate[j + 1] = BEIGE_MOOKAITE;
        }
        GaiaSurfaceSystem.makeBands(random, (BlockState[])ablockstate, 1, MAUVE_MOOKAITE);
        GaiaSurfaceSystem.makeBands(random, (BlockState[])ablockstate, 2, GOLD_MOOKAITE);
        GaiaSurfaceSystem.makeBands(random, (BlockState[])ablockstate, 1, IVORY_MOOKAITE);
        return ablockstate;
    }

    private static void makeBands(RandomSource random, BlockState[] states, int offset, BlockState state) {
        int rand = random.nextIntBetweenInclusive(6, 15);
        for (int j = 0; j < rand; ++j) {
            int k = offset + random.nextInt(3);
            int randstate = random.nextInt(states.length);
            for (int i1 = 0; randstate + i1 < states.length && i1 < k; ++i1) {
                states[randstate + i1] = state;
            }
        }
    }
}

