/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.chunk.warp;

import androsa.gaiadimension.world.chunk.GaiaBiomeSource;
import androsa.gaiadimension.world.chunk.warp.NoiseModifier;
import androsa.gaiadimension.world.chunk.warp.NoiseSlider;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;

public class GaiaTerrainWarp {
    private final int cellWidth;
    private final int cellHeight;
    private final int cellCountY;
    private final BiomeSource biomeSource;
    private final NoiseSettings noiseSettings;
    private final NoiseSlider topSlide;
    private final NoiseSlider bottomSlide;
    private final BlendedNoise blendedNoise;
    private final double dimensionDensityFactor;
    private final double dimensionDensityOffset;
    public final NoiseModifier caveNoiseModifier;
    protected static final float[] BIOME_WEIGHTS = (float[])Util.make((Object)new float[25], afloat -> {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                float weight;
                afloat[x + 2 + (z + 2) * 5] = weight = 10.0f / Mth.sqrt((float)((float)(x * x + z * z) + 0.2f));
            }
        }
    });

    public GaiaTerrainWarp(int width, int height, int yCount, BiomeSource source, NoiseSettings settings, NoiseSlider topSlide, NoiseSlider bottomSlide, BlendedNoise blend, NoiseModifier modifier) {
        double d;
        GaiaBiomeSource gsource;
        this.cellWidth = width;
        this.cellHeight = height;
        this.cellCountY = yCount;
        this.biomeSource = source;
        this.noiseSettings = settings;
        this.topSlide = topSlide;
        this.bottomSlide = bottomSlide;
        this.blendedNoise = blend;
        if (source instanceof GaiaBiomeSource) {
            gsource = (GaiaBiomeSource)source;
            v0 = gsource.getBaseFactor();
        } else {
            v0 = this.dimensionDensityFactor = 1.0;
        }
        if (source instanceof GaiaBiomeSource) {
            gsource = (GaiaBiomeSource)source;
            d = gsource.getBaseOffset();
        } else {
            d = 0.0;
        }
        this.dimensionDensityOffset = d;
        this.caveNoiseModifier = modifier;
    }

    public void fillNoiseColumn(double[] adouble, int x, int z, Climate.Sampler sampler, int sealevel, int min, int max) {
        BiomeSource biomeSource = this.biomeSource;
        if (biomeSource instanceof GaiaBiomeSource) {
            GaiaBiomeSource source = (GaiaBiomeSource)biomeSource;
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            float depth = source.getBiomeDepth(x, sealevel, z, sampler);
            for (int offX = -2; offX <= 2; ++offX) {
                for (int offZ = -2; offZ <= 2; ++offZ) {
                    Biome biome = (Biome)source.getNoiseBiome(x + offX, sealevel, z + offZ, sampler).value();
                    float offD = source.getBiomeDepth(biome);
                    float offS = source.getBiomeScale(biome);
                    float f6 = offD;
                    float f7 = offS;
                    float f8 = offD > depth ? 0.5f : 1.0f;
                    float f9 = f8 * BIOME_WEIGHTS[offX + 2 + (offZ + 2) * 5] / (f6 + 2.0f);
                    f += f7 * f9;
                    f1 += f6 * f9;
                    f2 += f9;
                }
            }
            float f10 = f1 / f2;
            float f11 = f / f2;
            double d6 = f10 * 0.5f - 0.125f;
            double d8 = f11 * 0.9f + 0.1f;
            double d0 = d6 * 0.265625;
            double d1 = 96.0 / d8;
            double density = -0.46875;
            for (int index = 0; index <= max; ++index) {
                int y = index + min;
                DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(x, y, z);
                double noise = this.blendedNoise.compute((DensityFunction.FunctionContext)context) * 128.0;
                double totaldensity = this.computeInitialDensity(y, d0, d1, density) + noise;
                totaldensity = this.caveNoiseModifier.modifyNoise(totaldensity, y * this.cellHeight, z * this.cellWidth, x * this.cellWidth);
                adouble[index] = totaldensity = this.applySlide(totaldensity, y);
            }
        } else {
            throw new IllegalArgumentException("BiomeSource is not an instance of GaiaBiomeSource");
        }
    }

    protected double computeInitialDensity(int y, double offset, double factor, double density) {
        double total;
        double base = 1.0 - (double)y * 2.0 / 32.0 + density;
        double factored = base * this.dimensionDensityFactor + this.dimensionDensityOffset;
        return total * (double)((total = (factored + offset) * factor) > 0.0 ? 4 : 1);
    }

    protected double applySlide(double density, int height) {
        int i = Math.floorDiv(this.noiseSettings.minY(), this.cellHeight);
        int j = height - i;
        density = this.topSlide.applySlide(density, this.cellCountY - j);
        density = this.bottomSlide.applySlide(density, j);
        return density;
    }
}

