/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.carver;

import androsa.gaiadimension.block.AbstractGaiaGrassBlock;
import androsa.gaiadimension.block.GaiaSoilBlock;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModFluids;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CoatedCavesWorldCarver<T extends CaveCarverConfiguration>
extends WorldCarver<T> {
    public CoatedCavesWorldCarver(Codec<T> config) {
        super(config);
        this.liquids = ImmutableSet.of((Object)((Fluid)ModFluids.mineral_water_still.get()));
    }

    public boolean isStartChunk(T config, RandomSource rand) {
        return rand.nextFloat() <= ((CaveCarverConfiguration)config).probability;
    }

    public boolean carve(CarvingContext context, T config, ChunkAccess chunkIn, Function<BlockPos, Holder<Biome>> biomePos, RandomSource rand, Aquifer aquifer, ChunkPos chunkpos, CarvingMask carvingMask) {
        int i = SectionPos.sectionToBlockCoord((int)(this.getRange() * 2 - 1));
        int j = rand.nextInt(rand.nextInt(rand.nextInt(this.getCaveBound()) + 1) + 1);
        for (int k = 0; k < j; ++k) {
            double bX = chunkpos.getBlockX(rand.nextInt(16));
            double bY = ((CaveCarverConfiguration)config).y.sample(rand, (WorldGenerationContext)context);
            double bZ = chunkpos.getBlockZ(rand.nextInt(16));
            double hR = ((CaveCarverConfiguration)config).horizontalRadiusMultiplier.sample(rand);
            double vR = ((CaveCarverConfiguration)config).verticalRadiusMultiplier.sample(rand);
            double floor = ((CaveCarverConfiguration)config).floorLevel.sample(rand);
            WorldCarver.CarveSkipChecker skipchecker = (cxt, x, y, z, noise) -> CoatedCavesWorldCarver.skip(x, y, z, floor);
            int l = 1;
            if (rand.nextInt(4) == 0) {
                double sY = ((CaveCarverConfiguration)config).yScale.sample(rand);
                float f1 = 1.0f + rand.nextFloat() * 6.0f;
                this.genRoom(context, config, chunkIn, biomePos, aquifer, bX, bY, bZ, f1, sY, carvingMask, skipchecker);
                l += rand.nextInt(4);
            }
            for (int k1 = 0; k1 < l; ++k1) {
                float f = rand.nextFloat() * ((float)Math.PI * 2);
                float f3 = (rand.nextFloat() - 0.5f) / 4.0f;
                float width = this.generateCaveRadius(rand);
                int i1 = i - rand.nextInt(i / 4);
                this.genTunnels(context, config, chunkIn, biomePos, rand.nextLong(), aquifer, bX, bY, bZ, hR, vR, width, f, f3, 0, i1, this.getYScale(), carvingMask, skipchecker);
            }
        }
        return true;
    }

    protected int getCaveBound() {
        return 15;
    }

    protected float generateCaveRadius(RandomSource rand) {
        float f = rand.nextFloat() * 2.0f + rand.nextFloat();
        if (rand.nextInt(10) == 0) {
            f *= rand.nextFloat() * rand.nextFloat() * 3.0f + 1.0f;
        }
        return f;
    }

    protected double getYScale() {
        return 1.0;
    }

    protected void genRoom(CarvingContext context, T config, ChunkAccess chunkIn, Function<BlockPos, Holder<Biome>> biomePos, Aquifer aquifer, double x, double y, double z, float radius, double diameter, CarvingMask mask, WorldCarver.CarveSkipChecker checker) {
        double d0 = 1.5 + (double)(Mth.sin((float)1.5707964f) * radius);
        double d1 = d0 * diameter;
        this.carveEllipsoid(context, (CarverConfiguration)config, chunkIn, biomePos, aquifer, x + 1.0, y, z, d0, d1, mask, checker);
    }

    protected void genTunnels(CarvingContext context, T config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> biomepos, long seed, Aquifer aquifer, double x, double y, double z, double hRad, double vRad, float width, float yaw, float pitch, int base, int max, double scale, CarvingMask mask, WorldCarver.CarveSkipChecker checker) {
        Random random = new Random(seed);
        int i = random.nextInt(max / 2) + max / 4;
        boolean flag = random.nextInt(6) == 0;
        float f = 0.0f;
        float f1 = 0.0f;
        for (int j = base; j < max; ++j) {
            double d0 = 1.5 + (double)(Mth.sin((float)((float)Math.PI * (float)j / (float)max)) * width);
            double d1 = d0 * scale;
            float f2 = Mth.cos((float)pitch);
            x += (double)(Mth.cos((float)yaw) * f2);
            y += (double)Mth.sin((float)pitch);
            z += (double)(Mth.sin((float)yaw) * f2);
            pitch *= flag ? 0.92f : 0.7f;
            pitch += f1 * 0.1f;
            yaw += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (j == i && width > 1.0f) {
                this.genTunnels(context, config, chunk, biomepos, random.nextLong(), aquifer, x, y, z, hRad, vRad, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, j, max, 1.0, mask, checker);
                this.genTunnels(context, config, chunk, biomepos, random.nextLong(), aquifer, x, y, z, hRad, vRad, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, j, max, 1.0, mask, checker);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!CoatedCavesWorldCarver.canReach((ChunkPos)chunk.getPos(), (double)x, (double)z, (int)j, (int)max, (float)width)) {
                return;
            }
            this.carveEllipsoid(context, (CarverConfiguration)config, chunk, biomepos, aquifer, x, y, z, d0 * hRad, d1 * vRad, mask, checker);
        }
    }

    protected boolean carveBlock(CarvingContext context, T config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> biomepos, CarvingMask mask, BlockPos.MutableBlockPos mutable, BlockPos.MutableBlockPos newmutable, Aquifer aquifer, MutableBoolean bool) {
        BlockState blockstate = chunk.getBlockState((BlockPos)mutable);
        if (blockstate.getBlock() instanceof AbstractGaiaGrassBlock) {
            bool.setTrue();
        }
        if (!this.canReplaceBlock((CarverConfiguration)config, blockstate)) {
            return false;
        }
        BlockState state = this.getCarveState(context, config, (BlockPos)mutable, aquifer);
        if (state == null) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            FluidState around = chunk.getFluidState(newmutable.relative(dir));
            FluidState above = chunk.getFluidState(newmutable.offset((Vec3i)mutable.offset(0, 1, 0)));
            FluidState aroundabove = chunk.getFluidState(newmutable.offset((Vec3i)mutable.offset(0, 1, 1).relative(dir)));
            if (around.is((Fluid)ModFluids.mineral_water_still.get()) || above.is((Fluid)ModFluids.mineral_water_still.get()) || aroundabove.is((Fluid)ModFluids.mineral_water_still.get())) {
                return false;
            }
            chunk.setBlockState((BlockPos)mutable, state, false);
            if (!bool.isTrue()) continue;
            newmutable.setWithOffset((Vec3i)mutable, Direction.DOWN);
            if (!(chunk.getBlockState((BlockPos)newmutable).getBlock() instanceof GaiaSoilBlock)) continue;
            context.topMaterial(biomepos, chunk, (BlockPos)newmutable, !state.getFluidState().isEmpty()).ifPresent(newstate -> {
                chunk.setBlockState((BlockPos)newmutable, newstate, false);
                if (!newstate.getFluidState().isEmpty()) {
                    chunk.markPosForPostprocessing((BlockPos)newmutable);
                }
            });
        }
        return true;
    }

    private BlockState getCarveState(CarvingContext context, T config, BlockPos pos, Aquifer aquifer) {
        if (pos.getY() <= ((CaveCarverConfiguration)config).lavaLevel.resolveY((WorldGenerationContext)context)) {
            return ((FlowingFluid)ModFluids.superhot_magma_still.get()).defaultFluidState().createLegacyBlock();
        }
        BlockState blockstate = aquifer.computeSubstance((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()), 0.0);
        return blockstate == ((Block)ModBlocks.gaia_stone.get()).defaultBlockState() ? null : CAVE_AIR;
    }

    protected static boolean skip(double xPos, double yPos, double zPos, double floor) {
        if (yPos <= floor) {
            return true;
        }
        return xPos * xPos + yPos * yPos + zPos * zPos >= 1.0;
    }
}

