/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.registration.ModBlocks;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

@ParametersAreNonnullByDefault
public class BismuthGeyserFeature<T extends NoneFeatureConfiguration>
extends Feature<T> {
    private static final Supplier<BlockState> GRASS = () -> ((Block)ModBlocks.murky_grass.get()).defaultBlockState();

    public BismuthGeyserFeature(Codec<T> configIn) {
        super(configIn);
    }

    public boolean place(FeaturePlaceContext<T> context) {
        return this.place(context.level(), context.origin());
    }

    public boolean place(WorldGenLevel worldIn, BlockPos position) {
        for (int cx = 0; cx < 5; ++cx) {
            for (int cz = 0; cz < 5; ++cz) {
                Block blockBelow;
                BlockPos pos = position.offset(cx - 2, 0, cz - 2);
                if (!worldIn.hasChunkAt(pos) || (blockBelow = worldIn.getBlockState(pos.below()).getBlock()) == ModBlocks.murky_grass.get()) continue;
                return false;
            }
        }
        for (int bx = -2; bx <= 2; ++bx) {
            for (int bz = -2; bz <= 2; ++bz) {
                if (Math.abs(bx) == 2 && Math.abs(bz) == 2) continue;
                if (bx == 0 && bz == 0) {
                    worldIn.setBlock(position.offset(bx, 0, bz), ((Block)ModBlocks.geyser_block.get()).defaultBlockState(), 2);
                    continue;
                }
                if (bx < 2 && bz < 2 && bx > -2 && bz > -2) {
                    worldIn.setBlock(position.offset(bx, 0, bz), ((Block)ModBlocks.boggy_soil.get()).defaultBlockState(), 2);
                    continue;
                }
                worldIn.setBlock(position.offset(bx, 0, bz), GRASS.get(), 2);
            }
        }
        for (int tx = -1; tx <= 1; ++tx) {
            for (int tz = -1; tz <= 1; ++tz) {
                if (tx == 0 && tz == 0) continue;
                worldIn.setBlock(position.offset(tx, 1, tz), GRASS.get(), 2);
            }
        }
        return true;
    }
}

