/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.world.gen.feature.config.FeatureHeightConfig;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

@ParametersAreNonnullByDefault
public class BismuthSpireFeature<T extends FeatureHeightConfig>
extends Feature<T> {
    public BismuthSpireFeature(Codec<T> configIn) {
        super(configIn);
    }

    public boolean place(FeaturePlaceContext<T> context) {
        return this.place(context.level(), context.random(), context.origin(), (FeatureHeightConfig)context.config());
    }

    public boolean place(WorldGenLevel worldIn, RandomSource rand, BlockPos position, T config) {
        for (int cx = 0; cx < 3; ++cx) {
            for (int cz = 0; cz < 3; ++cz) {
                Block blockBelow;
                BlockPos pos = position.offset(cx - 1, 0, cz - 1);
                if (!worldIn.hasChunkAt(pos) || (blockBelow = worldIn.getBlockState(pos.below()).getBlock()) == ModBlocks.murky_grass.get()) continue;
                return false;
            }
        }
        int height = ((FeatureHeightConfig)config).startHeight + rand.nextInt(4);
        int heightA = height - rand.nextInt(4) - 2;
        int heightD = height / 2 - (rand.nextInt(5) - 2);
        int heightE = rand.nextInt(3);
        for (int i = 0; i < height; ++i) {
            if (i < heightE) {
                for (int ex = -2; ex <= 2; ++ex) {
                    for (int ez = -2; ez <= 2; ++ez) {
                        if (Math.abs(ex) == 2 && Math.abs(ez) == 2) continue;
                        this.setBismuthType(worldIn, rand, position.offset(ex, i, ez));
                    }
                }
                continue;
            }
            if (i < heightD) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        this.setBismuthType(worldIn, rand, position.offset(dx, i, dz));
                    }
                }
                continue;
            }
            if (i < heightA) {
                for (int ax = -1; ax <= 1; ++ax) {
                    for (int az = -1; az <= 1; ++az) {
                        if (Math.abs(ax) == 1 && Math.abs(az) == 1) continue;
                        this.setBismuthType(worldIn, rand, position.offset(ax, i, az));
                    }
                }
                continue;
            }
            this.setBismuthType(worldIn, rand, position.above(i));
        }
        return true;
    }

    private void setBismuthType(WorldGenLevel world, RandomSource random, BlockPos pos) {
        BlockState state = random.nextInt(30) == 0 ? ((Block)ModBlocks.bismuth_block.get()).defaultBlockState() : (random.nextInt(15) == 0 ? ((Block)ModBlocks.active_rock.get()).defaultBlockState() : ((Block)ModBlocks.impure_rock.get()).defaultBlockState());
        world.setBlock(pos, state, 2);
    }
}

