/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.block.AbstractGaiaGrassBlock;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class GaiaBlobFeature<T extends BlockStateConfiguration>
extends Feature<T> {
    public GaiaBlobFeature(Codec<T> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<T> context) {
        return this.place(context.level(), context.random(), context.origin(), (BlockStateConfiguration)context.config());
    }

    public boolean place(WorldGenLevel worldIn, RandomSource rand, BlockPos pos, T config) {
        while (true) {
            BlockState block;
            if (pos.getY() <= 3 || !worldIn.isEmptyBlock(pos.below()) && ((block = worldIn.getBlockState(pos.below())).getBlock() instanceof AbstractGaiaGrassBlock || GaiaBlobFeature.isDirt((BlockState)block) || GaiaBlobFeature.isStone((BlockState)block))) {
                if (pos.getY() <= 3) {
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    int x = rand.nextInt(2);
                    int y = rand.nextInt(2);
                    int z = rand.nextInt(2);
                    float f = (float)(x + y + z) * 0.333f + 0.5f;
                    for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-x, -y, -z), (BlockPos)pos.offset(x, y, z))) {
                        if (!(blockpos.distSqr((Vec3i)pos) <= (double)(f * f))) continue;
                        worldIn.setBlock(blockpos, ((BlockStateConfiguration)config).state, 4);
                    }
                    pos = pos.offset(-1 + rand.nextInt(2), -rand.nextInt(2), -1 + rand.nextInt(2));
                }
                return true;
            }
            pos = pos.below();
        }
    }
}

